/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.process.WhitespaceLexer;
import edu.stanford.nlp.process.WordTokenFactory;
import edu.stanford.nlp.util.Maps;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class WhitespaceTokenizer<T extends HasWord>
extends AbstractTokenizer<T> {
    private WhitespaceLexer lexer;
    private final boolean eolIsSignificant;

    public static WhitespaceTokenizerFactory<CoreLabel> newCoreLabelTokenizerFactory(String options) {
        return new WhitespaceTokenizerFactory<CoreLabel>(new CoreLabelTokenFactory(), options);
    }

    public static WhitespaceTokenizerFactory<CoreLabel> newCoreLabelTokenizerFactory() {
        return new WhitespaceTokenizerFactory<CoreLabel>(new CoreLabelTokenFactory());
    }

    @Override
    protected T getNext() {
        if (this.lexer == null) {
            return null;
        }
        try {
            HasWord token = (HasWord)this.lexer.next();
            while (token != null && token.word().equals("*NL*")) {
                if (this.eolIsSignificant) {
                    return (T)token;
                }
                token = (HasWord)this.lexer.next();
            }
            return (T)token;
        }
        catch (IOException e) {
            return null;
        }
    }

    public WhitespaceTokenizer(LexedTokenFactory factory, Reader r, boolean eolIsSignificant) {
        this.eolIsSignificant = eolIsSignificant;
        if (r != null) {
            this.lexer = new WhitespaceLexer(r, factory);
        }
    }

    public static WhitespaceTokenizer<CoreLabel> newCoreLabelWhitespaceTokenizer(Reader r) {
        return new WhitespaceTokenizer<CoreLabel>(new CoreLabelTokenFactory(), r, false);
    }

    public static WhitespaceTokenizer<CoreLabel> newCoreLabelWhitespaceTokenizer(Reader r, boolean tokenizeNLs) {
        return new WhitespaceTokenizer<CoreLabel>(new CoreLabelTokenFactory(), r, tokenizeNLs);
    }

    public static WhitespaceTokenizer<Word> newWordWhitespaceTokenizer(Reader r) {
        return WhitespaceTokenizer.newWordWhitespaceTokenizer(r, false);
    }

    public static WhitespaceTokenizer<Word> newWordWhitespaceTokenizer(Reader r, boolean eolIsSignificant) {
        return new WhitespaceTokenizer<Word>(new WordTokenFactory(), r, eolIsSignificant);
    }

    public static TokenizerFactory<Word> factory() {
        return new WhitespaceTokenizerFactory<Word>(new WordTokenFactory(), false);
    }

    public static TokenizerFactory<Word> factory(boolean eolIsSignificant) {
        return new WhitespaceTokenizerFactory<Word>(new WordTokenFactory(), eolIsSignificant);
    }

    public static void main(String[] args) throws IOException {
        boolean eolIsSignificant = args.length > 0 && args[0].equals("-cr");
        InputStreamReader reader = args.length > 0 && !args[args.length - 1].equals("-cr") ? new InputStreamReader((InputStream)new FileInputStream(args[args.length - 1]), "UTF-8") : new InputStreamReader(System.in, "UTF-8");
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer(new WordTokenFactory(), reader, eolIsSignificant);
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
        while (tokenizer.hasNext()) {
            Word w = (Word)tokenizer.next();
            if (w.value().equals("*NL*")) {
                pw.println("***CR***");
                continue;
            }
            pw.println(w);
        }
    }

    public static class WhitespaceTokenizerFactory<T extends HasWord>
    implements TokenizerFactory<T> {
        private static final long serialVersionUID = -5438594683910349897L;
        private boolean tokenizeNLs;
        private final LexedTokenFactory<T> factory;

        public static TokenizerFactory<Word> newTokenizerFactory() {
            return new WhitespaceTokenizerFactory<Word>(new WordTokenFactory(), false);
        }

        public WhitespaceTokenizerFactory(LexedTokenFactory<T> factory) {
            this(factory, false);
        }

        public WhitespaceTokenizerFactory(LexedTokenFactory<T> factory, String options) {
            this.factory = factory;
            LinkedHashMap<String, String> prop = StringUtils.stringToPropertiesMap(options);
            this.tokenizeNLs = Maps.getBool(prop, "tokenizeNLs", false);
        }

        public WhitespaceTokenizerFactory(LexedTokenFactory<T> factory, boolean tokenizeNLs) {
            this.factory = factory;
            this.tokenizeNLs = tokenizeNLs;
        }

        @Override
        public Iterator<T> getIterator(Reader r) {
            return this.getTokenizer(r);
        }

        @Override
        public Tokenizer<T> getTokenizer(Reader r) {
            return new WhitespaceTokenizer(this.factory, r, this.tokenizeNLs);
        }

        @Override
        public Tokenizer<T> getTokenizer(Reader r, String extraOptions) {
            LinkedHashMap<String, String> prop = StringUtils.stringToPropertiesMap(extraOptions);
            boolean tokenizeNewlines = Maps.getBool(prop, "tokenizeNLs", this.tokenizeNLs);
            return new WhitespaceTokenizer(this.factory, r, tokenizeNewlines);
        }

        @Override
        public void setOptions(String options) {
            LinkedHashMap<String, String> prop = StringUtils.stringToPropertiesMap(options);
            this.tokenizeNLs = Maps.getBool(prop, "tokenizeNLs", this.tokenizeNLs);
        }
    }
}

