/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.QuoteAttributionUtils;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TrigramSieve
extends QMSieve {
    public TrigramSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet, "");
    }

    @Override
    public void doQuoteToMention(Annotation doc) {
        this.trigramPatterns(doc);
        this.oneSpeakerSentence(doc);
    }

    public void trigramPatterns(Annotation doc) {
        List docTokens = (List)doc.get(CoreAnnotations.TokensAnnotation.class);
        List docQuotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        for (CoreMap quote : docQuotes) {
            ArrayList<Integer> pronounsIndices;
            CoreLabel nextToken;
            Pair<Boolean, Pair<Integer, Integer>> followingPair;
            Pair<Integer, Integer> followingTokenRange;
            if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null) continue;
            int quoteBeginTokenIndex = (Integer)quote.get(CoreAnnotations.TokenBeginAnnotation.class);
            int quoteEndTokenIndex = (Integer)quote.get(CoreAnnotations.TokenEndAnnotation.class);
            Pair<Boolean, Pair<Integer, Integer>> pair = QuoteAttributionUtils.getTokenRangePrecedingQuote(doc, quote);
            Pair<Integer, Integer> precedingTokenRange = pair == null ? null : pair.second();
            if (precedingTokenRange != null) {
                ArrayList<Integer> pronounsIndices2;
                CoreLabel prevToken;
                Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>> namesAndNameIndices = this.scanForNames(precedingTokenRange);
                ArrayList names = (ArrayList)namesAndNameIndices.first;
                ArrayList nameIndices = (ArrayList)namesAndNameIndices.second;
                if (names.size() > 0) {
                    int offset = 0;
                    if (beforeQuotePunctuation.contains(((CoreLabel)docTokens.get(quoteBeginTokenIndex - 1)).word())) {
                        offset = 1;
                    }
                    Pair lastNameIndex = (Pair)nameIndices.get(nameIndices.size() - 1);
                    prevToken = (CoreLabel)docTokens.get(quoteBeginTokenIndex - 1 - offset);
                    if (prevToken.tag() != null && prevToken.tag().startsWith("V") && ((Integer)lastNameIndex.second).equals(quoteBeginTokenIndex - 2 - offset)) {
                        TrigramSieve.fillInMention(quote, (String)names.get(names.size() - 1), (Integer)lastNameIndex.first, (Integer)lastNameIndex.second, "trigram CVQ", "name");
                        continue;
                    }
                    if (((Integer)lastNameIndex.second).equals(quoteBeginTokenIndex - 1 - offset)) {
                        CoreLabel secondPrevToken;
                        CoreLabel coreLabel = secondPrevToken = (Integer)lastNameIndex.first >= 1 ? (CoreLabel)docTokens.get((Integer)lastNameIndex.first - 1) : null;
                        if (secondPrevToken != null && secondPrevToken.tag().startsWith("V")) {
                            TrigramSieve.fillInMention(quote, (String)names.get(names.size() - 1), (Integer)lastNameIndex.first, (Integer)lastNameIndex.second, "trigram VCQ", "name");
                            continue;
                        }
                    }
                }
                if ((pronounsIndices2 = this.scanForPronouns(precedingTokenRange)).size() > 0) {
                    int offset = 0;
                    if (beforeQuotePunctuation.contains(((CoreLabel)docTokens.get(quoteBeginTokenIndex - 1)).word())) {
                        offset = 1;
                    }
                    prevToken = (CoreLabel)docTokens.get(quoteBeginTokenIndex - 1 - offset);
                    int lastPronounIndex = pronounsIndices2.get(pronounsIndices2.size() - 1);
                    if (prevToken.tag().startsWith("V") && lastPronounIndex == quoteBeginTokenIndex - 2 - offset) {
                        TrigramSieve.fillInMention(quote, this.tokenRangeToString(lastPronounIndex), lastPronounIndex, lastPronounIndex, "trigram PVQ", "pronoun");
                        continue;
                    }
                    if (lastPronounIndex == quoteBeginTokenIndex - 1 - offset && ((CoreLabel)docTokens.get(quoteBeginTokenIndex - 2 - offset)).tag().startsWith("V")) {
                        TrigramSieve.fillInMention(quote, this.tokenRangeToString(lastPronounIndex), lastPronounIndex, lastPronounIndex, "trigram VPQ", "pronoun");
                        continue;
                    }
                }
            }
            if ((followingTokenRange = (followingPair = QuoteAttributionUtils.getTokenRangeFollowingQuote(doc, quote)) == null ? null : followingPair.second()) == null) continue;
            Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>> namesAndNameIndices = this.scanForNames(followingTokenRange);
            ArrayList names = (ArrayList)namesAndNameIndices.first;
            ArrayList nameIndices = (ArrayList)namesAndNameIndices.second;
            if (names.size() > 0 && docTokens.size() > quoteEndTokenIndex + 1) {
                CoreLabel secondNextToken;
                Pair firstNameIndex = (Pair)nameIndices.get(0);
                nextToken = (CoreLabel)docTokens.get(quoteEndTokenIndex + 1);
                if (nextToken.tag().startsWith("V") && ((Integer)firstNameIndex.first).equals(quoteEndTokenIndex + 2)) {
                    TrigramSieve.fillInMention(quote, (String)names.get(0), (Integer)firstNameIndex.first, (Integer)firstNameIndex.second, "trigram QVC", "name");
                    continue;
                }
                if (((Integer)firstNameIndex.first).equals(quoteEndTokenIndex + 1) && docTokens.size() > (Integer)firstNameIndex.second + 1 && (secondNextToken = (CoreLabel)docTokens.get((Integer)firstNameIndex.second + 1)).tag().startsWith("V")) {
                    TrigramSieve.fillInMention(quote, (String)names.get(0), (Integer)firstNameIndex.first, (Integer)firstNameIndex.second, "trigram QCV", "name");
                    continue;
                }
            }
            if ((pronounsIndices = this.scanForPronouns(followingTokenRange)).size() <= 0 || docTokens.size() <= quoteEndTokenIndex + 1) continue;
            nextToken = (CoreLabel)docTokens.get(quoteEndTokenIndex + 1);
            int firstPronounIndex = pronounsIndices.get(0);
            if (nextToken.tag().startsWith("V") && firstPronounIndex == quoteEndTokenIndex + 2) {
                TrigramSieve.fillInMention(quote, this.tokenRangeToString(pronounsIndices.get(0)), firstPronounIndex, firstPronounIndex, "trigram QVP", "pronoun");
                continue;
            }
            if (firstPronounIndex != quoteEndTokenIndex + 1 || docTokens.size() <= quoteEndTokenIndex + 2 || !((CoreLabel)docTokens.get(quoteEndTokenIndex + 2)).tag().startsWith("V")) continue;
            TrigramSieve.fillInMention(quote, this.tokenRangeToString(pronounsIndices.get(pronounsIndices.size() - 1)), firstPronounIndex, firstPronounIndex, "trigram QPV", "pronoun");
        }
    }
}

