/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.semgraph.semgrex.Env;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemgrexBatchParser {
    private static Redwood.RedwoodChannels log = Redwood.channels(SemgrexBatchParser.class);
    private static final int MAX_STREAM_SIZE = 0x100000;
    public static boolean VERBOSE = false;
    private static final Pattern MACRO_NAME_PATTERN = Pattern.compile("\\$\\{[a-z0-9]+\\}", 2);

    private SemgrexBatchParser() {
    }

    public static List<SemgrexPattern> compileStream(InputStream is) throws IOException {
        return SemgrexBatchParser.compileStream(is, null);
    }

    public static List<SemgrexPattern> compileStream(InputStream is, Env env) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        reader.mark(0x100000);
        Map<String, String> macros = SemgrexBatchParser.preprocess(reader);
        reader.reset();
        return SemgrexBatchParser.parse(reader, macros, env);
    }

    private static List<SemgrexPattern> parse(BufferedReader reader, Map<String, String> macros, Env env) throws IOException {
        String line;
        ArrayList<SemgrexPattern> patterns = new ArrayList<SemgrexPattern>();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("macro ")) continue;
            line = SemgrexBatchParser.replaceMacros(line, macros);
            SemgrexPattern pattern = SemgrexPattern.compile(line, env);
            patterns.add(pattern);
        }
        return patterns;
    }

    private static String replaceMacros(String line, Map<String, String> macros) {
        String postProcessed;
        StringBuilder out2 = new StringBuilder();
        Matcher matcher = MACRO_NAME_PATTERN.matcher(line);
        int offset = 0;
        while (matcher.find(offset)) {
            int end;
            int start = matcher.start();
            String name = line.substring(start + 2, (end = matcher.end()) - 1);
            String value = macros.get(name);
            if (value == null) {
                throw new RuntimeException("ERROR: Unknown macro \"" + name + "\"!");
            }
            if (start > offset) {
                out2.append(line.substring(offset, start));
            }
            out2.append(value);
            offset = end;
        }
        if (offset < line.length()) {
            out2.append(line.substring(offset));
        }
        if (!(postProcessed = out2.toString()).equals(line) && VERBOSE) {
            log.info("Line \"" + line + "\" changed to \"" + postProcessed + '\"');
        }
        return postProcessed;
    }

    private static Map<String, String> preprocess(BufferedReader reader) throws IOException {
        String line;
        Map<String, String> macros = Generics.newHashMap();
        while ((line = reader.readLine()) != null) {
            if (!(line = line.trim()).startsWith("macro ")) continue;
            Pair<String, String> macro = SemgrexBatchParser.extractMacro(line);
            macros.put(macro.first(), macro.second());
        }
        return macros;
    }

    private static Pair<String, String> extractMacro(String line) {
        assert (line.startsWith("macro"));
        int equalPosition = line.indexOf(61);
        if (equalPosition < 0) {
            throw new RuntimeException("ERROR: Invalid syntax in macro line: \"" + line + "\"!");
        }
        String name = line.substring(5, equalPosition).trim();
        if (name.isEmpty()) {
            throw new RuntimeException("ERROR: Invalid syntax in macro line: \"" + line + "\"!");
        }
        String value = line.substring(equalPosition + 1).trim();
        if (value.isEmpty()) {
            throw new RuntimeException("ERROR: Invalid syntax in macro line: \"" + line + "\"!");
        }
        return new Pair<String, String>(name, value);
    }
}

