/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentUtils;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.ejml.simple.SimpleMatrix;

public class SentimentPipeline {
    private static Redwood.RedwoodChannels log = Redwood.channels(SentimentPipeline.class);
    private static final NumberFormat NF = new DecimalFormat("0.0000");
    private static final String DEFAULT_TLPP_CLASS = "edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams";

    private SentimentPipeline() {
    }

    private static void setSentimentLabels(Tree tree) {
        if (tree.isLeaf()) {
            return;
        }
        for (Tree child : tree.children()) {
            SentimentPipeline.setSentimentLabels(child);
        }
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("Required a tree with CoreLabels");
        }
        CoreLabel cl = (CoreLabel)label;
        cl.setValue(Integer.toString(RNNCoreAnnotations.getPredictedClass(tree)));
    }

    private static int setIndexLabels(Tree tree, int index) {
        if (tree.isLeaf()) {
            return index;
        }
        tree.label().setValue(Integer.toString(index));
        ++index;
        for (Tree child : tree.children()) {
            index = SentimentPipeline.setIndexLabels(child, index);
        }
        return index;
    }

    private static int outputTreeVectors(PrintStream out2, Tree tree, int index) {
        if (tree.isLeaf()) {
            return index;
        }
        out2.print("  " + index + ':');
        SimpleMatrix vector = RNNCoreAnnotations.getNodeVector(tree);
        for (int i = 0; i < vector.getNumElements(); ++i) {
            out2.print("  " + NF.format(vector.get(i)));
        }
        out2.println();
        ++index;
        for (Tree child : tree.children()) {
            index = SentimentPipeline.outputTreeVectors(out2, child, index);
        }
        return index;
    }

    private static int outputTreeScores(PrintStream out2, Tree tree, int index) {
        if (tree.isLeaf()) {
            return index;
        }
        out2.print("  " + index + ':');
        SimpleMatrix vector = RNNCoreAnnotations.getPredictions(tree);
        for (int i = 0; i < vector.getNumElements(); ++i) {
            out2.print("  " + NF.format(vector.get(i)));
        }
        out2.println();
        ++index;
        for (Tree child : tree.children()) {
            index = SentimentPipeline.outputTreeScores(out2, child, index);
        }
        return index;
    }

    private static void outputTree(PrintStream out2, CoreMap sentence, List<Output> outputFormats) {
        Tree tree = (Tree)sentence.get(SentimentCoreAnnotations.SentimentAnnotatedTree.class);
        block6: for (Output output : outputFormats) {
            switch (output) {
                case PENNTREES: {
                    Tree copy = tree.deepCopy();
                    SentimentPipeline.setSentimentLabels(copy);
                    out2.println(copy);
                    continue block6;
                }
                case VECTORS: {
                    Tree copy = tree.deepCopy();
                    SentimentPipeline.setIndexLabels(copy, 0);
                    out2.println(copy);
                    SentimentPipeline.outputTreeVectors(out2, tree, 0);
                    continue block6;
                }
                case ROOT: {
                    out2.println("  " + (String)sentence.get(SentimentCoreAnnotations.SentimentClass.class));
                    continue block6;
                }
                case PROBABILITIES: {
                    Tree copy = tree.deepCopy();
                    SentimentPipeline.setIndexLabels(copy, 0);
                    out2.println(copy);
                    SentimentPipeline.outputTreeScores(out2, tree, 0);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown output format " + (Object)((Object)output));
        }
    }

    private static void help() {
        log.info("Known command line arguments:");
        log.info("  -sentimentModel <model>: Which model to use");
        log.info("  -parserModel <model>: Which parser to use");
        log.info("  -file <filename>: Which file to process");
        log.info("  -fileList <file>,<file>,...: Comma separated list of files to process.  Output goes to file.out");
        log.info("  -stdin: Process stdin instead of a file");
        log.info("  -input <format>: Which format to input, TEXT or TREES.  Will not process stdin as trees.  If trees are not already binarized, they will be binarized with -tlppClass's headfinder, which means they must have labels in that treebank's tagset.");
        log.info("  -output <format>: Which format to output, PENNTREES, VECTORS, PROBABILITIES, or ROOT.  Multiple formats can be specified as a comma separated list.");
        log.info("  -filterUnknown: remove unknown trees from the input.  Only applies to TREES input, in which case the trees must be binarized with sentiment labels");
        log.info("  -tlppClass: a class to use for building the binarizer if using non-binarized TREES as input.  Defaults to edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams");
    }

    public static List<Annotation> getAnnotations(StanfordCoreNLP tokenizer, Input inputFormat, String filename, boolean filterUnknown) {
        switch (inputFormat) {
            case TEXT: {
                String text = IOUtils.slurpFileNoExceptions(filename);
                Annotation annotation = new Annotation(text);
                tokenizer.annotate(annotation);
                ArrayList<Annotation> annotations = Generics.newArrayList();
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    Annotation nextAnnotation = new Annotation((String)sentence.get(CoreAnnotations.TextAnnotation.class));
                    nextAnnotation.set(CoreAnnotations.SentencesAnnotation.class, Collections.singletonList(sentence));
                    annotations.add(nextAnnotation);
                }
                return annotations;
            }
            case TREES: {
                List<Tree> trees;
                if (filterUnknown) {
                    trees = SentimentUtils.readTreesWithGoldLabels(filename);
                    trees = SentimentUtils.filterUnknownRoots(trees);
                } else {
                    MemoryTreebank treebank = new MemoryTreebank("utf-8");
                    treebank.loadPath(filename, null);
                    trees = new ArrayList<Tree>(treebank);
                }
                ArrayList<Annotation> annotations = Generics.newArrayList();
                for (Tree tree : trees) {
                    Annotation sentence = new Annotation(SentenceUtils.listToString(tree.yield()));
                    sentence.set(TreeCoreAnnotations.TreeAnnotation.class, tree);
                    List<Annotation> sentences = Collections.singletonList(sentence);
                    Annotation annotation = new Annotation("");
                    annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
                    annotations.add(annotation);
                }
                return annotations;
            }
        }
        throw new IllegalArgumentException("Unknown format " + (Object)((Object)inputFormat));
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        String[] annotations;
        String parserModel = null;
        String sentimentModel = null;
        String filename = null;
        String fileList = null;
        boolean stdin = false;
        boolean filterUnknown = false;
        List<Output> outputFormats = Collections.singletonList(Output.ROOT);
        Input inputFormat = Input.TEXT;
        String tlppClass = DEFAULT_TLPP_CLASS;
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-sentimentModel")) {
                sentimentModel = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-parserModel")) {
                parserModel = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-file")) {
                filename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-fileList")) {
                fileList = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-stdin")) {
                stdin = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-input")) {
                inputFormat = Input.valueOf(args[argIndex + 1].toUpperCase(Locale.ROOT));
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-output")) {
                String[] formats = args[argIndex + 1].split(",");
                outputFormats = new ArrayList<Output>();
                for (String format : formats) {
                    outputFormats.add(Output.valueOf(format.toUpperCase(Locale.ROOT)));
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-filterUnknown")) {
                filterUnknown = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tlppClass")) {
                tlppClass = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-help")) {
                SentimentPipeline.help();
                System.exit(0);
                continue;
            }
            log.info("Unknown argument " + args[argIndex + 1]);
            SentimentPipeline.help();
            throw new IllegalArgumentException("Unknown argument " + args[argIndex + 1]);
        }
        Properties pipelineProps = new Properties();
        Properties tokenizerProps = null;
        if (sentimentModel != null) {
            pipelineProps.setProperty("sentiment.model", sentimentModel);
        }
        if (parserModel != null) {
            pipelineProps.setProperty("parse.model", parserModel);
        }
        if (inputFormat == Input.TREES) {
            pipelineProps.setProperty("annotators", "binarizer, sentiment");
            pipelineProps.setProperty("customAnnotatorClass.binarizer", "edu.stanford.nlp.pipeline.BinarizerAnnotator");
            pipelineProps.setProperty("binarizer.tlppClass", tlppClass);
            pipelineProps.setProperty("enforceRequirements", "false");
        } else {
            pipelineProps.setProperty("annotators", "parse, sentiment");
            pipelineProps.setProperty("parse.binaryTrees", "true");
            pipelineProps.setProperty("parse.buildgraphs", "false");
            pipelineProps.setProperty("enforceRequirements", "false");
            tokenizerProps = new Properties();
            tokenizerProps.setProperty("annotators", "tokenize, ssplit");
        }
        if (stdin && tokenizerProps != null) {
            tokenizerProps.setProperty("ssplit.eolonly", "true");
        }
        int count = 0;
        if (filename != null) {
            ++count;
        }
        if (fileList != null) {
            ++count;
        }
        if (stdin) {
            ++count;
        }
        if (count > 1) {
            throw new IllegalArgumentException("Please only specify one of -file, -fileList or -stdin");
        }
        if (count == 0) {
            throw new IllegalArgumentException("Please specify either -file, -fileList or -stdin");
        }
        StanfordCoreNLP tokenizer = tokenizerProps == null ? null : new StanfordCoreNLP(tokenizerProps);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(pipelineProps);
        if (filename != null) {
            annotations = SentimentPipeline.getAnnotations(tokenizer, inputFormat, filename, filterUnknown);
            for (Annotation annotation : annotations) {
                pipeline.annotate(annotation);
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    System.out.println(sentence);
                    SentimentPipeline.outputTree(System.out, sentence, outputFormats);
                }
            }
        } else if (fileList != null) {
            void var17_25;
            annotations = fileList.split(",");
            int n = annotations.length;
            boolean bl = false;
            while (var17_25 < n) {
                String file = annotations[var17_25];
                List<Annotation> annotations2 = SentimentPipeline.getAnnotations(tokenizer, inputFormat, file, filterUnknown);
                FileOutputStream fout = new FileOutputStream(file + ".out");
                PrintStream pout = new PrintStream(fout);
                for (Annotation annotation : annotations2) {
                    pipeline.annotate(annotation);
                    for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                        pout.println(sentence);
                        SentimentPipeline.outputTree(pout, sentence, outputFormats);
                    }
                }
                pout.flush();
                fout.close();
                ++var17_25;
            }
        } else {
            String line;
            log.info("Reading in text from stdin.");
            log.info("Please enter one sentence per line.");
            log.info("Processing will end when EOF is reached.");
            BufferedReader reader = IOUtils.readerFromStdin("utf-8");
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).isEmpty()) {
                    Annotation annotation = tokenizer.process(line);
                    pipeline.annotate(annotation);
                    for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                        SentimentPipeline.outputTree(System.out, sentence, outputFormats);
                    }
                    continue;
                }
                System.out.println();
            }
        }
    }

    static enum Input {
        TEXT,
        TREES;

    }

    static enum Output {
        PENNTREES,
        VECTORS,
        ROOT,
        PROBABILITIES;

    }
}

