/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Labeled;
import edu.stanford.nlp.util.Scored;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Constituent
implements Labeled,
Scored,
Label {
    public abstract int start();

    public abstract void setStart(int var1);

    public abstract int end();

    public abstract void setEnd(int var1);

    @Override
    public Label label() {
        return null;
    }

    @Override
    public void setLabel(Label label) {
    }

    @Override
    public Collection<Label> labels() {
        return Collections.singletonList(this.label());
    }

    @Override
    public void setLabels(Collection<Label> labels) {
        throw new UnsupportedOperationException("Constituent can't be multilabeled");
    }

    @Override
    public double score() {
        return Double.NaN;
    }

    public void setScore(double score) {
    }

    @Override
    public String toString() {
        Label lab = this.label();
        StringBuilder sb = lab != null ? new StringBuilder(lab.toString()) : new StringBuilder();
        sb.append("(").append(this.start()).append(",").append(this.end()).append(")");
        return sb.toString();
    }

    public int size() {
        return this.end() - this.start();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Constituent) {
            Constituent c = (Constituent)obj;
            if (this.start() == c.start() && this.end() == c.end()) {
                Label lab1 = this.label();
                Label lab2 = c.label();
                if (lab1 == null) {
                    return lab2 == null;
                }
                String lv1 = lab1.value();
                String lv2 = lab2.value();
                if (lv1 == null && lv2 == null) {
                    return true;
                }
                if (lv1 != null && lv2 != null) {
                    return lab1.value().equals(lab2.value());
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.start() << 16 | this.end();
        Label lab = this.label();
        return lab == null || lab.value() == null ? hash : hash ^ lab.value().hashCode();
    }

    public boolean crosses(Constituent c) {
        return this.start() < c.start() && c.start() < this.end() && this.end() < c.end() || c.start() < this.start() && this.start() < c.end() && c.end() < this.end();
    }

    public boolean crosses(Collection<Constituent> constColl) {
        for (Constituent c : constColl) {
            if (!this.crosses(c)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Constituent c) {
        return this.start() <= c.start() && this.end() >= c.end();
    }

    @Override
    public String value() {
        Label lab = this.label();
        if (lab == null) {
            return null;
        }
        return lab.value();
    }

    @Override
    public void setValue(String value) {
        Label lab = this.label();
        if (lab != null) {
            lab.setValue(value);
        }
    }

    @Override
    public void setFromString(String labelStr) {
        Label lab = this.label();
        if (lab != null) {
            lab.setFromString(labelStr);
        }
    }

    public String toSentenceString(List<?> s) {
        StringBuilder sb = new StringBuilder();
        int end = this.end();
        for (int wordNum = this.start(); wordNum <= end; ++wordNum) {
            sb.append(s.get(wordNum));
            if (wordNum == end) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

