/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class OutputSubtrees {
    @ArgumentParser.Option(name="input", gloss="The file to use as input.", required=true)
    private static String INPUT;
    @ArgumentParser.Option(name="output", gloss="Where to write output.  Will write to stdout if not set.", required=false)
    private static String OUTPUT;
    @ArgumentParser.Option(name="root_only", gloss="Output only the roots", required=false)
    private static boolean ROOT_ONLY;
    @ArgumentParser.Option(name="ignore_labels", gloss="Labels to ignore as a WS-separated list.", required=false)
    private static String IGNORE_LABELS;
    @ArgumentParser.Option(name="remap_labels", gloss="Remap labels: for sentiment, for example, write '1=0,2=-1,3=1,4=1' to make it binary.  Remapping , or = currently not supported.", required=false)
    private static String REMAP_LABELS;
    @ArgumentParser.Option(name="assert_binary", gloss="Barf on non-binary trees", required=false)
    private static boolean ASSERT_BINARY;

    public static void main(String[] args) throws IOException {
        Map<Object, Object> remap;
        Set ignored;
        Properties props = StringUtils.argsToProperties(args, (Map<String, Integer>)new HashMap<String, Integer>(){
            {
                this.put("ignore_labels", 1);
                this.put("remap_labels", 1);
            }
        });
        ArgumentParser.fillOptions(new Class[]{ArgumentParser.class, OutputSubtrees.class}, props);
        if (IGNORE_LABELS != null) {
            ignored = new HashSet<String>(StringUtils.split(IGNORE_LABELS));
            System.err.println("Ignoring the following labels: " + ignored);
        } else {
            ignored = Collections.emptySet();
        }
        if (REMAP_LABELS != null) {
            remap = StringUtils.mapStringToMap(REMAP_LABELS);
            System.err.println("Remapping labels as follows: " + remap);
        } else {
            remap = Collections.emptyMap();
        }
        MemoryTreebank treebank = new MemoryTreebank("utf-8");
        treebank.loadPath(INPUT, null);
        Writer output = OUTPUT == null ? IOUtils.encodedOutputStreamWriter(System.out, "utf-8") : IOUtils.getPrintWriter(OUTPUT, "utf-8");
        int treeNum = 0;
        for (Tree tree : treebank) {
            ++treeNum;
            if (ASSERT_BINARY && !tree.isBinary()) {
                throw new RuntimeException("Tree " + treeNum + " is not properly binary");
            }
            Collection<Tree> subtrees = ROOT_ONLY ? Collections.singletonList(tree) : tree;
            for (Tree subtree : subtrees) {
                if (subtree.isLeaf()) continue;
                String value = subtree.label().value();
                List<Tree> leaves = Trees.leaves(subtree);
                List labels = leaves.stream().map(x -> x.label()).collect(Collectors.toList());
                String text = SentenceUtils.listToString(labels);
                if (ignored.contains(value)) continue;
                if (remap.containsKey(value)) {
                    value = (String)remap.get(value);
                }
                output.write(value + "   " + text + "\n");
            }
            output.write("\n");
        }
        output.flush();
        if (OUTPUT != null) {
            output.close();
        }
    }

    static {
        ROOT_ONLY = false;
        ASSERT_BINARY = false;
    }
}

