/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.trees.EnglishPatterns;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Generics;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UniversalEnglishGrammaticalRelations {
    private static final TregexPatternCompiler tregexCompiler = new TregexPatternCompiler((HeadFinder)null);
    public static final GrammaticalRelation PREDICATE = new GrammaticalRelation(Language.UniversalEnglish, "pred", "predicate", GrammaticalRelation.DEPENDENT, "S|SINV", tregexCompiler, "S|SINV <# VP=target");
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "aux", "auxiliary", GrammaticalRelation.DEPENDENT, "VP|SQ|SINV|CONJP", tregexCompiler, "VP < VP < (/^(?:MD|VB.*|AUXG?|POS)$/=target)", "SQ|SINV < (/^(?:VB|MD|AUX)/=target $++ /^(?:VP|ADJP)/)", "SINV < (VP=target < (/^(?:VB|AUX|POS)/ < /^(?i:am|is|are|r|be|being|'s|\u2019s|'re|\u2019re|'m|\u2019m|was|were|been|s|ai|m|art|ar|wase)$/) $-- (VP < VBG))");
    public static final GrammaticalRelation AUX_PASSIVE_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "aux:pass", "passive auxiliary", AUX_MODIFIER, "VP|SQ|SINV", tregexCompiler, "VP < (/^(?:VB|AUX|POS)/=target < " + EnglishPatterns.passiveAuxWordRegex + " ) < (VP|ADJP [ < VBN|VBD | < (VP|ADJP < VBN|VBD) < CC ] )", "SQ|SINV < (/^(?:VB|AUX|POS)/=target < /^(?i:am|is|are|r|be|being|'s|\u2019s|'re|\u2019re|'m|\u2019m|was|were|been|s|ai|m|art|ar|wase)$/ $++ (VP < VBD|VBN))", "SINV < (VP=target < (/^(?:VB|AUX|POS)/ < /^(?i:am|is|are|r|be|being|'s|\u2019s|'re|\u2019re|'m|\u2019m|was|were|been|s|ai|m|art|ar|wase)$/) $-- (VP < VBD|VBN))", "SINV < (VP=target < (VP < (/^(?:VB|AUX|POS)/ < /^(?i:am|is|are|r|be|being|'s|\u2019s|'re|\u2019re|'m|\u2019m|was|were|been|s|ai|m|art|ar|wase)$/)) $-- (VP < VBD|VBN))");
    public static final GrammaticalRelation COPULA = new GrammaticalRelation(Language.UniversalEnglish, "cop", "copula", AUX_MODIFIER, "VP|SQ|SINV|SBARQ", tregexCompiler, "VP < (/^(?:VB|AUX)/=target < " + EnglishPatterns.copularWordRegex + " [ $++ (/^(?:ADJP|NP$|WHNP$|PP|UCP)/ !< (VBN|VBD !$++ /^N/)) | $++ (S <: (ADJP < JJ)) ] )", "SQ|SINV < (/^(?:VB|AUX)/=target < " + EnglishPatterns.copularWordRegex + " [ $++ (ADJP !< VBN|VBD) | $++ (NP $++ NP) | $++ (S <: (ADJP < JJ)) ] )", "SBARQ < (/^(?:VB|AUX)/=target < " + EnglishPatterns.copularWordRegex + ") < (WHNP < WP)", "SINV <# (NP $++ (NP $++ (VP=target < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + "))))");
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation(Language.UniversalEnglish, "conj", "conjunct", GrammaticalRelation.DEPENDENT, "VP|(?:WH)?NP(?:-TMP|-ADV)?|ADJP|PP|QP|ADVP|UCP(?:-TMP|-ADV)?|S|NX|SBAR|SBARQ|SINV|SQ|JJP|NML|RRC|PCONJP", tregexCompiler, "VP|S|SBAR|SBARQ|SINV|SQ|RRC < (CC|CONJP $-- !/^(?:``|-LRB-|PRN|PP|ADVP|RB|MWE)/ $+ !/^(?:SBAR|PRN|``|''|-[LR]RB-|,|:|\\.)$/=target)", "SBAR < (CC|CONJP $-- @SBAR $+ @SBAR=target)", "VP|S|SBAR|SBARQ|SINV|SQ|RRC < (CC|CONJP $-- !/^(?:``|-LRB-|PRN|PP|ADVP|RB)/ $+ (ADVP $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target))", "VP|S|SBAR|SBARQ|SINV|SQ=root < (CC|CONJP $-- !/^(?:``|-LRB-|PRN|PP|ADVP|RB)/) < (/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/ $+ (/^S|SINV$|^(?:A|N|V|PP|PRP|J|W|R)/=target [$-- (CC|CONJP $-- (__ ># =root) !$++ (/^:|,$/ $++ =target)) | $-- (/^:|,$/ $-- (__ ># =root) [!$-- /^CC|CONJP$/ | $++ (=target < (/^,$/ $++ (__ ># =target)))])] ) )", "/^(?:ADJP|JJP|PP|QP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ [ < (CC|CONJP $-- !/^(?:``|-LRB-|PRN)$/ $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target) | < (FW=target < /^(?i:(etc|ect))$/) | < (ADVP|NP=target <1 (FW < /^(?i:(etc|ect))$/))]", "/^(?:ADJP|PP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ < (CC|CONJP $-- !/^(?:``|-LRB-|PRN)$/ $+ (ADVP $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target))", "/^(?:ADJP|PP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ [ < (CC|CONJP $-- !/^(?:``|-LRB-|PRN)$/) | < (FW < /^(?i:(etc|ect))$/) | < (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/))] < (/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/ [ $+ /^S|SINV$|^(?:A|N|V|PP|PRP|J|W|R)/=target | $+ (FW=target < /^(?i:(etc|ect))$/) ] )", "NX|NML [ < (CC|CONJP $- __) | < (FW < /^(?i:(etc|ect))$/)] < (/^,$/ $- /^(?:A|N|V|PP|PRP|J|W|R|S)/=target)", "/^(?:VP|S|SBAR|SBARQ|SINV|ADJP|PP|QP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ [ < (CC $++ (CC|CONJP $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target)) | <- (FW=target < /^(?i:(etc|ect))$/) | <- (ADVP|NP=target <1 (FW < /^(?i:(etc|ect))$/)) ]", "PCONJP < (CC $+ IN|TO=target)", "/.*/ < (/^(.*)$/#1%x $+ (/,/ < /\\// $+ /^(.*)$/#1%x=target))");
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation(Language.UniversalEnglish, "cc", "coordination", GrammaticalRelation.DEPENDENT, ".*", tregexCompiler, "__ ([ < (CC=target !< /^(?i:either|neither|both)$/ ) | < (CONJP=target !< (RB < /^(?i:not)$/ $+ (RB|JJ < /^(?i:only|just|merely)$/))) ] [!> /PP/ | !>2 NP])");
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation(Language.UniversalEnglish, "punct", "punctuation", GrammaticalRelation.DEPENDENT, ".*", tregexCompiler, "__ < /^(?:\\.|:|,|''|``|\\*|-LRB-|-RRB-|HYPH)$/=target", "__ < (NFP=target !< /^(?:[<>]?[:;=8][\\-o\\*'\u2019]?(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])|(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])[\\-o\\*'\u2019]?[:;=8][<>]?)$/ !< /(?!^--$)^(?:-LRB-|[(])?[\\-\\^x=~<>'\u2019][_.]?[\\-\\^x=~<>'\u2019](?:-RRB-|[)])?$/)");
    public static final GrammaticalRelation ARGUMENT = new GrammaticalRelation(Language.UniversalEnglish, "arg", "argument", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation SUBJECT = new GrammaticalRelation(Language.UniversalEnglish, "subj", "subject", ARGUMENT);
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation(Language.UniversalEnglish, "nsubj", "nominal subject", SUBJECT, "S|SQ|SBARQ|SINV|SBAR|PRN", tregexCompiler, "S=subj < ((NP|WHNP=target !< EX !<# (/^NN/ < (/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/))) $++ VP=verb) : (=subj !> VP | !<< (=verb < TO))", "S < ( NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$++ NP $++VP)", "SQ|PRN < (NP=target !< EX $++ VP)", "SQ < (NP=target !< EX $- (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") !$++ VP)", "SQ < (NP=target !< EX $- /^(?:VB|AUX)/ !$++ VP) !$-- NP|WHNP", "SQ < ((NP=target !< EX) $- (RB $- /^(?:VB|AUX)/) ![$++ VP])", "SBARQ < WHNP=target < (SQ < (VP !$-- NP))", "SBARQ < WHNP=target < (SQ < ((/^(?:VB)/ !< " + EnglishPatterns.copularWordRegex + ") !$-- NP !$++ VP))", "SBARQ < (SQ=target < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") !< VP)", "SINV < (NP|WHNP=target [ $- VP|VBZ|VBD|VBP|VB|MD|AUX | $- (@RB|ADVP $- VP|VBZ|VBD|VBP|VB|MD|AUX) | !$- __ !$ @NP] )", "SINV < (NP $++ (NP=target $++ (VP < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + "))))", "S < (NP=target $+ NP|ADJP) > VP", "SBAR < WHNP=target [ < (S < (VP !$-- NP) !< SBAR) | < (VP !$-- NP) !< S ]", "SBAR !< WHNP < (S !< (NP $++ VP)) > (VP > (S $- WHNP=target))", "SQ < ((NP < EX) $++ NP=target)", "S < (NP < EX) <+(VP) (VP < NP=target)", "SBARQ < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") < (WHNP < WP) < NP=target", "SBARQ < (WHNP=target $++ ((/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") $++ ADJP=adj !$++ (NP $++ =adj)))", "SBARQ <1 WHNP=target < (SQ < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") [< (NP < EX) | < PP])");
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.UniversalEnglish, "nsubj:pass", "nominal passive subject", NOMINAL_SUBJECT, "S|SQ", tregexCompiler, "S|SQ < (WHNP|NP=target !< EX) < (VP < (/^(?:VB|AUX)/ < " + EnglishPatterns.passiveAuxWordRegex + ")  < (VP < VBN|VBD))");
    public static final GrammaticalRelation CLAUSAL_SUBJECT = new GrammaticalRelation(Language.UniversalEnglish, "csubj", "clausal subject", SUBJECT, "S", tregexCompiler, "S < (SBAR|S=target !$+ /^,$/ $++ (VP !$-- NP))");
    public static final GrammaticalRelation CLAUSAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.UniversalEnglish, "csubj:pass", "clausal passive subject", CLAUSAL_SUBJECT, "S", tregexCompiler, "S < (SBAR|S=target !$+ /^,$/ $++ (VP < (VP < VBN|VBD) < (/^(?:VB|AUXG?)/ < " + EnglishPatterns.passiveAuxWordRegex + ") !$-- NP))", "S < (SBAR|S=target !$+ /^,$/ $++ (VP <+(VP) (VP < VBN|VBD > (VP < (/^(?:VB|AUX)/ < " + EnglishPatterns.passiveAuxWordRegex + "))) !$-- NP))");
    public static final GrammaticalRelation COMPLEMENT = new GrammaticalRelation(Language.UniversalEnglish, "comp", "complement", ARGUMENT);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation(Language.UniversalEnglish, "obj", "direct object", COMPLEMENT, "VP|SQ|SBARQ?", tregexCompiler, "VP !< (/^(?:VB|AUX)/ [ < " + EnglishPatterns.copularWordRegex + " | < " + "/^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming|remain|remains|remained|remaining)$/" + " ]) < (NP|WHNP=target [ [ !<# (/^NN/ < " + "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/" + ") !$+ NP ] | $+ NP-TMP | $+ (NP <# (/^NN/ < " + "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/" + ")) ] )  <# (__ !$++ (NP $++ (/^[:]$/ $++ =target))) ", "VP < (S < (NP|WHNP=target $++ (VP < TO)))", "SQ < (/^(?:VB)/=verb !< " + EnglishPatterns.copularWordRegex + ") $-- WHNP !< VP !< (/^(?:VB)/ ! == =verb) < (NP|WHNP=target [ [ !<# (/^NN/ < " + "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/" + ") !$+ NP ] | $+ NP-TMP | $+ (NP <# (/^NN/ < " + "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/" + ")) ] )", "SBARQ < (WHNP=target !< WRB !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) <+(SQ|SINV|S|VP) (VP !< NP|TO !< (S < (VP < TO)) !< (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " $++ (VP < VBN|VBD)) !< (PP <: IN|TO) $-- (NP !< /^-NONE-$/))", "SBAR < (WHNP=target !< WRB) < (S < NP < (VP !< SBAR !<+(VP) (PP <- IN|TO) !< (S < (VP < TO))))", "SBARQ < (WHNP=target $++ ((/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") $++ (ADJP=adj !< (PP !< NP)) $++ (NP $++ =adj)))");
    public static final GrammaticalRelation INDIRECT_OBJECT = new GrammaticalRelation(Language.UniversalEnglish, "iobj", "indirect object", COMPLEMENT, "VP", tregexCompiler, "VP < (NP=target !< /\\$/ !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) $+ (NP !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)))", "VP < (NP=target < (NP !< /\\$/ $++ (NP !<: (PRP < /^(?i:myself|yourself|himself|herself|itself|ourselves|yourselves|themselves)$/) !<: DT !< (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter|lot)$/)) !$ CC|CONJP !$ /^,$/ !$++ /^:$/))");
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.UniversalEnglish, "ccomp", "clausal complement", COMPLEMENT, "VP|SINV|S|ADJP|ADVP|NP(?:-.*)?", tregexCompiler, "VP < (S=target < (VP !<, TO|VBG|VBN) !$-- NP)", "VP < (SBAR=target < (S <+(S) VP) <, (IN|DT < /^(?i:that|whether)$/))", "VP < (SBAR=target < (SBAR < (S <+(S) VP) <, (IN|DT < /^(?i:that|whether)$/)) < CC|CONJP)", "VP < (SBAR=target < (S < VP) !$-- NP !<, (IN|WHADVP) !<2 (IN|WHADVP $- ADVP|RB))", "VP < (/^V/ < /^(?i:tell|tells|told|telling)$/) < (SBAR=target < (S < VP) $-- NP !<, (IN|WHADVP) !<2 (IN|WHADVP $- ADVP|RB))", "VP < (SBAR=target < (S < VP) !$-- NP <, (WHADVP < (WRB < /^(?i:how)$/)))", "VP < @SBARQ=target", "VP < (/^VB/ < /^(?i:have|had|has|having|'ve|\u2019ve|ve|v|'d|\u2019d|d|hvae|hav|as)$/) < (S=target < @NP < VP)", "VP < (@SBAR=target !$-- @SBAR|S !$-- /^:$/ [ == @SBAR=sbar | <# @SBAR=sbar ] ) < (/^V/ < /^(?i:ask|asks|asked|asking|know|knows|knew|knowing|specify|specifies|specified|specifying|tell|tells|told|telling|understand|understands|understood|understanding|wonder|wonders|wondered|wondering)$/) [ < (/^V/ < /^(?i:tell|tells|told|telling)$/) | < (=target !$-- NP) ] : (=sbar < (WHADVP|WHNP < (WRB !< /^(?i:how)$/) !$-- /^(?!RB|ADVP).*$/) !< (S < (VP < TO)))", "@S|SINV < (@S|SBARQ=target $+ /^(,|\\.|'')$/ !$- /^(?:CC|CONJP|:)$/ !$- (/^(?:,)$/ $- CC|CONJP) !< (VP < TO|VBG|VBN) !< (VP <1 (VP [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ]))) !< (@S !== =target $++ =target !$++ @CC|CONJP)", "ADVP < (SBAR=target [ < WHNP | ( < (IN < /^(?i:as|that)/) < (S < (VP !< TO))) ])", "ADJP < (SBAR=target !< (IN < as) < S)", "S <, (SBAR=target <, (IN < /^(?i:that|whether)$/) !$+ VP)", "@NP < JJ|NN|NNS < (SBAR=target [ !<(S < (VP < TO )) | !$-- NP|NN|NNP|NNS ] )", "VP < (/^V/ < /^(?i:say|says|said|saying|(?:add|boast|counsel|explain|inform|interject|recall|remark|respond|proclaim|report|claim|shout|whisper|yell)(?:s|ed|ing)?|(?:advis|announc|acknowledg|conced|conclud|decid|declar|observ|stat|not|inton)(?:e|es|ed|ing)|(?:confess)(?:es|ed|ing)?|(?:agree)(?:s|d|ing)?|reply|replied|replies|replying|admit|admits|admitted|admitting|hold|holds|holding|held|write|writes|writing|wrote|tell|tells|telling|told|quipped|quip|quips|quipping|think|thinks|thinking|thought)$/) < (S|S-CLF|S-TTL|SQ=target <+(S) (VP < /^VB[DZP]$/))", "@S < /^S-TPC/=target < VP");
    public static final GrammaticalRelation XCLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.UniversalEnglish, "xcomp", "xclausal complement", COMPLEMENT, "VP|ADJP|SINV", tregexCompiler, "VP < (S=target [ !$-- NP | $-- (/^V/ < /^(?i:(?:allow|ask|demand|expect|help|order|prompt)(?:s|ed|ing)?|(?:advis|convinc|declar|defin|desir|encourag|forc|implor|nam|persuad|pressur|requir|urg)(?:e|es|ed|ing)|beg|begs|begged|begging|compel|compels|compelled|compelling|lobby|lobbies|lobbied|lobbying|permit|permits|permitted|permitting|tell|tells|told|telling)$/) ] !$- (NN < order) < (VP < TO))", "ADJP < (S=target <, (VP <, TO))", "VP < (S=target !$- (NN < order) < (NP $+ NP|ADJP))", "VP <# (/^(?:VB|AUX)/ $+ (VP=target < VB|VBG))", "VP < (SBAR=target < (S !$- (NN < order) < (VP < TO))) !> (VP < (VB|AUX < be)) ", "VP < (S=target !$- (NN < order) <: NP) > VP", "VP < (S=target !< VP)", "VP < (/^VB/ $+ (@S=target < (@ADJP < /^JJ/ ! $-- @NP|S))) $-- (/^VB/ < " + EnglishPatterns.copularWordRegex + " )", "(VP < (S=target < (VP < VBG ) !< NP !$- (/^,$/ [$- @NP|VP | $- (@PP $-- @NP ) |$- (@ADVP $-- @NP)]) !$-- /^:$/ !$-- VBG))", "(VP $-- (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") < (/^VB/ < " + "/^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming|remain|remains|remained|remaining)$/" + ") < NP=target)", "VP < (/^(?:VB|AUX)/ < /^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming|remain|remains|remained|remaining)$/) < (NP|WHNP=target [ [ !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$+ NP ] | $+ NP-TMP | $+ (NP <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) ] )  <# (__ !$++ (NP $++ (/^[:]$/ $++ =target))) ", "VP=vp < NP=target <(/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " >># =vp) !$ (NP < EX)", "SINV <# (VP < (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") $-- (NP $-- NP=target))", "VP [ < ADJP=target | ( < (/^VB/ [ ( < /^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming|remain|remains|remained|remaining)$/ $++ VP=target ) | $+ (@S=target < (@ADJP < /^JJ/ ! $-- @NP|S)) ] ) !$-- (/^VB/ < " + EnglishPatterns.copularWordRegex + " )) ]", "VP < (/^V/ < /^(?i:(?:allow|ask|demand|expect|help|order|prompt)(?:s|ed|ing)?|(?:advis|convinc|declar|defin|desir|encourag|forc|implor|nam|persuad|pressur|requir|urg)(?:e|es|ed|ing)|beg|begs|begged|begging|compel|compels|compelled|compelling|lobby|lobbies|lobbied|lobbying|permit|permits|permitted|permitting|tell|tells|told|telling)$/) < NP < (S=target < (VP < TO))");
    public static final GrammaticalRelation RELATIVE = new GrammaticalRelation(Language.UniversalEnglish, "rel", "relative", COMPLEMENT, "SBAR|SBARQ", tregexCompiler, "SBAR < (WHNP=target !< WRB) < (S < NP < (VP [ < SBAR | <+(VP) (PP <- IN|TO) | < (S < (VP < TO)) ] ))", "SBARQ < (WHNP=target !< WRB !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) <+(SQ|SINV) (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " !$++ VP)");
    public static final GrammaticalRelation PREPOSITION = new GrammaticalRelation(Language.UniversalEnglish, "prep", "preposition", COMPLEMENT, "VP|ADJP", tregexCompiler, "VP|ADJP < (PP=target <: IN|TO)");
    public static final GrammaticalRelation REFERENT = new GrammaticalRelation(Language.UniversalEnglish, "ref", "referent", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation EXPLETIVE = new GrammaticalRelation(Language.UniversalEnglish, "expl", "expletive", GrammaticalRelation.DEPENDENT, "S|SQ|SINV", tregexCompiler, "S|SQ|SINV < (NP=target <+(NP) EX)");
    public static final GrammaticalRelation MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "mod", "modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation NOMINAL_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "nmod", "nominal modifier", MODIFIER, ".*", tregexCompiler, "/^(?:(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?|PRN)$/ < (WHPP|WHPP-TMP|PP|PP-TMP=target [< @NP|WHNP|NML | < (PP < @NP|WHNP|NML)]) !<- (FW < /^(?i:(etc|ect))$/) !<- (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/))", "/^(?:(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?|PRN)$/ < (S=target <: WHPP|WHPP-TMP|PP|PP-TMP)", "@NP < (@UCP|PRN=target <# @PP)");
    public static final GrammaticalRelation OBLIQUE_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "obl", "oblique modifier", MODIFIER, ".*", tregexCompiler, "/^(?:(?:WH)?(?:ADJP|ADVP)(?:-TMP|-ADV)?|VP|NAC|SQ|FRAG|X|RRC)$/ < (WHPP|WHPP-TMP|PP|PP-TMP=target [< @NP|WHNP|NML | < (PP < @NP|WHNP|NML)]) !<- (FW < /^(?i:(etc|ect))$/) !<- (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/))", "/^(?:(?:WH)?(?:ADJP|ADVP)(?:-TMP|-ADV)?|VP|NAC|SQ|FRAG|X|RRC)$/ < (S=target <: WHPP|WHPP-TMP|PP|PP-TMP)", "SBARQ < (WHNP=target $++ ((/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + ") $++ (ADJP=adj < (PP <: IN)) $++ (NP $++ =adj)))", "SBARQ < (WHNP=target [$++ (VP < (PP <: IN)) | $++ (SQ < (VP < (PP <: IN)))])", "SBAR|SBARQ < /^(?:WH)?PP/=target < S|SQ", "WHPP|WHPP-TMP|WHPP-ADV|PP|PP-TMP|PP-ADV < (WHPP|WHPP-TMP|WHPP-ADV|PP|PP-TMP|PP-ADV=target !$- IN|VBG|VBN|TO)", "S|SINV < (PP|PP-TMP=target !< SBAR|S) < VP|S", "@ADJP > @NP < (@NP|NN|NNP|NNS|NNPS=target . (HYPH . VBN|VBG))");
    public static final GrammaticalRelation ADV_CLAUSE_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "advcl", "adverbial clause modifier", MODIFIER, "VP|S|SQ|SINV|SBARQ|NP|ADVP|ADJP", tregexCompiler, "VP < (@SBAR=target <= (@SBAR [ < (IN|MWE !< /^(?i:that|whether)$/) | <: (SINV <1 /^(?:VB|MD|AUX)/) | < (RB|IN < so|now) < (IN < that) | <1 (ADVP < (RB < now)) <2 (IN < that) ] ))", "S|SQ|SINV < (SBAR|SBAR-TMP=target <, (IN|MWE !< /^(?i:that|whether)$/ !$+ (NN < order)) !$-- /^(?!CC|CONJP|``|,|INTJ|PP(-.*)?).*$/ !$+ VP)", "S|SQ|SINV < (SBAR|SBAR-TMP=target <, (IN|MWE !< /^(?i:that|whether)$/ !$+ (NN < order)) !$+ @VP $+ /^,$/ $++ @NP)", "SBARQ < (SBAR|SBAR-TMP|SBAR-ADV=target <, (IN|MWE !< /^(?i:that|whether)$/ !$+ (NN < order)) $+ /^,$/ $++ @SQ|S|SBARQ)", "S|SQ < (@SBAR=target [ == @SBAR=sbar | <# @SBAR=sbar ] ): (=sbar < (WHADVP|WHNP < (WRB !< /^(?i:how)$/) !$-- /^(?!RB|ADVP).*$/) !< (S < (VP < TO)) !$-- /^:$/)", "VP < (@SBAR=target !$-- /^:$/ [ == @SBAR=sbar | <# @SBAR=sbar ] ) [ !< (/^V/ < /^(?i:ask|asks|asked|asking|know|knows|knew|knowing|specify|specifies|specified|specifying|tell|tells|told|telling|understand|understands|understood|understanding|wonder|wonders|wondered|wondering)$/) | < (=target $-- @SBAR|S) | ( !< (/^V/ < /^(?i:tell|tells|told|telling)$/) < (=target $-- NP)) ] : (=sbar < (WHADVP|WHNP < (WRB !< /^(?i:how)$/) !$-- /^(?!RB|ADVP).*$/) !< (S < (VP < TO)))", "@S < (@SBAR=target $++ @NP $++ @VP)", "@S < (@S=target < (VP < TO) $+ (/^,$/ $++ @NP))", "NP < (NP $++ (SBAR=target < (IN|MWE < /^(?i:than)$/) !< (WHPP|WHNP|WHADVP) < (S < (@NP $++ (VP !< (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " !$+ VP)  !<+(VP) (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " $+ (VP < VBN|VBD)) !<+(VP) NP !< SBAR !<+(VP) (PP <- IN|TO|MWE)))) !<: (S !< (VP < TO))) !$++ (CC $++ =target))", "ADVP < ADVP < SBAR=target", "S|SINV < (S=target (< VP=verb | < (VP <1 VP=verb)) [ $- (/^,$/ [ $- @NP | $- (@PP $ @NP) ] ) | $+ (/^,$/ $+ @NP) ] ) : (=verb [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ])", "(VP < (@S=target < (VP [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ]) $- (/^,$/ [$- @NP|VP | $- (@PP $-- @NP ) |$- (@ADVP $-- @NP)])))", "(VP < (S=target < (VP < VBG) $-- VBG=ing !$-- (/^[:]$/ $-- =ing)))", "VP < (S=target $-- NP < (VP < TO) !$-- (/^V/ < /^(?i:(?:allow|ask|demand|expect|help|order|prompt)(?:s|ed|ing)?|(?:advis|convinc|declar|defin|desir|encourag|forc|implor|nam|persuad|pressur|requir|urg)(?:e|es|ed|ing)|beg|begs|begged|begging|compel|compels|compelled|compelling|lobby|lobbies|lobbied|lobbying|permit|permits|permitted|permitting|tell|tells|told|telling)$/) )", "SBARQ < WHNP < (S=target < (VP <1 TO))", "/^(?:(?:WH)?(?:ADJP|ADVP)(?:-TMP|-ADV)?|VP|SQ|FRAG|PRN|X|RRC|S)$/ < (WHPP|WHPP-TMP|PP|PP-TMP=target !< @NP|WHNP|NML !$- (@CC|CONJP $- __) !<: IN|TO !< @CC|CONJP < /^((?!(PP|IN)).)*$/) !<- (FW < /^(?i:(etc|ect))$/) !<- (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/))", "VP|ADJP < /^PP(?:-TMP|-ADV)?$/=target < (@PP < @SBAR|S $++ CONJP|CC)");
    public static final GrammaticalRelation MARKER = new GrammaticalRelation(Language.UniversalEnglish, "mark", "marker", MODIFIER, "SBAR(?:-TMP)?|VP|PP(?:-TMP|-ADV)?", tregexCompiler, "VP < VP < (TO=target)", "SBAR|SBAR-TMP < (IN|DT|MWE=target $++ S|FRAG)", "SBAR < (IN|DT=target < that|whether) [ $-- /^(?:VB|AUX)/ | $- NP|NN|NNS | > ADJP|PP | > (@NP|UCP|SBAR < CC|CONJP $-- /^(?:VB|AUX)/) ]", "/^PP(?:-TMP|-ADV)?$/ < (IN|TO|MWE|PCONJP|VBN|JJ=target $+ @SBAR|S)");
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "amod", "adjectival modifier", MODIFIER, "NP(?:-TMP|-ADV)?|NX|NML|NAC|WHNP|ADJP|INTJ", tregexCompiler, "/^(?:NP(?:-TMP|-ADV)?|NX|NML|NAC|WHNP|INTJ)$/ < (ADJP|WHADJP|JJ|JJR|JJS|JJP|VBN|VBG|VBD|IN=target !< (QP !< /^[$]$/) !$- CC)", "ADJP !< CC|CONJP < (JJ|NNP $ JJ|NNP=target)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (NP=target <: CD $- /^,$/ $-- /^(?:WH)?NP/ !$ CC|CONJP)");
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "nummod", "numeric modifier", MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?|NML|NX|ADJP|WHADJP|QP", tregexCompiler, "/^(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?$/ < (CD|QP=target !$- CC)", "/^(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?$/ < (ADJP=target <: (QP !< /^[$]$/))", "QP < QP=target < /^[$]$/");
    public static final GrammaticalRelation COMPOUND_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "compound", "compound modifier", MODIFIER, "(?:WH)?(?:NP|NX|NAC|NML|ADVP|ADJP|QP)(?:-TMP|-ADV)?", tregexCompiler, "/^(?:WH)?(?:NP|NX|NAC|NML)(?:-TMP|-ADV)?$/ < (NP|NML|NN|NNS|NNP|NNPS|FW|AFX=target $++ NN|NNS|NNP|NNPS|FW|CD=sister !<<- POS !<<- (VBZ < /^['\u2019]s$/) !$- /^,$/ !$++ (POS $++ =sister))", "/^(?:WH)?(?:NP|NX|NAC|NML)(?:-TMP|-ADV)?$/ < JJ|JJR|JJS=sister < (NP|NML|NN|NNS|NNP|NNPS|FW=target !<<- POS !<<- (VBZ < /^['\u2019]s$/) $+ =sister) <# NN|NNS|NNP|NNPS !<<- POS !<<- (VBZ < /^['\u2019]s$/) ", "QP|ADJP < (/^(?:CD|$|#)$/=target !$- CC)", "@NP < (/^[$]$/=target $+ /^N.*/)", "ADJP|ADVP < (FW [ $- (FW=target !< /^(?i:etc)$/) | $- (IN=target < in|In) ] )");
    public static final GrammaticalRelation NAME_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "name", "name", MODIFIER);
    public static final GrammaticalRelation APPOSITIONAL_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "appos", "appositional modifier", MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?|FRAG", tregexCompiler, "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV|FRAG < (NP=target !<: CD $- /^,$/ $-- /^(?:WH)?NP/) !< CC|CONJP !< (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) !< (FW < /^(?i:(etc|ect))$/)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV|FRAG < (PRN=target < (NP < /^(?:NN|CD)/ $-- /^-LRB-$/ $+ /^-RRB-$/))", "@WHNP|NP < (NP=target !<: CD <, /^-LRB-$/ <` /^-RRB-$/ $-- /^(?:WH)?NP/ !$ CC|CONJP)", "NP|NP-TMP|NP-ADV < (NNP $+ (/^,$/ $+ NNP=target)) !< CC|CONJP !< (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) !< (FW < /^(?i:(etc|ect))$/)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (PRN=target <, /^-LRB-$/ <- /^-RRB-$/ !<< /^(?:POS|(?:WP|PRP)\\$|[,$#]|CC|RB|CD)$/ <+(NP) (NNP|NN < /^(?:[A-Z]\\.?){2,}/) )", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (NP=target <: NNP $- (/^(?:WH)?NP/ !< POS)) !< CC|CONJP !< (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) !< (FW < /^(?i:(etc|ect))$/)", "FRAG|NP < (NP $+ (/:/ $+ @SQ|S=target) <: NN|NNS)");
    public static final GrammaticalRelation DISCOURSE_ELEMENT = new GrammaticalRelation(Language.UniversalEnglish, "discourse", "discourse element", MODIFIER, ".*", tregexCompiler, "__ < (NFP=target [ < /^(?:[<>]?[:;=8][\\-o\\*'\u2019]?(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])|(?:-RRB-|-LRB-|[()DPdpO\\/\\\\\\:}{@\\|\\[\\]])[\\-o\\*'\u2019]?[:;=8][<>]?)$/ | < /(?!^--$)^(?:-LRB-|[(])?[\\-\\^x=~<>'\u2019][_.]?[\\-\\^x=~<>'\u2019](?:-RRB-|[)])?$/ ] )", "__ [ < INTJ=target | < (PRN=target <1 /^(?:,|-LRB-)$/ <2 INTJ [ !<3 __ | <3 /^(?:,|-RRB-)$/ ] ) ]");
    public static final GrammaticalRelation CLAUSAL_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "acl", "clausal modifier of noun", MODIFIER, "WHNP|WHNP-TMP|WHNP-ADV|NP(?:-[A-Z]+)?|NML|NX", tregexCompiler, "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV|NML|NX < (VP=target < VBG|VBN|VBD $-- @NP|NML|NX)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV|NML|NX < (/^,$/ $+ (VP=target [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ]))", "/^(?:(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?)$/ < (WHPP|WHPP-TMP|PP|PP-TMP=target !< @NP|WHNP|NML !$- (@CC|CONJP $- __) < /^((?!(PP|CC|CONJP|,)).)*$/  !< (@PP <1 IN|RB|MWE|PCONJP|VBN|JJ <2 @NP))  !<- (FW < /^(?i:(etc|ect))$/) !<- (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/))", "/^NP(?:-[A-Z]+)?$/ < (S=target < (VP < TO) $-- NP|NN|NNP|NNS)", "/^NP(?:-[A-Z]+)?$/ < (SBAR=target < (S < (VP < TO)) $-- NP|NN|NNP|NNS)");
    public static final GrammaticalRelation RELATIVE_CLAUSE_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "acl:relcl", "relative clause modifier", CLAUSAL_MODIFIER, "(?:WH)?(?:NP|NML|ADVP)(?:-.*)?", tregexCompiler, "@NP|WHNP|NML=np $++ (SBAR=target [ <+(SBAR) WHPP|WHNP | <: (S !< (VP < TO)) ]) !$-- @NP|WHNP|NML !$++ (FW < /^(?i:(etc|ect))$/) !$++ (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) > @NP|WHNP : (=np !$++ (CC|CONJP $++ =target))", "NP|NML $++ (SBAR=target < (WHADVP < (WRB </^(?i:where|why|when)/))) !$-- NP|NML !$++ (FW < /^(?i:(etc|ect))$/) !$++ (ADVP|NP <1 (FW < /^(?i:(etc|ect))$/)) > @NP", "@NP|WHNP < RRC=target <# NP|WHNP|NML|DT|S", "@ADVP < (@ADVP < (RB < /where$/)) < @SBAR=target", "NP < (NP $++ (SBAR=target !< (IN < /^(?i:than|that|whether)$/) !< (WHPP|WHNP|WHADVP) < (S < (@NP $++ (VP !< (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " !$+ VP)  !<+(VP) (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " $+ (VP < VBN|VBD)) !<+(VP) NP !< SBAR !<+(VP) (PP <- IN|TO)))) !<: (S !< (VP < TO))) !$++ (CC $++ =target))");
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "advmod", "adverbial modifier", MODIFIER, "VP|ADJP|WHADJP|ADVP|WHADVP|S|SBAR|SINV|SQ|SBARQ|XS|(?:WH)?(?:PP|NP)(?:-TMP|-ADV)?|RRC|CONJP|JJP|QP", tregexCompiler, "/^(?:VP|ADJP|JJP|WHADJP|SQ?|SBARQ?|SINV|XS|RRC|(?:WH)?NP(?:-TMP|-ADV)?)$/ < (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< (FW < /^(?i:(etc|ect))$/) [!<+(/ADVP/) (@ADVP < (IN < /(?i:at)/)) |  !<+(/ADVP/) (@ADVP < NP)] )", "QP < IN|RB|RBR|RBS|PDT|DT|JJ|JJR|JJS|XS=target", "QP < (MWE=target < (JJR|RBR|IN < /^(?i)(more|less)$/) < (IN < /^(?i)than$/))", "ADVP|WHADVP < (RB|RBR|RBS|WRB|ADVP|WHADVP|JJ=target !< (FW < /^(?i:(etc|ect))$/)) [ !< /^CC|CONJP$/ | ( <#__=head !< (/^CC|CONJP$/ [ ($++ =head $-- =target) | ($-- =head $++ =target) ])) ]", "SBAR < (WHNP=target < WRB)", "SBARQ <, WHADVP=target", "XS < JJ=target", "/(?:WH)?PP(?:-TMP|-ADV)?$/ <# (__ $-- (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< (FW < /^(?i:(etc|ect))$/)))", "/(?:WH)?PP(?:-TMP|-ADV)?$/ < @NP|WHNP < (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< (FW < /^(?i:(etc|ect))$/))", "CONJP < (RB=target !< (FW < /^(?i:(etc|ect))$/))", "ADJP < (JJ|JJR|JJS=target $. JJ|JJR|JJS !< /^[A-Z]/) <# JJ|JJR|JJS !< (CC|CONJP)");
    public static final GrammaticalRelation NEGATION_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "neg", "negation modifier", ADVERBIAL_MODIFIER, "XXXX", tregexCompiler, "/^(?:VP|NP(?:-TMP|-ADV)?|ADJP|SQ|S|FRAG|CONJP|PP)$/< (RB=target < /^(?i:n[o'\u2019]?t|never)$/)", "VP|ADJP|S|SBAR|SINV|FRAG < (ADVP=target <# (RB < /^(?i:n[o'\u2019]?t|never)$/))", "VP > SQ $-- (RB=target < /^(?i:n[o'\u2019]?t|never)$/)", "/^(?:NP(?:-TMP|-ADV)?|NAC|NML|NX|ADJP|ADVP)$/ < (DT|RB=target < /^(?i:no)$/  $++ /^(?:N[MNXP]|CD|JJ|JJR|FW|ADJP|QP|RB|RBR|PRP(?![$])|PRN)/ )", "ADVP|WHADVP < (RB|RBR|RBS|WRB|ADVP|WHADVP|JJ=target < /^(?i:no)$/) !< CC|CONJP");
    public static final GrammaticalRelation NP_ADVERBIAL_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "obl:npmod", "noun phrase adverbial modifier", MODIFIER, "VP|(?:WH)?(?:NP|ADJP|ADVP|PP|QP)(?:-TMP|-ADV)?", tregexCompiler, "@ADVP|ADJP|WHADJP|WHADVP|PP|WHPP <# (JJ|JJR|IN|RB|RBR !< notwithstanding $- (@NP=target !< NNP|NNPS))", "@ADJP < (NN=target $++ /^JJ/) !< CC|CONJP", "@ADVP <# (/^(RB|ADVP)/ $++ @NP=target)", "@NP|WHNP < /^NP-ADV/=target", "@NP|WHNP [ < (NP=target <: (PRP < /^(?i:myself|yourself|himself|herself|itself|ourselves|yourselves|themselves)$/)) | < (PRP=target < /^(?i:myself|yourself|himself|herself|itself|ourselves|yourselves|themselves)$/) ] : (=target $-- NP|NN|NNS|NNP|NNPS|PRP=noun !$-- (/^,|CC|CONJP$/ $-- =noun))", "@NP <1 (@NP <<# /^%$/) <2 (@NP=target <<# days|month|months) !<3 __", "@VP < /^NP-ADV/=target", "@NP|ADVP|QP <+(/ADVP/) (@ADVP=target < (IN < /(?i:at)/) < NP)");
    public static final GrammaticalRelation TEMPORAL_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "obl:tmod", "temporal modifier", NOMINAL_MODIFIER, "VP|S|ADJP|PP|SBAR|SBARQ|NP|RRC", tregexCompiler, "VP|ADJP|RRC [ < NP-TMP=target | < (VP=target <# NP-TMP !$ /^,|CC|CONJP$/) | < (NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$+ (/^JJ/ < old)) ]", "@PP < (IN|TO|VBG|FW $++ (@NP [ $+ NP-TMP=target | $+ (NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) ]))", "S < (NP-TMP=target $++ VP $ NP )", "S < (NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) $++ (NP $++ VP))", "SBAR < (@WHADVP < (WRB < when)) < (S < (NP $+ (VP !< (/^(?:VB|AUX)/ < " + EnglishPatterns.copularWordRegex + " !$+ VP) ))) !$-- CC $-- NP > NP=target", "SBARQ < (@WHNP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) < (SQ < @NP)", "NP < NP-TMP=target");
    public static final GrammaticalRelation MULTI_WORD_EXPRESSION = new GrammaticalRelation(Language.UniversalEnglish, "fixed", "multi-word expression", MODIFIER, "MWE", tregexCompiler, "MWE < (IN|TO|RB|NP|NN|JJ|VB|CC|VBZ|VBD|ADVP|PP|JJS|RBS=target)");
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation(Language.UniversalEnglish, "det", "determiner", MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?|NAC|NML|NX|X|ADVP|ADJP", tregexCompiler, "/^(?:NP(?:-TMP|-ADV)?|NAC|NML|NX|X)$/ < (DT=target !< /^(?i:either|neither|both)$/ !$+ DT !$++ CC $++ /^(?:N[MNXP]|CD|JJ|FW|ADJP|QP|RB|PRP(?![$])|PRN)/=det !$++ (/^PRP[$]|POS/ $++ =det !$++ (/''/ $++ =det)))", "NP|NP-TMP|NP-ADV < (DT=target [ (< /^(?i:either|neither|both)$/ !$+ DT !$++ CC $++ /^(?:NN|NX|NML)/ !$++ (NP < CC)) | (!< /^(?i:either|neither|both)$/ $++ CC $++ /^(?:NN|NX|NML)/) ] ) ", "NP|NP-TMP|NP-ADV <<, PRP <- (NP|DT|RB=target <<- /^(?i:all|both|each)$/)", "WHNP < (NP $-- (WHNP=target < WDT))", "@WHNP|ADVP|ADJP < (/^(?:NP|NN|CD|RBS|JJ)/ $-- (DT|WDT|WP=target [ ==WDT|WP | !$++ CC|CONJP ]))", "@NP < (/^(?:NP|NN|CD|RBS)/ $-- WDT|WP=target)");
    public static final GrammaticalRelation PREDETERMINER = new GrammaticalRelation(Language.UniversalEnglish, "det:predet", "predeterminer", MODIFIER, "(?:WH)?(?:NP|NX|NAC|NML)(?:-TMP|-ADV)?", tregexCompiler, "/^(?:(?:WH)?NP(?:-TMP|-ADV)?|NX|NAC|NML)$/ < (PDT|DT=target $+ /^(?:DT|WP\\$|PRP\\$)$/ $++ /^(?:NN|NX|NML)/ !$++ CC)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (PDT|DT=target $+ DT $++ (/^JJ/ !$+ /^NN/)) !$++ CC", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < PDT=target <- DT");
    public static final GrammaticalRelation PRECONJUNCT = new GrammaticalRelation(Language.UniversalEnglish, "cc:preconj", "preconjunct", MODIFIER, "S|VP|ADJP|PP|ADVP|UCP(?:-TMP|-ADV)?|NX|NML|SBAR|NP(?:-TMP|-ADV)?", tregexCompiler, "NP|NP-TMP|NP-ADV|NX|NML < (PDT|CC|DT=target < /^(?i:either|neither|both)$/ $++ CC)", "NP|NP-TMP|NP-ADV|NX|NML < (CONJP=target < (RB < /^(?i:not)$/) < (RB|JJ < /^(?i:only|merely|just)$/) $++ CC|CONJP)", "NP|NP-TMP|NP-ADV|NX|NML < (PDT|CC|DT=target < /^(?i:either|neither|both)$/ ) < (NP < CC)", "/^S|VP|ADJP|PP|ADVP|UCP(?:-TMP|-ADV)?|NX|NML|SBAR$/ < (PDT|DT|CC=target < /^(?i:either|neither|both)$/ $++ CC)", "/^S|VP|ADJP|PP|ADVP|UCP(?:-TMP|-ADV)?|NX|NML|SBAR$/ < (CONJP=target < (RB < /^(?i:not)$/) < (RB|JJ < /^(?i:only|merely|just)$/) $++ CC|CONJP)");
    public static final GrammaticalRelation POSSESSION_MODIFIER = new GrammaticalRelation(Language.UniversalEnglish, "nmod:poss", "possession modifier", MODIFIER, "(?:WH)?(NP|ADJP|INTJ|PRN|NAC|NX|NML)(?:-.*)?", tregexCompiler, "/^(?:WH)?(?:NP|INTJ|ADJP|PRN|NAC|NX|NML)(?:-.*)?$/ < /^(?:WP\\$|PRP\\$)$/=target", "/^(?:WH)?(?:NP|NML)(?:-.*)?$/ [ < (WHNP|WHNML|NP|NML=target [ < POS | < (VBZ < /^['\u2019]s$/) ] ) !< (CC|CONJP $++ WHNP|WHNML|NP|NML) |  < (WHNP|WHNML|NP|NML=target < (CC|CONJP $++ WHNP|WHNML|NP|NML) < (WHNP|WHNML|NP|NML [ < POS | < (VBZ < /^['\u2019]s$/) ] )) ]", "/^(?:WH)?(?:NP|NML|NX)(?:-.*)?$/ < (/^NN|NP/=target $++ (POS=pos < /['\u2019]/ $++ /^NN/) !$++ (/^NN|NP/ $++ =pos))");
    public static final GrammaticalRelation CASE_MARKER = new GrammaticalRelation(Language.UniversalEnglish, "case", "case marker", MODIFIER, "(?:WH)?(?:PP.*|SBARQ|NP|NML|ADVP)(?:-TMP|-ADV)?", tregexCompiler, "/(?:WH)?PP(?:-TMP)?/ < (IN|TO|MWE|PCONJP|VBN|JJ=target !$+ @SBAR [!$+ @S | $+ (S <, (VP <, NN))] )", "/^(?:WH)?(?:NP|NML)(?:-TMP|-ADV)?$/ < POS=target", "/^(?:WH)?(?:NP|NML)(?:-TMP|-ADV)?$/ < (VBZ=target < /^['\u2019]s$/)", "/(?:WH)?PP(?:-TMP)?/ <1 CC=target <2 NP", "/(?:WH)?PP(?:-TMP)?/ <, VBG=target !< (@PP < @SBAR|S)", "@ADVP < IN=target");
    public static final GrammaticalRelation PHRASAL_VERB_PARTICLE = new GrammaticalRelation(Language.UniversalEnglish, "compound:prt", "phrasal verb particle", MODIFIER, "VP|ADJP", tregexCompiler, "VP < PRT=target", "ADJP < /^VB/ < RP=target");
    public static final GrammaticalRelation PARATAXIS = new GrammaticalRelation(Language.UniversalEnglish, "parataxis", "parataxis", GrammaticalRelation.DEPENDENT, "S|VP|FRAG|NP", tregexCompiler, "VP < (PRN=target < S|SINV|SBAR)", "VP ># (__ < (PRN=target [ < S|SINV|SBAR | < VP < @NP ] ))", "S|FRAG|VP < (/^:$/ $+ /^S/=target) !<, (__ $++ CC|CONJP)", "@S|FRAG < (@S|SBARQ|SQ|FRAG $++ @S|SBARQ|SQ|FRAG=target !$++ @CC|CONJP|MWE !$++ (/:/ < /;/))", "@S|FRAG|VP < (/^:$/ $-- /^V/ $+ @NP=target) !< @CONJP|CC", "FRAG|NP < (NP $+ (/:/ $+ @SQ|S=target) << NNP|NNPS)");
    public static final GrammaticalRelation GOES_WITH = new GrammaticalRelation(Language.UniversalEnglish, "goeswith", "goes with", MODIFIER, ".*", tregexCompiler, "__ < GW=target");
    public static final GrammaticalRelation LIST = new GrammaticalRelation(Language.UniversalEnglish, "list", "list", GrammaticalRelation.DEPENDENT, "FRAG", tregexCompiler, "FRAG < (NP $+ (/,/ $+ (NP=target $+ (/,/ $+ NP))) !$++ CC|CONJP|MWE)", "FRAG < (NP $+ (/,/ $+ (NP $++ (/,/ $+ NP=target))) !$++ CC|CONJP|MWE)");
    public static final GrammaticalRelation QMOD = new GrammaticalRelation(Language.UniversalEnglish, "det:qmod", "quantificational modifier", DETERMINER);
    public static final GrammaticalRelation CONTROLLING_NOMINAL_SUBJECT = new GrammaticalRelation(Language.UniversalEnglish, "nsubj:xsubj", "controlling nominal subject", NOMINAL_SUBJECT);
    public static final GrammaticalRelation CONTROLLING_NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.UniversalEnglish, "nsubj:pass:xsubj", "controlling nominal passive subject", NOMINAL_PASSIVE_SUBJECT);
    public static final GrammaticalRelation CONTROLLING_CLAUSAL_SUBJECT = new GrammaticalRelation(Language.UniversalEnglish, "csubj:xsubj", "controlling clausal subject", NOMINAL_PASSIVE_SUBJECT);
    public static final GrammaticalRelation CONTROLLING_CLAUSAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.UniversalEnglish, "csubjpass:xsubj", "controlling clausal passive subject", NOMINAL_PASSIVE_SUBJECT);
    public static final GrammaticalRelation SEMANTIC_DEPENDENT = new GrammaticalRelation(Language.UniversalEnglish, "sdep", "semantic dependent", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation AGENT = new GrammaticalRelation(Language.UniversalEnglish, "obl:agent", "agent", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation ORPHAN = new GrammaticalRelation(Language.UniversalEnglish, "orphan", "orphan", GrammaticalRelation.DEPENDENT, "GAPPINGP", tregexCompiler, "GAPPINGP < __=target");
    private static final List<GrammaticalRelation> values = Generics.newArrayList(Arrays.asList(GrammaticalRelation.GOVERNOR, GrammaticalRelation.DEPENDENT, PREDICATE, AUX_MODIFIER, AUX_PASSIVE_MODIFIER, COPULA, CONJUNCT, COORDINATION, PUNCTUATION, ARGUMENT, SUBJECT, NOMINAL_SUBJECT, NOMINAL_PASSIVE_SUBJECT, CLAUSAL_SUBJECT, CLAUSAL_PASSIVE_SUBJECT, COMPLEMENT, DIRECT_OBJECT, INDIRECT_OBJECT, NOMINAL_MODIFIER, OBLIQUE_MODIFIER, CLAUSAL_COMPLEMENT, XCLAUSAL_COMPLEMENT, MARKER, RELATIVE, REFERENT, EXPLETIVE, MODIFIER, ADV_CLAUSE_MODIFIER, TEMPORAL_MODIFIER, RELATIVE_CLAUSE_MODIFIER, NUMERIC_MODIFIER, ADJECTIVAL_MODIFIER, COMPOUND_MODIFIER, NAME_MODIFIER, APPOSITIONAL_MODIFIER, CLAUSAL_MODIFIER, ADVERBIAL_MODIFIER, NEGATION_MODIFIER, MULTI_WORD_EXPRESSION, DETERMINER, PREDETERMINER, PRECONJUNCT, POSSESSION_MODIFIER, CASE_MARKER, PHRASAL_VERB_PARTICLE, SEMANTIC_DEPENDENT, AGENT, NP_ADVERBIAL_MODIFIER, PARATAXIS, DISCOURSE_ELEMENT, GOES_WITH, LIST, PREPOSITION, QMOD, CONTROLLING_NOMINAL_SUBJECT, CONTROLLING_NOMINAL_PASSIVE_SUBJECT, CONTROLLING_CLAUSAL_SUBJECT, CONTROLLING_CLAUSAL_PASSIVE_SUBJECT, ORPHAN));
    private static final List<GrammaticalRelation> synchronizedValues = Collections.synchronizedList(values);
    private static final List<GrammaticalRelation> unmodifiableSynchronizedValues = Collections.unmodifiableList(values);
    public static final ReadWriteLock valuesLock = new ReentrantReadWriteLock();
    public static final Set<GrammaticalRelation> clauseRelations = Collections.unmodifiableSet(CollectionUtils.asSet(CONJUNCT, XCLAUSAL_COMPLEMENT, CLAUSAL_COMPLEMENT, CLAUSAL_MODIFIER, ADV_CLAUSE_MODIFIER, RELATIVE_CLAUSE_MODIFIER, PARATAXIS, APPOSITIONAL_MODIFIER, LIST));
    public static final Map<String, GrammaticalRelation> shortNameToGRel = new ConcurrentHashMap<String, GrammaticalRelation>();
    private static final Map<String, GrammaticalRelation> conjs;
    private static final Map<String, GrammaticalRelation> nmods;
    private static final Map<String, GrammaticalRelation> obls;
    private static final Map<String, GrammaticalRelation> acls;
    private static final Map<String, GrammaticalRelation> advcls;

    private UniversalEnglishGrammaticalRelations() {
    }

    public static List<GrammaticalRelation> values() {
        return unmodifiableSynchronizedValues;
    }

    public static Lock valuesLock() {
        return valuesLock.readLock();
    }

    public static void threadSafeAddRelation(GrammaticalRelation relation) {
        valuesLock.writeLock().lock();
        try {
            synchronizedValues.add(relation);
            shortNameToGRel.put(relation.toString(), relation);
        }
        finally {
            valuesLock.writeLock().unlock();
        }
    }

    public static Collection<GrammaticalRelation> getConjs() {
        return conjs.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getConj(String conjunctionString) {
        GrammaticalRelation result = conjs.get(conjunctionString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = conjs;
            synchronized (map) {
                result = conjs.get(conjunctionString);
                if (result == null) {
                    result = new GrammaticalRelation(Language.UniversalEnglish, "conj", "conj_collapsed", CONJUNCT, conjunctionString);
                    conjs.put(conjunctionString, result);
                    UniversalEnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    public static Collection<GrammaticalRelation> getNmods() {
        return nmods.values();
    }

    public static Collection<GrammaticalRelation> getAcls() {
        return acls.values();
    }

    public static Collection<GrammaticalRelation> getAdvcls() {
        return advcls.values();
    }

    public static Collection<GrammaticalRelation> getObls() {
        return obls.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getNmod(String prepositionString) {
        if (prepositionString.equals("npmod")) {
            return NP_ADVERBIAL_MODIFIER;
        }
        if (prepositionString.equals("tmod")) {
            return TEMPORAL_MODIFIER;
        }
        if (prepositionString.equals("poss")) {
            return POSSESSION_MODIFIER;
        }
        GrammaticalRelation result = nmods.get(prepositionString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = nmods;
            synchronized (map) {
                result = nmods.get(prepositionString);
                if (result == null) {
                    result = new GrammaticalRelation(Language.UniversalEnglish, "nmod", "nmod_preposition", NOMINAL_MODIFIER, prepositionString);
                    nmods.put(prepositionString, result);
                    UniversalEnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getObl(String prepositionString) {
        if (prepositionString.equals("npmod")) {
            return NP_ADVERBIAL_MODIFIER;
        }
        if (prepositionString.equals("tmod")) {
            return TEMPORAL_MODIFIER;
        }
        if (prepositionString.equals("agent")) {
            return AGENT;
        }
        GrammaticalRelation result = obls.get(prepositionString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = obls;
            synchronized (map) {
                result = obls.get(prepositionString);
                if (result == null) {
                    result = new GrammaticalRelation(Language.UniversalEnglish, "obl", "obl_preposition", OBLIQUE_MODIFIER, prepositionString);
                    obls.put(prepositionString, result);
                    UniversalEnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getAdvcl(String advclString) {
        GrammaticalRelation result = advcls.get(advclString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = advcls;
            synchronized (map) {
                result = advcls.get(advclString);
                if (result == null) {
                    result = new GrammaticalRelation(Language.UniversalEnglish, "advcl", "advcl_preposition", ADV_CLAUSE_MODIFIER, advclString);
                    advcls.put(advclString, result);
                    UniversalEnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getAcl(String aclString) {
        if (aclString.equals("relcl")) {
            return RELATIVE_CLAUSE_MODIFIER;
        }
        GrammaticalRelation result = acls.get(aclString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = acls;
            synchronized (map) {
                result = acls.get(aclString);
                if (result == null) {
                    result = new GrammaticalRelation(Language.UniversalEnglish, "acl", "acl_preposition", CLAUSAL_MODIFIER, aclString);
                    acls.put(aclString, result);
                    UniversalEnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    public static GrammaticalRelation valueOf(String s) {
        return GrammaticalRelation.valueOf(s, synchronizedValues, UniversalEnglishGrammaticalRelations.valuesLock());
    }

    public static GrammaticalRelation valueOf(Object o) {
        if (o instanceof GrammaticalRelation) {
            return (GrammaticalRelation)o;
        }
        if (o instanceof String) {
            return UniversalEnglishGrammaticalRelations.valueOf((String)o);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(GrammaticalRelation.DEPENDENT.toPrettyString());
    }

    static {
        UniversalEnglishGrammaticalRelations.valuesLock().lock();
        try {
            for (GrammaticalRelation gr : UniversalEnglishGrammaticalRelations.values()) {
                shortNameToGRel.put(gr.toString().toLowerCase(), gr);
            }
        }
        finally {
            UniversalEnglishGrammaticalRelations.valuesLock().unlock();
        }
        conjs = Generics.newConcurrentHashMap();
        nmods = Generics.newConcurrentHashMap();
        obls = Generics.newConcurrentHashMap();
        acls = Generics.newConcurrentHashMap();
        advcls = Generics.newConcurrentHashMap();
    }
}

