/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.spanish;

import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.spanish.SpanishXMLTreeReader;
import java.io.Reader;
import java.io.Serializable;

public class SpanishXMLTreeReaderFactory
implements TreeReaderFactory,
Serializable {
    private static final long serialVersionUID = 2019486878175311263L;
    private final boolean simplifiedTagset;
    private final boolean aggressiveNormalization;
    private final boolean retainNER;
    private final boolean detailedAnnotations;
    private final boolean expandElisions;
    private final boolean expandConmigo;

    public SpanishXMLTreeReaderFactory() {
        this(true, true, false, false, false, false);
    }

    public SpanishXMLTreeReaderFactory(boolean simplifiedTagset, boolean aggressiveNormalization, boolean retainNER, boolean detailedAnnotations, boolean expandElisions, boolean expandConmigo) {
        this.simplifiedTagset = simplifiedTagset;
        this.aggressiveNormalization = aggressiveNormalization;
        this.retainNER = retainNER;
        this.detailedAnnotations = detailedAnnotations;
        this.expandElisions = expandElisions;
        this.expandConmigo = expandConmigo;
    }

    @Override
    public TreeReader newTreeReader(Reader in) {
        return new SpanishXMLTreeReader(null, in, this.simplifiedTagset, this.aggressiveNormalization, this.retainNER, this.detailedAnnotations, this.expandElisions, this.expandConmigo);
    }

    public TreeReader newTreeReader(String path, Reader in) {
        return new SpanishXMLTreeReader(path, in, this.simplifiedTagset, this.aggressiveNormalization, this.retainNER, this.detailedAnnotations, this.expandElisions, this.expandConmigo);
    }
}

