/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.EnglishPatterns;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalStructure;
import edu.stanford.nlp.trees.ud.UniversalEnhancer;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ProcessProtobufRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Pattern;

public class ProcessUniversalEnhancerRequest
extends ProcessProtobufRequest {
    public static void enhanceDependencies(Pattern relativePronounsPattern, Annotation annotation) {
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            SemanticGraph basic = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            SemanticGraph enhanced = UniversalEnhancer.enhanceGraph(basic, null, false, null, relativePronounsPattern);
            sentence.set(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, enhanced);
        }
    }

    public static void enhanceEnglishDependencies(Annotation annotation) {
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            SemanticGraph basic = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            SemanticGraph enhanced = new SemanticGraph(basic);
            UniversalEnglishGrammaticalStructure.addEnhancements(enhanced, UniversalEnglishGrammaticalStructure.ENHANCED_OPTIONS);
            sentence.set(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, enhanced);
            SemanticGraph plusplus = new SemanticGraph(basic);
            UniversalEnglishGrammaticalStructure.addEnhancements(plusplus, UniversalEnglishGrammaticalStructure.ENHANCED_PLUS_PLUS_OPTIONS);
            sentence.set(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, plusplus);
        }
    }

    public static CoreNLPProtos.Document processRequest(Pattern relativePronounsPattern, CoreNLPProtos.DependencyEnhancerRequest request) {
        ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer();
        Annotation annotation = serializer.fromProto(request.getDocument());
        if (request.hasLanguage() && (request.getLanguage() == CoreNLPProtos.Language.English || request.getLanguage() == CoreNLPProtos.Language.UniversalEnglish)) {
            ProcessUniversalEnhancerRequest.enhanceEnglishDependencies(annotation);
        } else {
            ProcessUniversalEnhancerRequest.enhanceDependencies(relativePronounsPattern, annotation);
        }
        return serializer.toProto(annotation);
    }

    public static Pattern getRelativePronouns(CoreNLPProtos.DependencyEnhancerRequest request) {
        if (request.hasRelativePronouns()) {
            return Pattern.compile(request.getRelativePronouns());
        }
        if (request.hasLanguage()) {
            switch (request.getLanguage()) {
                case English: 
                case UniversalEnglish: {
                    return EnglishPatterns.RELATIVIZING_WORD_PATTERN;
                }
                case Chinese: 
                case UniversalChinese: {
                    return null;
                }
            }
            throw new IllegalArgumentException("Relative word pattern not defined for " + request.getLanguage());
        }
        throw new IllegalArgumentException("Could not find Language or predefined relative pronouns pattern in the request");
    }

    @Override
    public void processInputStream(InputStream in, OutputStream out2) throws IOException {
        CoreNLPProtos.DependencyEnhancerRequest request = CoreNLPProtos.DependencyEnhancerRequest.parseFrom(in);
        Pattern relativePronounsPattern = ProcessUniversalEnhancerRequest.getRelativePronouns(request);
        CoreNLPProtos.Document response = ProcessUniversalEnhancerRequest.processRequest(relativePronounsPattern, request);
        response.writeTo(out2);
    }

    public static void main(String[] args) throws IOException {
        ProcessProtobufRequest.process(new ProcessUniversalEnhancerRequest(), args);
    }
}

