/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.util.HashMap;

public class UniversalGrammaticalRelations {
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation(Language.Any, "nsubj", "nominal subject", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CLAUSAL_SUBJECT = new GrammaticalRelation(Language.Any, "csubj", "clausal subject", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation(Language.Any, "obj", "object", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation INDIRECT_OBJECT = new GrammaticalRelation(Language.Any, "iobj", "indirect object", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.Any, "ccomp", "clausal complement", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation XCLAUSAL_COMPLEMENT = new GrammaticalRelation(Language.Any, "xcomp", "open clausal complement", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation OBLIQUE_MODIFIER = new GrammaticalRelation(Language.Any, "obl", "oblique modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation VOCATIVE = new GrammaticalRelation(Language.Any, "vocative", "vocative", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation EXPLETIVE = new GrammaticalRelation(Language.Any, "expl", "expletive", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation DISLOCATED = new GrammaticalRelation(Language.Any, "dislocated", "dislocated", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation ADV_CLAUSE_MODIFIER = new GrammaticalRelation(Language.Any, "advcl", "adverbial clause modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation(Language.Any, "advmod", "adverbial modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation DISCOURSE_ELEMENT = new GrammaticalRelation(Language.Any, "discourse", "discourse element", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation(Language.Any, "auxiliary", "auxiliary element", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation COPULA = new GrammaticalRelation(Language.Any, "cop", "copula", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation MARKER = new GrammaticalRelation(Language.Any, "mark", "marker", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation NOMINAL_MODIFIER = new GrammaticalRelation(Language.Any, "nmod", "nominal modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation APPOSITIONAL_MODIFIER = new GrammaticalRelation(Language.Any, "appos", "appositional modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation(Language.Any, "nummod", "numerical modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CLAUSAL_MODIFIER = new GrammaticalRelation(Language.Any, "acl", "clausal modifier of a noun (adjectival clause)", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation(Language.Any, "amod", "adjectival modifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation(Language.Any, "det", "determiner", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CLASSIFIER = new GrammaticalRelation(Language.Any, "clf", "classifier", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CASE_MARKER = new GrammaticalRelation(Language.Any, "case", "case marker", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation(Language.Any, "conj", "conjunct", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation(Language.Any, "cc", "coordinating conjunction", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation FIXED = new GrammaticalRelation(Language.Any, "fixed", "fixed multiword expression", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation FLAT = new GrammaticalRelation(Language.Any, "flat", "flat multiword expression", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation COMPOUND_MODIFIER = new GrammaticalRelation(Language.Any, "compound", "compound", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation LIST = new GrammaticalRelation(Language.Any, "list", "list", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation PARATAXIS = new GrammaticalRelation(Language.Any, "parataxis", "parataxis", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation ORPHAN = new GrammaticalRelation(Language.Any, "orphan", "orphan", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation GOES_WITH = new GrammaticalRelation(Language.Any, "goeswith", "goes with", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation REPARANDUM = new GrammaticalRelation(Language.Any, "reparandum", "reparandum", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation(Language.Any, "punct", "punctuation", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.Any, "nsubj:pass", "nominal passive subject", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CLAUSAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.Any, "csubj:pass", "clausal passive subject", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation RELATIVE_CLAUSE = new GrammaticalRelation(Language.Any, "acl:relcl", "relative clause", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation PHRASAL_VERB_PARTICLE = new GrammaticalRelation(Language.Any, "compound:prt", "phrasal verb particle", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation AGENT = new GrammaticalRelation(Language.Any, "obl:agent", "agent", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation POSSESSOR = new GrammaticalRelation(Language.Any, "nmod:poss", "possessor", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation REFERENT = new GrammaticalRelation(Language.Any, "ref", "pronominal referent", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CONTROLLING_NOMINAL_SUBJECT = new GrammaticalRelation(Language.Any, "nsubj:xsubj", "controlling nominal subject", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CONTROLLING_NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.Any, "nsubj:pass:xsubj", "controlling nominal passive subject", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation RELATIVE_NOMINAL_SUBJECT = new GrammaticalRelation(Language.Any, "nsubj:relsubj", "relative nominal subject", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation RELATIVE_NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(Language.Any, "nsubj:pass:relsubj", "relative nominal passive subject", GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation RELATIVE_OBJECT = new GrammaticalRelation(Language.Any, "obl:relobj", "relative object", GrammaticalRelation.DEPENDENT);
    private static HashMap<String, GrammaticalRelation> nmodRelations = new HashMap();
    private static HashMap<String, GrammaticalRelation> oblRelations = new HashMap();
    private static HashMap<String, GrammaticalRelation> aclRelations = new HashMap();
    private static HashMap<String, GrammaticalRelation> advclRelations = new HashMap();
    private static HashMap<String, GrammaticalRelation> conjRelations = new HashMap();

    private UniversalGrammaticalRelations() {
    }

    public static final GrammaticalRelation getConj(String subtype) {
        return UniversalGrammaticalRelations.getSpecificReln(conjRelations, subtype, CONJUNCT);
    }

    public static final GrammaticalRelation getNmod(String subtype) {
        return UniversalGrammaticalRelations.getSpecificReln(nmodRelations, subtype, NOMINAL_MODIFIER);
    }

    public static final GrammaticalRelation getObl(String subtype) {
        return UniversalGrammaticalRelations.getSpecificReln(oblRelations, subtype, OBLIQUE_MODIFIER);
    }

    public static final GrammaticalRelation getAcl(String subtype) {
        return UniversalGrammaticalRelations.getSpecificReln(aclRelations, subtype, CLAUSAL_MODIFIER);
    }

    public static final GrammaticalRelation getAdvcl(String subtype) {
        return UniversalGrammaticalRelations.getSpecificReln(advclRelations, subtype, ADV_CLAUSE_MODIFIER);
    }

    private static final GrammaticalRelation getSpecificReln(HashMap<String, GrammaticalRelation> existingRelations, String subtype, GrammaticalRelation parentRelation) {
        if (!existingRelations.containsKey(subtype)) {
            GrammaticalRelation reln = new GrammaticalRelation(Language.Any, parentRelation.getShortName(), "subtyped " + parentRelation.getLongName(), parentRelation, subtype);
            existingRelations.put(subtype, reln);
        }
        return existingRelations.get(subtype);
    }
}

