/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.ud.UniversalGrammaticalRelations;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class UniversalGrammaticalStructure
extends GrammaticalStructure {
    private static final double RELCL_EDGE_WEIGHT = Double.NEGATIVE_INFINITY;
    private static final double CONTROL_EDGE_WEIGHT = Double.NEGATIVE_INFINITY;
    private static final double CONJPROP_EDGE_WEIGHT = Double.NEGATIVE_INFINITY;
    private static SemgrexPattern[] PREP_PATTERNS = new SemgrexPattern[]{SemgrexPattern.compile("{}=gov   >/^(nmod|obl)$/=reln ({}=mod >case {}=c1)"), SemgrexPattern.compile("{}=gov   >/^(advcl|acl)$/=reln ({}=mod >/^(mark|case)$/ {}=c1)")};
    private static final SemgrexPattern CONJUNCTION_PATTERN = SemgrexPattern.compile("{}=gov  >conj ({} >cc {}=cc) >conj {}=conj ");

    public UniversalGrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        super(projectiveDependencies, root);
    }

    /*
     * WARNING - void declaration
     */
    public static void addRef(SemanticGraph sg, Pattern relativizingWordPattern) {
        for (SemanticGraphEdge edge : sg.findAllRelns("acl:relcl")) {
            void var8_8;
            IndexedWord head = edge.getGovernor();
            IndexedWord modifier = edge.getDependent();
            SemanticGraphEdge leftChildEdge = null;
            for (SemanticGraphEdge semanticGraphEdge : sg.outgoingEdgeIterable(modifier)) {
                if (!relativizingWordPattern.matcher(semanticGraphEdge.getDependent().value()).matches() || leftChildEdge != null && semanticGraphEdge.getDependent().index() >= leftChildEdge.getDependent().index()) continue;
                leftChildEdge = semanticGraphEdge;
            }
            SemanticGraphEdge leftGrandchildEdge = null;
            for (SemanticGraphEdge childEdge3 : sg.outgoingEdgeIterable(modifier)) {
                if (childEdge3.getRelation().getShortName().contains("comp") || childEdge3.getRelation().getShortName().contains("conj") || childEdge3.getRelation().getShortName().contains("parataxis") || childEdge3.getRelation().getShortName().contains("discourse") || childEdge3.getRelation().getShortName().contains("advcl") || childEdge3.getRelation().getShortName().contains("acl") || childEdge3.getRelation().getShortName().contains("list") || childEdge3.getRelation().getShortName().contains("orphan") || childEdge3.getRelation().getShortName().contains("vocative") || childEdge3.getRelation().getShortName().contains("dislocated") || childEdge3.getRelation().getShortName().contains("appos")) continue;
                for (SemanticGraphEdge grandchildEdge : sg.outgoingEdgeIterable(childEdge3.getDependent())) {
                    if (!relativizingWordPattern.matcher(grandchildEdge.getDependent().value()).matches() || leftGrandchildEdge != null && grandchildEdge.getDependent().index() >= leftGrandchildEdge.getDependent().index()) continue;
                    leftGrandchildEdge = grandchildEdge;
                }
            }
            Object var8_12 = null;
            if (leftGrandchildEdge != null && (leftChildEdge == null || leftGrandchildEdge.getDependent().index() < leftChildEdge.getDependent().index())) {
                IndexedWord indexedWord = leftGrandchildEdge.getDependent();
            } else if (leftChildEdge != null) {
                IndexedWord indexedWord = leftChildEdge.getDependent();
            }
            if (var8_8 == null || sg.containsEdge(head, (IndexedWord)var8_8)) continue;
            sg.addEdge(head, (IndexedWord)var8_8, UniversalGrammaticalRelations.REFERENT, Double.NEGATIVE_INFINITY, false);
        }
    }

    public static void collapseReferent(SemanticGraph sg) {
        ArrayList<SemanticGraphEdge> refs = new ArrayList<SemanticGraphEdge>(sg.findAllRelns("ref"));
        SemanticGraph sgCopy = sg.makeSoftCopy();
        for (SemanticGraphEdge ref : refs) {
            IndexedWord dep = ref.getDependent();
            IndexedWord ant = ref.getGovernor();
            Iterator<SemanticGraphEdge> iter = sgCopy.incomingEdgeIterator(dep);
            while (iter.hasNext()) {
                SemanticGraphEdge edge = iter.next();
                if (edge.getRelation().getShortName().equals("ref") || edge.getGovernor().equals(ant)) continue;
                sg.removeEdge(edge);
                GrammaticalRelation reln = edge.getRelation();
                if (edge.getRelation().getShortName().equals("obj")) {
                    reln = UniversalGrammaticalRelations.RELATIVE_OBJECT;
                } else if (edge.getRelation().getShortName().equals("nsubj")) {
                    reln = UniversalGrammaticalRelations.RELATIVE_NOMINAL_SUBJECT;
                } else if (edge.getRelation().getShortName().equals("nsubj:pass")) {
                    reln = UniversalGrammaticalRelations.RELATIVE_NOMINAL_PASSIVE_SUBJECT;
                }
                sg.addEdge(edge.getGovernor(), ant, reln, Double.NEGATIVE_INFINITY, true);
            }
        }
    }

    public static void addExtraNSubj(SemanticGraph sg) {
        for (SemanticGraphEdge xcomp : sg.findAllRelns("xcomp")) {
            IndexedWord modifier = xcomp.getDependent();
            IndexedWord head = xcomp.getGovernor();
            boolean hasSubjectDaughter = false;
            ArrayList<IndexedWord> subjects = Generics.newArrayList();
            ArrayList<IndexedWord> objects = Generics.newArrayList();
            for (SemanticGraphEdge dep : sg.edgeIterable()) {
                if (dep.getRelation().getShortName().startsWith("nsubj") && dep.getGovernor().equals(modifier)) {
                    hasSubjectDaughter = true;
                    break;
                }
                if (dep.getRelation().getShortName().startsWith("nsubj") && dep.getGovernor().equals(head)) {
                    subjects.add(dep.getDependent());
                }
                if (!dep.getRelation().getShortName().equals("obj") || !dep.getGovernor().equals(head)) continue;
                objects.add(dep.getDependent());
            }
            if (hasSubjectDaughter || ((String)modifier.get(CoreAnnotations.CoarseTagAnnotation.class)).equalsIgnoreCase("PART")) continue;
            if (!objects.isEmpty()) {
                for (IndexedWord object : objects) {
                    if (sg.containsEdge(modifier, object)) continue;
                    sg.addEdge(modifier, object, UniversalGrammaticalRelations.CONTROLLING_NOMINAL_SUBJECT, Double.NEGATIVE_INFINITY, true);
                }
                continue;
            }
            for (IndexedWord subject : subjects) {
                if (sg.containsEdge(modifier, subject)) continue;
                sg.addEdge(modifier, subject, UniversalGrammaticalRelations.CONTROLLING_NOMINAL_SUBJECT, Double.NEGATIVE_INFINITY, true);
            }
        }
    }

    public static void propagateConjuncts(SemanticGraph sg) {
        Map map = Generics.newHashMap();
        Map<IndexedWord, SemanticGraphEdge> subjectMap = Generics.newHashMap();
        Set<IndexedWord> withPassiveAuxiliary = Generics.newHashSet();
        Map coreArguments = Generics.newHashMap();
        coreArguments.put(UniversalGrammaticalRelations.XCLAUSAL_COMPLEMENT, Generics.newHashMap());
        coreArguments.put(UniversalGrammaticalRelations.CLAUSAL_COMPLEMENT, Generics.newHashMap());
        coreArguments.put(UniversalGrammaticalRelations.DIRECT_OBJECT, Generics.newHashMap());
        coreArguments.put(UniversalGrammaticalRelations.INDIRECT_OBJECT, Generics.newHashMap());
        Map<IndexedWord, SemanticGraphEdge> explMap = Generics.newHashMap();
        ArrayList<IndexedWord> rcmodHeads = Generics.newArrayList();
        for (SemanticGraphEdge edge : sg.edgeIterable()) {
            if (!map.containsKey(edge.getDependent())) {
                map.put(edge.getDependent(), new TreeSet());
            }
            ((Set)map.get(edge.getDependent())).add(edge);
            if (edge.getRelation().getShortName().equals("aux:pass")) {
                withPassiveAuxiliary.add(edge.getGovernor());
            }
            if (edge.getRelation().getShortName().contains("subj")) {
                if (subjectMap.containsKey(edge.getGovernor())) continue;
                subjectMap.put(edge.getGovernor(), edge);
                continue;
            }
            if (edge.getRelation().getShortName().equals("expl")) {
                explMap.putIfAbsent(edge.getGovernor(), edge);
                continue;
            }
            if (edge.getRelation().getShortName().equals("acl:relcl")) {
                rcmodHeads.add(edge.getGovernor());
                continue;
            }
            if (edge.getRelation().getShortName().equals("xcomp")) {
                ((Map)coreArguments.get(UniversalGrammaticalRelations.XCLAUSAL_COMPLEMENT)).put(edge.getGovernor(), edge);
                continue;
            }
            if (edge.getRelation().getShortName().equals("ccomp")) {
                ((Map)coreArguments.get(UniversalGrammaticalRelations.CLAUSAL_COMPLEMENT)).put(edge.getGovernor(), edge);
                continue;
            }
            if (edge.getRelation().getShortName().equals("obj")) {
                ((Map)coreArguments.get(UniversalGrammaticalRelations.DIRECT_OBJECT)).put(edge.getGovernor(), edge);
                continue;
            }
            if (!edge.getRelation().getShortName().equals("iobj")) continue;
            ((Map)coreArguments.get(UniversalGrammaticalRelations.INDIRECT_OBJECT)).put(edge.getGovernor(), edge);
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        for (SemanticGraphEdge edge : sgCopy.edgeIterable()) {
            if (!edge.getRelation().getShortName().equals("conj")) continue;
            IndexedWord gov = edge.getGovernor();
            IndexedWord dep = edge.getDependent();
            Set gov_relations = (Set)map.get(gov);
            if (gov_relations != null) {
                for (SemanticGraphEdge edge1 : gov_relations) {
                    GrammaticalRelation newRel;
                    IndexedWord newGov = edge1.getGovernor();
                    if (newGov.equals(dep) || (newRel = edge1.getRelation()) == GrammaticalRelation.ROOT || newRel.getShortName().equals("dislocated") || newRel.getShortName().equals("vocative") || newRel.getShortName().equals("discourse") || newRel.getShortName().equals("parataxis") || newRel.getShortName().equals("list") || newRel.getShortName().equals("orphan") || newRel.getShortName().equals("conj")) continue;
                    if (rcmodHeads.contains(gov) && rcmodHeads.contains(dep)) {
                        if (newRel.getShortName().equals("obj") || !newRel.getShortName().equals("nsubj")) continue;
                        sg.addEdge(newGov, dep, newRel, Double.NEGATIVE_INFINITY, true);
                        continue;
                    }
                    sg.addEdge(newGov, dep, newRel, Double.NEGATIVE_INFINITY, true);
                }
            }
            if (subjectMap.containsKey(gov) && !subjectMap.containsKey(dep) && !explMap.containsKey(dep)) {
                SemanticGraphEdge tdsubj = (SemanticGraphEdge)subjectMap.get(gov);
                GrammaticalRelation relation = tdsubj.getRelation();
                if (relation.getShortName().equals("nsubj")) {
                    if (withPassiveAuxiliary.contains(dep)) {
                        relation = UniversalGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT;
                    }
                } else if (relation.getShortName().equals("csubj") && withPassiveAuxiliary.contains(dep)) {
                    relation = UniversalGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT;
                }
                sg.addEdge(dep, tdsubj.getDependent(), relation, Double.NEGATIVE_INFINITY, true);
            }
            for (GrammaticalRelation reln : coreArguments.keySet()) {
                Map arguments = (Map)coreArguments.get(reln);
                if (!arguments.containsKey(gov) || arguments.containsKey(dep)) continue;
                SemanticGraphEdge argEdge = (SemanticGraphEdge)arguments.get(gov);
                if (dep.index() >= argEdge.getDependent().index()) continue;
                sg.addEdge(dep, argEdge.getDependent(), argEdge.getRelation(), Double.NEGATIVE_INFINITY, true);
            }
        }
    }

    public static final void addCaseMarkerInformation(SemanticGraph sg) {
        for (SemgrexPattern p : PREP_PATTERNS) {
            SemanticGraph sgCopy = sg.makeSoftCopy();
            SemgrexMatcher matcher = p.matcher(sgCopy);
            IndexedWord oldCaseMarker = null;
            while (matcher.find()) {
                IndexedWord caseMarker = matcher.getNode("c1");
                if (oldCaseMarker != null && caseMarker.equals(oldCaseMarker)) continue;
                IndexedWord gov = matcher.getNode("gov");
                IndexedWord mod = matcher.getNode("mod");
                UniversalGrammaticalStructure.addCaseMarkersToReln(sg, gov, mod, caseMarker);
                oldCaseMarker = caseMarker;
            }
        }
    }

    public static void addCaseMarkerForConjunctions(SemanticGraph sg) {
        SemanticGraph sgCopy = sg.makeSoftCopy();
        block0: for (SemanticGraphEdge edge : sgCopy.edgeIterable()) {
            String relnName = edge.getRelation().toString();
            if (!relnName.equals("nmod") && !relnName.equals("obl") && !relnName.equals("acl") && !relnName.equals("advcl")) continue;
            Set<IndexedWord> conjParents = sg.getParentsWithReln(edge.getDependent(), "conj");
            for (IndexedWord conjParent : conjParents) {
                List<SemanticGraphEdge> conjParentIncomingEdges = sg.getIncomingEdgesSorted(conjParent);
                boolean changed = false;
                for (SemanticGraphEdge edge1 : conjParentIncomingEdges) {
                    if (!edge1.getRelation().toString().startsWith(relnName) || edge1.getRelation().getSpecific() == null) continue;
                    changed = true;
                    sg.getEdge(edge.getGovernor(), edge.getDependent(), edge.getRelation()).setRelation(edge1.getRelation());
                    break;
                }
                if (!changed) continue;
                continue block0;
            }
        }
    }

    private static void addCaseMarkersToReln(SemanticGraph sg, IndexedWord gov, IndexedWord mod, IndexedWord caseMarker) {
        SemanticGraphEdge edge = sg.getEdge(gov, mod);
        ArrayList<IndexedWord> caseMarkers = new ArrayList<IndexedWord>();
        caseMarkers.add(caseMarker);
        sg.getChildrenWithReln(caseMarker, UniversalGrammaticalRelations.FIXED).stream().forEach(iw -> caseMarkers.add((IndexedWord)iw));
        Collections.sort(caseMarkers);
        String relnName = StringUtils.join(caseMarkers.stream().map(iw -> iw.lemma()), "_");
        if (relnName.matches("[^a-zA-Z_]")) {
            return;
        }
        GrammaticalRelation reln = UniversalGrammaticalStructure.getCaseMarkedRelation(edge.getRelation(), relnName.toLowerCase());
        edge.setRelation(reln);
    }

    private static GrammaticalRelation getCaseMarkedRelation(GrammaticalRelation reln, String relationName) {
        GrammaticalRelation newReln = reln;
        if (reln.getShortName().equals("nmod")) {
            newReln = UniversalGrammaticalRelations.getNmod(relationName);
        } else if (reln.getShortName().equals("obl")) {
            newReln = UniversalGrammaticalRelations.getObl(relationName);
        } else if (reln.getShortName().equals("advcl")) {
            newReln = UniversalGrammaticalRelations.getAdvcl(relationName);
        } else if (reln.getShortName().equals("acl")) {
            newReln = UniversalGrammaticalRelations.getAcl(relationName);
        }
        return newReln;
    }

    public static void addConjInformation(SemanticGraph sg) {
        if (sg.getRoots().isEmpty()) {
            return;
        }
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = CONJUNCTION_PATTERN.matcher(sgCopy);
        IndexedWord oldGov = null;
        IndexedWord oldCcDep = null;
        LinkedList<IndexedWord> conjDeps = Generics.newLinkedList();
        while (matcher.find()) {
            IndexedWord conjDep = matcher.getNode("conj");
            IndexedWord gov = matcher.getNode("gov");
            IndexedWord ccDep = matcher.getNode("cc");
            if (!(oldGov == null || gov.equals(oldGov) && ccDep.equals(oldCcDep))) {
                UniversalGrammaticalStructure.addConjToReln(sg, oldGov, conjDeps, oldCcDep);
                conjDeps = Generics.newLinkedList();
            }
            oldCcDep = ccDep;
            conjDeps.add(conjDep);
            oldGov = gov;
        }
        if (oldGov != null) {
            UniversalGrammaticalStructure.addConjToReln(sg, oldGov, conjDeps, oldCcDep);
        }
    }

    private static void addConjToReln(SemanticGraph sg, IndexedWord gov, List<IndexedWord> conjDeps, IndexedWord ccDep) {
        for (IndexedWord conjDep : conjDeps) {
            String relnName;
            SemanticGraphEdge edge = sg.getEdge(gov, conjDep);
            if (!edge.getRelation().toString().equals("conj") && conjDep.index() <= ccDep.index() || (relnName = UniversalGrammaticalStructure.conjValue(ccDep, sg)).matches("[^a-zA-Z_]")) continue;
            edge.setRelation(UniversalGrammaticalRelations.getConj(relnName));
        }
    }

    private static String conjValue(IndexedWord cc, SemanticGraph sg) {
        List<IndexedWord> yield = sg.yield(cc);
        if (yield.size() < 2) {
            return cc.lemma();
        }
        LinkedList ccParts = new LinkedList();
        yield.stream().forEach(iw -> ccParts.add(iw.lemma()));
        return StringUtils.join(ccParts, "_").toLowerCase();
    }
}

