/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.Serializable;

public class Trilean
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final byte value;
    public static Trilean TRUE = new Trilean(true, false);
    public static Trilean FALSE = new Trilean(false, true);
    public static Trilean UNKNOWN = new Trilean(false, false);

    public Trilean(boolean isTrue, boolean isFalse) {
        if (isTrue && isFalse) {
            throw new IllegalArgumentException("Value cannot be both true and false.");
        }
        this.value = isTrue ? (byte)1 : (isFalse ? (byte)0 : (byte)2);
    }

    public Trilean(Trilean other) {
        this.value = other.value;
    }

    public boolean isTrue() {
        return this.value == 1;
    }

    public boolean isFalse() {
        return this.value == 0;
    }

    public boolean isKnown() {
        return this.value != 2;
    }

    public boolean isUnknown() {
        return this.value == 2;
    }

    public boolean toBoolean(boolean valueForUnknown) {
        switch (this.value) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
            case 2: {
                return valueForUnknown;
            }
        }
        throw new IllegalStateException("Something went very very wrong.");
    }

    public Boolean toBooleanOrNull() {
        switch (this.value) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
            case 2: {
                return null;
            }
        }
        throw new IllegalStateException("Something went very very wrong.");
    }

    public Trilean and(Trilean other) {
        if (this.value == 0 || other.value == 0) {
            return FALSE;
        }
        if (this.value == 2 || other.value == 2) {
            return UNKNOWN;
        }
        return TRUE;
    }

    public Trilean or(Trilean other) {
        if (this.value == 1 || other.value == 1) {
            return TRUE;
        }
        if (this.value == 2 || other.value == 2) {
            return UNKNOWN;
        }
        return FALSE;
    }

    public Trilean not() {
        switch (this.value) {
            case 0: {
                return TRUE;
            }
            case 1: {
                return FALSE;
            }
            case 2: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException("Something went very very wrong.");
    }

    public boolean equals(Object other) {
        if (other instanceof Trilean) {
            return ((Trilean)other).value == this.value;
        }
        if (other instanceof Boolean) {
            return Trilean.from((boolean)((Boolean)other).booleanValue()).value == this.value;
        }
        return false;
    }

    public int hashCode() {
        if (this.isTrue()) {
            return Boolean.hashCode(true);
        }
        if (this.isFalse()) {
            return Boolean.hashCode(false);
        }
        return Byte.hashCode(this.value);
    }

    public String toString() {
        if (this.isTrue()) {
            return "true";
        }
        if (this.isFalse()) {
            return "false";
        }
        return "unknown";
    }

    public static Trilean from(boolean bool) {
        if (bool) {
            return TRUE;
        }
        return FALSE;
    }

    public static Trilean fromString(String value) {
        switch (value.toLowerCase()) {
            case "true": 
            case "t": {
                return TRUE;
            }
            case "false": 
            case "f": {
                return FALSE;
            }
            case "unknown": 
            case "unk": 
            case "u": {
                return UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Cannot parse Trilean from string: " + value);
    }
}

