/*
 * Decompiled with CFR 0.152.
 */
package io.whelk.flesch.kincaid;

import edu.stanford.nlp.simple.Token;
import java.util.Arrays;
import java.util.List;

public final class PennTreebankValidator {
    private static final List<PennTreebankTag> invalidWordTags = List.of(PennTreebankTag.UNKNOWN, PennTreebankTag.POS, PennTreebankTag.SYM);

    public static boolean isWord(Token token) {
        return token != null && !invalidWordTags.contains((Object)PennTreebankTag.parse(token.posTag()));
    }

    private PennTreebankValidator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static enum PennTreebankTag {
        CC,
        CD,
        DT,
        EX,
        FW,
        IN,
        JJ,
        JJR,
        JJS,
        LS,
        MD,
        NN,
        NNS,
        NNP,
        NNPS,
        PDT,
        POS,
        PRP,
        PRP$,
        RB,
        RBR,
        RBS,
        RP,
        SYM,
        TO,
        UH,
        VB,
        VBD,
        VBG,
        VBN,
        VBP,
        VBZ,
        WDT,
        WP,
        WP$,
        WRB,
        UNKNOWN;


        public static PennTreebankTag parse(String posTag) {
            return Arrays.stream(PennTreebankTag.values()).filter(p -> p.name().equals(posTag)).findFirst().orElse(UNKNOWN);
        }
    }
}

