/*
 * Decompiled with CFR 0.152.
 */
package io.whelk.flesch.kincaid;

import edu.stanford.nlp.simple.Sentence;
import io.whelk.flesch.kincaid.Tokenizer;
import io.whelk.hy.phen.Hyphenator;
import java.util.List;

public final class ReadabilityCalculator {
    public static double calculateReadingEase(String content) {
        List<Sentence> sentences = Tokenizer.tokenizeContent(content);
        List<String> words = Tokenizer.tokenizeSentences(sentences);
        return ReadabilityCalculator.calculateReadingEase(sentences, words);
    }

    public static double calculateReadingEase(List<Sentence> sentences, List<String> words) {
        double totalSentences = sentences.size();
        double totalWords = words.size();
        double totalSyllables = ReadabilityCalculator.countSyllables(words);
        return 206.835 - 1.015 * (totalWords / totalSentences) - 84.6 * (totalSyllables / totalWords);
    }

    public static double calculateGradeLevel(String content) {
        List<Sentence> sentences = Tokenizer.tokenizeContent(content);
        List<String> words = Tokenizer.tokenizeSentences(sentences);
        return ReadabilityCalculator.calculateGradeLevel(sentences, words);
    }

    public static double calculateGradeLevel(List<Sentence> sentences, List<String> words) {
        double totalSentences = sentences.size();
        double totalWords = words.size();
        double totalSyllables = ReadabilityCalculator.countSyllables(words);
        return 0.39 * (totalWords / totalSentences) + 11.8 * (totalSyllables / totalWords) - 15.59;
    }

    static double countSyllables(List<String> tokens) {
        return tokens.stream().mapToDouble(ReadabilityCalculator::countSyllables).sum();
    }

    static double countSyllables(String word) {
        if (word == null || word.trim().isEmpty()) {
            return 0.0;
        }
        if (!word.matches("[a-zA-Z]+")) {
            return 1.0;
        }
        return Hyphenator.hyphen(word).syllables().size();
    }

    private ReadabilityCalculator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

