/*
 * Decompiled with CFR 0.152.
 */
package io.whelk.flesch.kincaid;

import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.simple.Token;
import io.whelk.flesch.kincaid.PennTreebankValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class Tokenizer {
    public static List<Sentence> tokenizeContent(String content) {
        return content != null ? new Document(content).sentences() : Collections.emptyList();
    }

    public static List<String> tokenizeSentences(List<Sentence> sentences) {
        return sentences != null ? sentences.stream().map(Sentence::tokens).flatMap(Collection::stream).filter(PennTreebankValidator::isWord).map(Token::originalText).collect(Collectors.toList()) : Collections.emptyList();
    }

    private Tokenizer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

