/*
 * Decompiled with CFR 0.152.
 */
package io.whelk.hy.phen;

import io.whelk.hy.phen.Edge;
import io.whelk.hy.phen.HyphenResult;
import io.whelk.hy.phen.Trie;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Hyphenator {
    private static Map<Integer, Map<String, List<Trie>>> tries;
    private static Map<String, Edge> edges;
    private static int maxTrie;
    private static int minTrie;

    private static void loadHyphens() {
        tries = Hyphenator.readFromFile("/hyphen-en-us.txt").stream().sorted().distinct().map(Hyphenator::mapPattern).collect(Collectors.groupingBy(t -> t.matcher().length(), Collectors.groupingBy(t -> t.matcher())));
        IntSummaryStatistics stats = tries.keySet().stream().mapToInt(i -> i).summaryStatistics();
        maxTrie = stats.getMax();
        minTrie = stats.getMin();
    }

    private static void loadEdges() {
        edges = Hyphenator.readFromFile("/edge-en-us.txt").stream().sorted().distinct().map(Hyphenator::mapEdge).collect(Collectors.toMap(Edge::value, v -> v));
    }

    private static List<String> readFromFile(String filename) {
        LinkedList<String> lines = new LinkedList<String>();
        try (InputStream inputStream = Hyphenator.class.getResourceAsStream(filename);
             BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private static Trie mapPattern(String value) {
        String plainText = value.replaceAll("[\\.0-9]", "");
        boolean isLeadingMatch = value.startsWith(".");
        boolean isTrailingMatch = value.endsWith(".");
        boolean isTrailingWildcard = value.substring(value.length() - 1).matches("[\\.0-9]");
        char[] trieArr = Hyphenator.toTrieArray(value, plainText, isTrailingWildcard);
        return new Trie(value, plainText, trieArr, isLeadingMatch, isTrailingMatch);
    }

    private static Edge mapEdge(String value) {
        return new Edge(value.replaceAll("-", ""), value, Arrays.asList(value.split("-")));
    }

    private static char[] toTrieArray(String value, String plainText, boolean isTrailingWildcard) {
        String trimmed = value.replaceAll("\\.", "");
        int len = plainText.length();
        if (isTrailingWildcard) {
            ++len;
        }
        char[] arr = new char[len * 2];
        Arrays.fill(arr, '0');
        int i = 0;
        for (char c : trimmed.toCharArray()) {
            if (c >= '0' && c <= '9') {
                if (i % 2 == 0) {
                    arr[i] = c;
                } else {
                    arr[++i] = c;
                }
            } else if (i % 2 == 0) {
                arr[++i] = c;
            } else {
                arr[i] = c;
            }
            ++i;
        }
        return arr;
    }

    public static HyphenResult hyphen(String word) {
        Hyphenator.validate(word);
        word = word.toLowerCase();
        HyphenResult result = new HyphenResult().originalWord(word);
        if (edges.containsKey(word)) {
            Edge edge = edges.get(word);
            result.isEdgeCase(true);
            result.hyphenWord(edge.hypen());
            result.syllables(edge.syllables());
            return result;
        }
        char[] wordTrieArr = new char[word.length() * 2];
        Arrays.fill(wordTrieArr, '0');
        char[] wordArr = word.toCharArray();
        for (int i = 0; i < wordArr.length; ++i) {
            wordTrieArr[i * 2 + 1] = wordArr[i];
        }
        LinkedList<Trie> matchedTrie = new LinkedList<Trie>();
        for (int i = minTrie; i <= maxTrie; ++i) {
            Map trieMap = tries.getOrDefault(i, new HashMap());
            boolean isLeadingMatchOnly = false;
            boolean isTrailingMatchOnly = false;
            for (int j = 0; j <= word.length() - i; ++j) {
                isLeadingMatchOnly = j == 0;
                isTrailingMatchOnly = j == word.length() - i;
                String sub = word.substring(j, j + i);
                if (!trieMap.containsKey(sub)) continue;
                List tries = (List)trieMap.get(sub);
                for (Trie trie : tries) {
                    if (trie.isLeadingMatch() && !isLeadingMatchOnly || trie.isTrailingMatch() && !isTrailingMatchOnly) continue;
                    Hyphenator.updateWordArr(wordTrieArr, j * 2, trie);
                    matchedTrie.add(trie);
                }
            }
        }
        result.tries(matchedTrie);
        result.trieWord(Hyphenator.groupByToken(wordTrieArr));
        List<String> syllables = Hyphenator.groupBySyllable(wordTrieArr);
        result.syllables(syllables);
        result.hyphenWord(Hyphenator.hyphenWord(syllables));
        return result;
    }

    private static void validate(String word) {
        if (word == null || word.trim().isEmpty()) {
            throw new IllegalArgumentException("word cannot be null or blank");
        }
        if (!word.matches("^[a-zA-Z]+$")) {
            throw new IllegalArgumentException("word must contain alpha characters only");
        }
    }

    private static String hyphenWord(List<String> syllables) {
        return syllables.stream().collect(Collectors.joining("-"));
    }

    private static String groupByToken(char[] wordTrieArr) {
        return IntStream.range(1, wordTrieArr.length).mapToObj(i -> Character.valueOf(wordTrieArr[i])).map(c -> c.toString()).filter(c -> !"0".equals(c)).collect(Collectors.joining());
    }

    private static List<String> groupBySyllable(char[] wordTrieArr) {
        LinkedList<String> syllables = new LinkedList<String>();
        int start = 1;
        for (int i = 2; i < wordTrieArr.length; i += 2) {
            if (wordTrieArr[i] % 2 == 0) continue;
            syllables.add(Hyphenator.joinWord(wordTrieArr, start, i));
            start = i;
        }
        syllables.add(Hyphenator.joinWord(wordTrieArr, start, wordTrieArr.length));
        return syllables;
    }

    private static String joinWord(char[] wordTrieArr, int start, int end) {
        return IntStream.range(start, end).filter(j -> j % 2 != 0).mapToObj(j -> Character.valueOf(wordTrieArr[j])).map(c -> c.toString()).collect(Collectors.joining());
    }

    private static void updateWordArr(char[] wordTrieArr, int index, Trie trie) {
        char[] trieArr = trie.arr();
        for (int i = 0; i < trieArr.length && i + index < wordTrieArr.length; i += 2) {
            if (trieArr[i] <= wordTrieArr[i + index]) continue;
            wordTrieArr[i + index] = trieArr[i];
        }
    }

    static {
        Hyphenator.loadHyphens();
        Hyphenator.loadEdges();
    }
}

