/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

@JacksonStdImpl
public class StdKeyDeserializer
extends KeyDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_BYTE = 2;
    public static final int TYPE_SHORT = 3;
    public static final int TYPE_CHAR = 4;
    public static final int TYPE_INT = 5;
    public static final int TYPE_LONG = 6;
    public static final int TYPE_FLOAT = 7;
    public static final int TYPE_DOUBLE = 8;
    public static final int TYPE_LOCALE = 9;
    public static final int TYPE_DATE = 10;
    public static final int TYPE_CALENDAR = 11;
    public static final int TYPE_UUID = 12;
    public static final int TYPE_URI = 13;
    public static final int TYPE_URL = 14;
    public static final int TYPE_CLASS = 15;
    public static final int TYPE_CURRENCY = 16;
    protected final int _kind;
    protected final Class<?> _keyClass;
    protected final FromStringDeserializer<?> _deser;

    protected StdKeyDeserializer(int kind, Class<?> cls) {
        this(kind, cls, null);
    }

    protected StdKeyDeserializer(int kind, Class<?> cls, FromStringDeserializer<?> deser) {
        this._kind = kind;
        this._keyClass = cls;
        this._deser = deser;
    }

    public static StdKeyDeserializer forType(Class<?> raw) {
        int kind;
        if (raw == String.class || raw == Object.class) {
            return StringKD.forType(raw);
        }
        if (raw == UUID.class) {
            kind = 12;
        } else if (raw == Integer.class) {
            kind = 5;
        } else if (raw == Long.class) {
            kind = 6;
        } else if (raw == Date.class) {
            kind = 10;
        } else if (raw == Calendar.class) {
            kind = 11;
        } else if (raw == Boolean.class) {
            kind = 1;
        } else if (raw == Byte.class) {
            kind = 2;
        } else if (raw == Character.class) {
            kind = 4;
        } else if (raw == Short.class) {
            kind = 3;
        } else if (raw == Float.class) {
            kind = 7;
        } else if (raw == Double.class) {
            kind = 8;
        } else if (raw == URI.class) {
            kind = 13;
        } else if (raw == URL.class) {
            kind = 14;
        } else if (raw == Class.class) {
            kind = 15;
        } else {
            if (raw == Locale.class) {
                FromStringDeserializer.Std deser = FromStringDeserializer.findDeserializer(Locale.class);
                return new StdKeyDeserializer(9, raw, deser);
            }
            if (raw == Currency.class) {
                FromStringDeserializer.Std deser = FromStringDeserializer.findDeserializer(Currency.class);
                return new StdKeyDeserializer(16, raw, deser);
            }
            return null;
        }
        return new StdKeyDeserializer(kind, raw);
    }

    @Override
    public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
        if (key == null) {
            return null;
        }
        try {
            Object result2 = this._parse(key, ctxt);
            if (result2 != null) {
                return result2;
            }
        }
        catch (Exception re) {
            throw ctxt.weirdKeyException(this._keyClass, key, "not a valid representation: " + re.getMessage());
        }
        if (this._keyClass.isEnum() && ctxt.getConfig().isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return null;
        }
        throw ctxt.weirdKeyException(this._keyClass, key, "not a valid representation");
    }

    public Class<?> getKeyClass() {
        return this._keyClass;
    }

    protected Object _parse(String key, DeserializationContext ctxt) throws Exception {
        switch (this._kind) {
            case 1: {
                if ("true".equals(key)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(key)) {
                    return Boolean.FALSE;
                }
                throw ctxt.weirdKeyException(this._keyClass, key, "value not 'true' or 'false'");
            }
            case 2: {
                int value = this._parseInt(key);
                if (value < -128 || value > 255) {
                    throw ctxt.weirdKeyException(this._keyClass, key, "overflow, value can not be represented as 8-bit value");
                }
                return (byte)value;
            }
            case 3: {
                int value = this._parseInt(key);
                if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                    throw ctxt.weirdKeyException(this._keyClass, key, "overflow, value can not be represented as 16-bit value");
                }
                return (short)value;
            }
            case 4: {
                if (key.length() == 1) {
                    return Character.valueOf(key.charAt(0));
                }
                throw ctxt.weirdKeyException(this._keyClass, key, "can only convert 1-character Strings");
            }
            case 5: {
                return this._parseInt(key);
            }
            case 6: {
                return this._parseLong(key);
            }
            case 7: {
                return Float.valueOf((float)this._parseDouble(key));
            }
            case 8: {
                return this._parseDouble(key);
            }
            case 9: {
                try {
                    return this._deser._deserialize(key, ctxt);
                }
                catch (IOException e) {
                    throw ctxt.weirdKeyException(this._keyClass, key, "unable to parse key as locale");
                }
            }
            case 16: {
                try {
                    return this._deser._deserialize(key, ctxt);
                }
                catch (IOException e) {
                    throw ctxt.weirdKeyException(this._keyClass, key, "unable to parse key as currency");
                }
            }
            case 10: {
                return ctxt.parseDate(key);
            }
            case 11: {
                Date date = ctxt.parseDate(key);
                return date == null ? null : ctxt.constructCalendar(date);
            }
            case 12: {
                return UUID.fromString(key);
            }
            case 13: {
                return URI.create(key);
            }
            case 14: {
                return new URL(key);
            }
            case 15: {
                try {
                    return ctxt.findClass(key);
                }
                catch (Exception e) {
                    throw ctxt.weirdKeyException(this._keyClass, key, "unable to parse key as Class");
                }
            }
        }
        return null;
    }

    protected int _parseInt(String key) throws IllegalArgumentException {
        return Integer.parseInt(key);
    }

    protected long _parseLong(String key) throws IllegalArgumentException {
        return Long.parseLong(key);
    }

    protected double _parseDouble(String key) throws IllegalArgumentException {
        return NumberInput.parseDouble(key);
    }

    static final class StringFactoryKeyDeserializer
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        final Method _factoryMethod;

        public StringFactoryKeyDeserializer(Method fm) {
            super(-1, fm.getDeclaringClass());
            this._factoryMethod = fm;
        }

        @Override
        public Object _parse(String key, DeserializationContext ctxt) throws Exception {
            return this._factoryMethod.invoke(null, key);
        }
    }

    static final class StringCtorKeyDeserializer
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        protected final Constructor<?> _ctor;

        public StringCtorKeyDeserializer(Constructor<?> ctor) {
            super(-1, ctor.getDeclaringClass());
            this._ctor = ctor;
        }

        @Override
        public Object _parse(String key, DeserializationContext ctxt) throws Exception {
            return this._ctor.newInstance(key);
        }
    }

    @JacksonStdImpl
    static final class EnumKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        protected final EnumResolver _byNameResolver;
        protected final AnnotatedMethod _factory;
        protected EnumResolver _byToStringResolver;

        protected EnumKD(EnumResolver er, AnnotatedMethod factory) {
            super(-1, er.getEnumClass());
            this._byNameResolver = er;
            this._factory = factory;
        }

        @Override
        public Object _parse(String key, DeserializationContext ctxt) throws JsonMappingException {
            EnumResolver res;
            Enum<?> e;
            if (this._factory != null) {
                try {
                    return this._factory.call1(key);
                }
                catch (Exception e2) {
                    ClassUtil.unwrapAndThrowAsIAE(e2);
                }
            }
            if ((e = (res = ctxt.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING) ? this._getToStringResolver() : this._byNameResolver).findEnum(key)) == null && !ctxt.getConfig().isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                throw ctxt.weirdKeyException(this._keyClass, key, "not one of values excepted for Enum class: " + res.getEnumIds());
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EnumResolver _getToStringResolver() {
            EnumResolver res = this._byToStringResolver;
            if (res == null) {
                EnumKD enumKD = this;
                synchronized (enumKD) {
                    res = EnumResolver.constructUnsafeUsingToString(this._byNameResolver.getEnumClass());
                }
            }
            return res;
        }
    }

    static final class DelegatingKD
    extends KeyDeserializer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Class<?> _keyClass;
        protected final JsonDeserializer<?> _delegate;

        protected DelegatingKD(Class<?> cls, JsonDeserializer<?> deser) {
            this._keyClass = cls;
            this._delegate = deser;
        }

        @Override
        public final Object deserializeKey(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (key == null) {
                return null;
            }
            try {
                Object result2 = this._delegate.deserialize(ctxt.getParser(), ctxt);
                if (result2 != null) {
                    return result2;
                }
            }
            catch (Exception re) {
                throw ctxt.weirdKeyException(this._keyClass, key, "not a valid representation: " + re.getMessage());
            }
            throw ctxt.weirdKeyException(this._keyClass, key, "not a valid representation");
        }

        public Class<?> getKeyClass() {
            return this._keyClass;
        }
    }

    @JacksonStdImpl
    static final class StringKD
    extends StdKeyDeserializer {
        private static final long serialVersionUID = 1L;
        private static final StringKD sString = new StringKD(String.class);
        private static final StringKD sObject = new StringKD(Object.class);

        private StringKD(Class<?> nominalType) {
            super(-1, nominalType);
        }

        public static StringKD forType(Class<?> nominalType) {
            if (nominalType == String.class) {
                return sString;
            }
            if (nominalType == Object.class) {
                return sObject;
            }
            return new StringKD(nominalType);
        }

        @Override
        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return key;
        }
    }
}

