/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.bootstrapper.builder;

import io.wizzie.bootstrapper.bootstrappers.base.ThreadBootstrapper;
import io.wizzie.bootstrapper.builder.Bootstrapper;
import io.wizzie.bootstrapper.builder.Config;
import io.wizzie.bootstrapper.builder.Listener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapperBuilder {
    private static final Logger log = LoggerFactory.getLogger(BootstrapperBuilder.class);
    Config config;
    String className = "io.wizzie.bootstrapper.bootstrappers.impl.DummyBootstrapper";
    List<Listener> listeners = new ArrayList<Listener>();
    String filePath;
    Map<String, Object> configMap;

    public static BootstrapperBuilder makeBuilder() {
        return new BootstrapperBuilder();
    }

    public BootstrapperBuilder boostrapperClass(String className) {
        this.className = className;
        return this;
    }

    public BootstrapperBuilder listener(Listener listener) {
        this.listeners.add(listener);
        return this;
    }

    public BootstrapperBuilder withConfigFile(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public BootstrapperBuilder withConfigMap(Map<String, Object> configMap) {
        this.configMap = configMap;
        return this;
    }

    public BootstrapperBuilder withConfigInstance(Config config) {
        this.config = config;
        return this;
    }

    public BootstrapperBuilder listeners(List<Listener> listeners) {
        listeners.addAll(listeners);
        return this;
    }

    public Bootstrapper build() {
        Bootstrapper bootstrapper = null;
        try {
            Class<?> bootstraperClass = Class.forName(this.className);
            bootstrapper = (Bootstrapper)bootstraperClass.newInstance();
            if (this.config == null) {
                this.config = new Config(this.filePath, this.configMap);
            }
            bootstrapper.prepare(this.config, this.listeners);
            if (bootstrapper instanceof ThreadBootstrapper) {
                ((ThreadBootstrapper)bootstrapper).start();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error(String.format("Can't build the bootstrapper class [%s]", this.className), e);
        }
        catch (Exception e) {
            log.error("Exception on initializing the bootstrapper", e);
            bootstrapper = null;
        }
        return bootstrapper;
    }
}

