/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.enricher.enrichment;

import io.wizzie.enricher.enrichment.simple.BaseEnrich;
import io.wizzie.metrics.MetricsManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacVendorEnrich
extends BaseEnrich {
    private static final Logger log = LoggerFactory.getLogger(MacVendorEnrich.class);
    String ouiFilePath;
    String mac;
    String macVendor;
    public Map<String, String> ouiMap;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.ouiFilePath = (String)properties.getOrDefault("oui.file.path", "/opt/etc/objects/mac_vendors");
        this.mac = (String)properties.getOrDefault("mac.dim", "mac");
        this.macVendor = (String)properties.getOrDefault("mac.vendor.dim", "mac_vendor");
        this.ouiMap = new HashMap<String, String>();
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.ouiFilePath);
        }
        catch (FileNotFoundException e) {
            log.error("The MacVendor file couldn't be found", e);
        }
        if (in != null) {
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line = br.readLine();
                while (line != null) {
                    String[] tokens = line.split("\\|");
                    if (tokens.length == 2) {
                        this.ouiMap.put(tokens[0], tokens[1]);
                    }
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Map<String, Object> enrich(Map<String, Object> message) {
        String oui;
        HashMap<String, Object> vendorMap = new HashMap<String, Object>();
        vendorMap.putAll(message);
        String clientMac = (String)message.get(this.mac);
        if (clientMac != null && this.ouiMap.get(oui = this.buildOui(clientMac)) != null) {
            vendorMap.put(this.macVendor, this.ouiMap.get(oui));
        }
        return vendorMap;
    }

    private String buildOui(Object object) {
        String mac = object.toString();
        mac = mac.trim().replaceAll("[-:]", "");
        return mac.substring(0, 6).toUpperCase();
    }

    @Override
    public void stop() {
    }
}

