/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.enricher.enrichment.geoip;

import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import io.wizzie.enricher.enrichment.simple.BaseEnrich;
import io.wizzie.metrics.MetricsManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIpEnrich
extends BaseEnrich {
    private static final Logger log = LoggerFactory.getLogger(GeoIpEnrich.class);
    String SRC_COUNTRY_CODE = "src_country_code";
    String DST_COUNTRY_CODE = "dst_country_code";
    String SRC_CITY = "src_city";
    String DST_CITY = "dst_city";
    String SRC_IP = "src";
    String DST_IP = "dst";
    String SRC_AS_NAME = "src_as_name";
    String DST_AS_NAME = "dst_as_name";
    String SRC_LATITUDE = "src_latitude";
    String SRC_LONGITUDE = "src_longitude";
    String DST_LATITUDE = "dst_latitude";
    String DST_LONGITUDE = "dst_longitude";
    public Pattern VALID_IPV4_PATTERN = null;
    public Pattern VALID_IPV6_PATTERN = null;
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";
    LookupService city;
    LookupService city6;
    LookupService asn;
    LookupService asn6;

    @Override
    public void prepare(Map<String, Object> properties, MetricsManager metricsManager) {
        this.SRC_COUNTRY_CODE = (String)properties.getOrDefault("src.country.code.dim", "src_country_code");
        this.DST_COUNTRY_CODE = (String)properties.getOrDefault("dst.country.code.dim", "dst_country_code");
        this.SRC_CITY = (String)properties.getOrDefault("src.city.dim", "src_city");
        this.DST_CITY = (String)properties.getOrDefault("dst.city.dim", "dst_city");
        this.SRC_IP = (String)properties.getOrDefault("src.dim", "src");
        this.DST_IP = (String)properties.getOrDefault("dst.dim", "dst");
        this.SRC_AS_NAME = (String)properties.getOrDefault("src.as.name.dim", "src_as_name");
        this.DST_AS_NAME = (String)properties.getOrDefault("dst.as.name.dim", "dst_as_name");
        this.SRC_LATITUDE = (String)properties.getOrDefault("src.latitude.dim", "src_latitude");
        this.SRC_LONGITUDE = (String)properties.getOrDefault("src.longitude.dim", "src_longitude");
        this.DST_LATITUDE = (String)properties.getOrDefault("dst.latitude.dim", "dst_latitude");
        this.DST_LONGITUDE = (String)properties.getOrDefault("dst.longitude.dim", "dst_longitude");
        String ASN_V6_DB_PATH = (String)properties.getOrDefault("asn6.db.path", "/opt/share/GeoIP/asnv6.dat");
        String ASN_DB_PATH = (String)properties.getOrDefault("asn.db.path", "/opt/share/GeoIP/asn.dat");
        String CITY_V6_DB_PATH = (String)properties.getOrDefault("city6.db.path", "/opt/share/GeoIP/cityv6.dat");
        String CITY_DB_PATH = (String)properties.getOrDefault("city.db.path", "/opt/share/GeoIP/city.dat");
        try {
            this.city = new LookupService(CITY_DB_PATH, 1);
            this.city6 = new LookupService(CITY_V6_DB_PATH, 1);
            this.asn = new LookupService(ASN_DB_PATH, 1);
            this.asn6 = new LookupService(ASN_V6_DB_PATH, 1);
            this.VALID_IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
            this.VALID_IPV6_PATTERN = Pattern.compile(ipv6Pattern, 2);
        }
        catch (IOException ex) {
            log.error(ex.toString(), ex);
        }
        catch (PatternSyntaxException e) {
            log.error("Unable to compile IP check patterns");
        }
    }

    @Override
    public Map<String, Object> enrich(Map<String, Object> message) {
        HashMap<String, Object> geoIPMap = new HashMap<String, Object>();
        geoIPMap.putAll(message);
        String src = (String)message.get(this.SRC_IP);
        String dst = (String)message.get(this.DST_IP);
        Map<String, Object> srcData = this.getDataByIpAndSite(src, this.SRC_COUNTRY_CODE, this.SRC_CITY, this.SRC_AS_NAME, this.SRC_LATITUDE, this.SRC_LONGITUDE);
        Map<String, Object> dstData = this.getDataByIpAndSite(dst, this.DST_COUNTRY_CODE, this.DST_CITY, this.DST_AS_NAME, this.DST_LATITUDE, this.DST_LONGITUDE);
        if (srcData != null) {
            geoIPMap.putAll(srcData);
        }
        if (dstData != null) {
            geoIPMap.putAll(dstData);
        }
        return geoIPMap;
    }

    public Map<String, Object> getDataByIpAndSite(String ip, String countryCodeDim, String cityDim, String asNameDim, String latidudeDim, String longitudeDim) {
        HashMap<String, Object> geoIPMap = null;
        if (ip != null) {
            Float longitude;
            Float latitude;
            String city;
            String countryCode;
            geoIPMap = new HashMap<String, Object>();
            Map<Object, Object> locations = new HashMap();
            String asn_name = null;
            if (this.VALID_IPV4_PATTERN != null) {
                locations = this.getCountryCode(ip);
                asn_name = this.getAsnName(ip);
            }
            if ((countryCode = (String)locations.get("country_code")) != null) {
                geoIPMap.put(countryCodeDim, countryCode);
            }
            if ((city = (String)locations.get("city")) != null) {
                geoIPMap.put(cityDim, city);
            }
            if (asn_name != null) {
                geoIPMap.put(asNameDim, asn_name);
            }
            if ((latitude = (Float)locations.get("latitude")) != null) {
                geoIPMap.put(latidudeDim, latitude);
            }
            if ((longitude = (Float)locations.get("longitude")) != null) {
                geoIPMap.put(longitudeDim, longitude);
            }
        }
        return geoIPMap;
    }

    @Override
    public void stop() {
        this.asn.close();
        this.asn6.close();
        this.city6.close();
        this.city.close();
    }

    private Map<String, Object> getCountryCode(String ip) {
        HashMap<String, Object> locations = new HashMap<String, Object>();
        Matcher match = this.VALID_IPV4_PATTERN.matcher(ip);
        Location location = match.matches() ? this.city.getLocation(ip) : this.city6.getLocationV6(ip);
        if (location != null) {
            locations.put("latitude", Float.valueOf(location.latitude));
            locations.put("longitude", Float.valueOf(location.longitude));
            locations.put("country_code", location.countryCode);
            locations.put("city", location.city);
        }
        return locations;
    }

    private String getAsnName(String ip) {
        Matcher match = this.VALID_IPV4_PATTERN.matcher(ip);
        String asnName = null;
        String asnInfo = null;
        asnInfo = match.matches() ? this.asn.getOrg(ip) : this.asn6.getOrgV6(ip);
        if (asnInfo != null) {
            String[] asn = asnInfo.split(" ", 2);
            if (asn.length > 1) {
                if (asn[1] != null) {
                    asnName = asn[1];
                }
            } else if (asn[0] != null) {
                asnName = asn[0];
            }
        }
        return asnName;
    }
}

