/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.enricher.model;

import com.cookingfox.guava_preconditions.Preconditions;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.wizzie.bootstrapper.builder.Config;
import io.wizzie.enricher.model.EnricherModel;
import io.wizzie.enricher.model.JoinerModel;
import io.wizzie.enricher.model.exceptions.MaxOutputKafkaTopics;
import io.wizzie.enricher.model.exceptions.PlanBuilderException;
import io.wizzie.enricher.query.EnricherCompiler;
import io.wizzie.enricher.query.antlr4.Join;
import io.wizzie.enricher.query.antlr4.Query;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PlanModel {
    Map<String, Query> queries = new LinkedHashMap<String, Query>();
    List<JoinerModel> joiners = new ArrayList<JoinerModel>();
    List<EnricherModel> enrichers = new ArrayList<EnricherModel>();

    @JsonCreator
    public PlanModel(@JsonProperty(value="joiners") List<JoinerModel> joiners, @JsonProperty(value="queries") Map<String, String> queries, @JsonProperty(value="enrichers") List<EnricherModel> enrichers) {
        Preconditions.checkNotNull(queries, "queries cannot be null");
        if (joiners != null) {
            this.joiners.addAll(joiners);
        }
        queries.forEach((name, queryString) -> {
            Query query = EnricherCompiler.parse(queryString);
            this.queries.put((String)name, query);
        });
        if (enrichers != null) {
            this.enrichers.addAll(enrichers);
        }
    }

    @JsonProperty
    public Map<String, Query> getQueries() {
        return this.queries;
    }

    @JsonProperty
    public List<JoinerModel> getJoiners() {
        return this.joiners;
    }

    @JsonProperty
    public List<EnricherModel> getEnrichers() {
        return this.enrichers;
    }

    public void validate(Config config) throws PlanBuilderException {
        List definedJoiners = this.joiners.stream().map(joiner -> joiner.name).collect(Collectors.toList());
        List definedEnrichers = this.enrichers.stream().map(enricher -> enricher.name).collect(Collectors.toList());
        for (Map.Entry<String, Query> queryEntry : this.queries.entrySet()) {
            List<String> enrichers = queryEntry.getValue().getEnrichWiths();
            List<Join> joiners = queryEntry.getValue().getJoins();
            if (enrichers != null) {
                for (String enricher2 : enrichers) {
                    if (definedEnrichers.contains(enricher2)) continue;
                    throw new PlanBuilderException(String.format("Enricher[%s]: Not defined", enricher2));
                }
            }
            if (joiners == null) continue;
            for (Join joiner2 : joiners) {
                String joinerName = joiner2.getJoinerName();
                if (definedJoiners.contains(joinerName)) continue;
                throw new PlanBuilderException(String.format("BaseJoiner[%s]: Not defined", joinerName));
            }
        }
        this.validateKafkaOutputs(config);
    }

    private void validateKafkaOutputs(Config config) throws MaxOutputKafkaTopics {
        Long kafkaOutputs = this.queries.entrySet().stream().map(Map.Entry::getValue).map(Query::getInsert).filter(Objects::nonNull).count();
        Integer maxKafkaOutputs = config.getOrDefault("max.kafka.output.topics", Integer.MAX_VALUE);
        if (kafkaOutputs > (long)maxKafkaOutputs.intValue()) {
            throw new MaxOutputKafkaTopics(String.format("You try to create [%s] topics, and the limit is [%s]", kafkaOutputs, maxKafkaOutputs));
        }
    }

    public String printExecutionPlan() {
        return "";
    }
}

