/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.enricher.query.antlr4;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.enricher.query.antlr4.Stream;
import java.util.Collections;
import java.util.List;

public class Join {
    List<String> dimensions;
    Stream topic;
    String joinerName;
    String partitionKey;

    public Join(Stream topic, String joinerName) {
        this(topic, joinerName, Collections.EMPTY_LIST);
    }

    public Join(Stream topic, String joinerName, List<String> dimensions) {
        this(topic, joinerName, dimensions, "__KEY");
    }

    public Join(Stream topic, String joinerName, List<String> dimensions, String partitionKey) {
        this.topic = Preconditions.checkNotNull(topic, "<topic> attribute is required");
        this.joinerName = Preconditions.checkNotNull(joinerName, "<joinerName> attribute is required");
        this.dimensions = Preconditions.checkNotNull(dimensions, "<dimensions> is required");
        this.partitionKey = Preconditions.checkNotNull(partitionKey, "<partitionKey> is required");
    }

    public void setStream(Stream stream) {
        this.topic = stream;
    }

    public Stream getStream() {
        return this.topic;
    }

    public void setDimensions(List<String> newDimensions) {
        this.dimensions = newDimensions;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public void setJoinerName(String newClassName) {
        this.joinerName = newClassName;
    }

    public String getJoinerName() {
        return this.joinerName;
    }

    public void setPartitionKey(String newPartitionKey) {
        this.partitionKey = newPartitionKey;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void validate() {
        Preconditions.checkNotNull(this.dimensions, "At least a dimensions list is required");
        Preconditions.checkNotNull(this.topic, "At least a topic is required");
        Preconditions.checkNotNull(this.joinerName, "At least a joiner class name is required");
        this.topic.validate();
    }
}

