/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.enricher.query.antlr4;

import com.cookingfox.guava_preconditions.Preconditions;
import io.wizzie.enricher.query.antlr4.Join;
import io.wizzie.enricher.query.antlr4.Select;
import io.wizzie.enricher.query.antlr4.Stream;
import java.util.Collections;
import java.util.List;

public class Query {
    Select select;
    List<Join> joins;
    List<String> enrichWiths;
    Stream insertTopic;

    public Query(Select select, Stream insertTopic) {
        this(select, insertTopic, Collections.EMPTY_LIST);
    }

    public Query(Select select, Stream insertTopic, List<Join> joins) {
        this(select, insertTopic, joins, Collections.EMPTY_LIST);
    }

    public Query(Select select, Stream insertTopic, List<Join> joins, List<String> enrichWiths) {
        this.select = Preconditions.checkNotNull(select, "SELECT cannot be null");
        this.joins = Preconditions.checkNotNull(joins, "JOINS cannot be null");
        this.insertTopic = Preconditions.checkNotNull(insertTopic, "INSERT cannot be null");
        this.enrichWiths = Preconditions.checkNotNull(enrichWiths, "ENRICH WITH cannot be null");
    }

    public void setSelect(Select newSelect) {
        this.select = newSelect;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setJoins(List<Join> newJoinsList) {
        this.joins = newJoinsList;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void addJoin(Join newJoin) {
        this.joins.add(newJoin);
    }

    public void setinsert(Stream newStream) {
        this.insertTopic = newStream;
    }

    public Stream getInsert() {
        return this.insertTopic;
    }

    public void setEnrichWiths(List<String> enrichWiths) {
        this.enrichWiths = enrichWiths;
    }

    public List<String> getEnrichWiths() {
        return this.enrichWiths;
    }

    public void validate() {
        Preconditions.checkNotNull(this.select, "SELECT cannot be null");
        this.select.validate();
        Preconditions.checkNotNull(this.joins, "JOINS cannot be null");
        this.joins.forEach(Join::validate);
        Preconditions.checkNotNull(this.insertTopic, "INSERT cannot be null");
        this.insertTopic.validate();
        Preconditions.checkNotNull(this.enrichWiths, "ENRICH WITH cannot be null");
    }
}

