/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import io.wizzie.metrics.ConversionUtils;
import io.wizzie.metrics.listeners.MetricListener;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsManager
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(MetricsManager.class);
    public MetricRegistry registry = new MetricRegistry();
    public List<MetricListener> listeners = new ArrayList<MetricListener>();
    public Set<String> registredMetrics = new HashSet<String>();
    public String app_id;
    public Map<String, Object> config;
    public Long interval;
    public AtomicBoolean running = new AtomicBoolean(true);
    AtomicBoolean verboseMode = new AtomicBoolean();

    public MetricsManager(Map<String, Object> config) {
        if (((Boolean)config.getOrDefault("metric.enable", false)).booleanValue()) {
            this.config = config;
            this.interval = ConversionUtils.toLong(config.getOrDefault("metric.interval", 60000L));
            this.app_id = (String)config.get("application.id");
            this.verboseMode.set((Boolean)config.getOrDefault("metric.verbose.mode", false));
            List<String> listenersClass = config.getOrDefault("metric.listeners", Collections.singletonList("io.wizzie.metrics.listeners.ConsoleMetricListener"));
            if (listenersClass != null) {
                for (String listenerClassName : listenersClass) {
                    try {
                        Class<?> listenerClass = Class.forName(listenerClassName);
                        MetricListener metricListener = (MetricListener)listenerClass.newInstance();
                        metricListener.init(new HashMap<String, Object>(config));
                        this.listeners.add(metricListener);
                    }
                    catch (ClassNotFoundException e) {
                        log.error("Couldn't find the class associated with the metric listener {}", (Object)listenerClassName);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        log.error("Couldn't create the instance associated with the metric listener " + listenerClassName, e);
                    }
                }
            }
            this.registerJVMMetrics();
            log.info("Start MetricsManager with listeners {}", (Object)this.listeners.stream().map(MetricListener::name).collect(Collectors.toList()));
            if (this.listeners.isEmpty()) {
                log.warn("Stop MetricsManager because doesn't have listeners!!");
                this.running.set(false);
            }
        } else {
            this.running.set(false);
        }
    }

    @Override
    public void run() {
        while (this.running.get()) {
            this.sendAllMetrics();
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void registerJVMMetrics() {
        this.registerAll("gc", new GarbageCollectorMetricSet());
        this.registerAll("buffers", new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.registerAll("memory", new MemoryUsageGaugeSet());
        this.registerAll("threads", new CachedThreadStatesGaugeSet(10L, TimeUnit.SECONDS));
    }

    private void registerAll(String prefix, MetricSet metricSet) {
        for (Map.Entry<String, Metric> entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + entry.getKey(), (MetricSet)entry.getValue());
                continue;
            }
            this.registry.register(prefix + "." + entry.getKey(), entry.getValue());
        }
    }

    public void registerMetric(String metricName, Metric metric) {
        if (this.running.get()) {
            if (!this.registredMetrics.contains(metricName)) {
                this.registry.register(metricName, metric);
                this.registredMetrics.add(metricName);
            } else {
                log.warn("The metric with name [{}] is duplicated!", (Object)metric);
            }
        } else {
            log.warn("You try to register metric but system is disabled!!");
        }
    }

    public void removeMetric(String metricName) {
        if (this.running.get()) {
            if (this.registredMetrics.contains(metricName)) {
                this.registry.remove(metricName);
                this.registredMetrics.remove(metricName);
            } else {
                log.warn("Try to delete unregister metric [{}]", (Object)metricName);
            }
        } else {
            log.warn("You try to remove metric but system is disabled!!");
        }
    }

    public void clean() {
        this.registredMetrics.forEach(metric -> this.registry.remove((String)metric));
        this.registredMetrics.clear();
    }

    private void sendGaugeMetric(String metricName) {
        Gauge selectedGauge = (Gauge)this.registry.getGauges().get(metricName);
        this.listeners.forEach(listener -> listener.updateMetric(metricName, selectedGauge.getValue()));
    }

    private void sendMeterMetric(String metricName) {
        Meter selectedMeter = (Meter)this.registry.getMeters().get(metricName);
        this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-mean-rate", metricName), selectedMeter.getMeanRate()));
        if (this.verboseMode.get()) {
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-count", metricName), selectedMeter.getCount()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-1-minute-rate", metricName), selectedMeter.getOneMinuteRate()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-5-minute-rate", metricName), selectedMeter.getFiveMinuteRate()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-15-minute-rate", metricName), selectedMeter.getFifteenMinuteRate()));
        }
    }

    private void sendHistogramMetric(String metricName) {
        Histogram selectedHistogram = (Histogram)this.registry.getHistograms().get(metricName);
        this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-count", metricName), selectedHistogram.getCount()));
        if (this.verboseMode.get()) {
            Snapshot histogramSnapshot = selectedHistogram.getSnapshot();
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-max-value", metricName), histogramSnapshot.getMax()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-min-value", metricName), histogramSnapshot.getMin()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-mean-value", metricName), histogramSnapshot.getMean()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-median-value", metricName), histogramSnapshot.getMedian()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-standard-deviation-value", metricName), histogramSnapshot.getStdDev()));
        }
    }

    private void sendCounterMetric(String metricName) {
        Counter selectedCounter = (Counter)this.registry.getCounters().get(metricName);
        this.listeners.forEach(listener -> listener.updateMetric(metricName, selectedCounter.getCount()));
    }

    private void sendTimerMetric(String metricName) {
        Timer selectedTimer = (Timer)this.registry.getTimers().get(metricName);
        this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-count", metricName), selectedTimer.getCount()));
        if (this.verboseMode.get()) {
            Snapshot timerSnapshot = selectedTimer.getSnapshot();
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-max-value", metricName), timerSnapshot.getMax()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-min-value", metricName), timerSnapshot.getMin()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-mean-value", metricName), timerSnapshot.getMean()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-median-value", metricName), timerSnapshot.getMedian()));
            this.listeners.forEach(listener -> listener.updateMetric(String.format("%s-standard-deviation-value", metricName), timerSnapshot.getStdDev()));
        }
    }

    private void sendAllMetrics() {
        this.registry.getGauges().keySet().forEach(this::sendGaugeMetric);
        this.registry.getMeters().keySet().forEach(this::sendMeterMetric);
        this.registry.getHistograms().keySet().forEach(this::sendHistogramMetric);
        this.registry.getCounters().keySet().forEach(this::sendCounterMetric);
        this.registry.getTimers().keySet().forEach(this::sendTimerMetric);
    }

    @Override
    public void interrupt() {
        this.running.set(false);
        this.listeners.forEach(MetricListener::close);
        log.info("Stop MetricsManager");
    }
}

