/*
 * Decompiled with CFR 0.152.
 */
package io.wizzie.metrics.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.wizzie.metrics.listeners.MetricListener;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleMetricListener
implements MetricListener {
    private static final Logger log = LoggerFactory.getLogger(ConsoleMetricListener.class);
    ObjectMapper mapper;
    Map<String, Object> metricDataBag;

    @Override
    public void init(Map<String, Object> config) {
        this.metricDataBag = (Map)config.get("metric.databag");
        this.mapper = new ObjectMapper();
    }

    @Override
    public void updateMetric(String metricName, Object metricValue) {
        HashMap<String, Object> metric = new HashMap<String, Object>();
        metric.put("timestamp", System.currentTimeMillis() / 1000L);
        metric.put("monitor", metricName);
        metric.put("value", metricValue);
        if (this.metricDataBag != null) {
            metric.putAll(this.metricDataBag);
        }
        try {
            if (metricValue != null) {
                log.info(this.mapper.writeValueAsString(metric));
            }
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String name() {
        return "console";
    }
}

