/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.admin.DeleteRecordsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeleteRecordsCommand$ {
    public static DeleteRecordsCommand$ MODULE$;

    static {
        new DeleteRecordsCommand$();
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        return Option$.MODULE$.option2Iterable(Json$.MODULE$.parseFull(jsonData)).toSeq().flatMap((Function1<JsonValue, Seq> & Serializable & scala.Serializable)js -> Option$.MODULE$.option2Iterable(js.asJsonObject().get("partitions")).toSeq().flatMap((Function1<JsonValue, Buffer> & Serializable & scala.Serializable)partitionsJs -> partitionsJs.asJsonArray().iterator().map((Function1<JsonValue, JsonObject> & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject()).map((Function1<JsonObject, Tuple2> & Serializable & scala.Serializable)partitionJs -> {
            String topic = partitionJs.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt(partitionJs.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            long offset = BoxesRunTime.unboxToLong(partitionJs.apply("offset").to(DecodeJson$DecodeLong$.MODULE$));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(topic, partition)), BoxesRunTime.boxToLong(offset));
        }).toBuffer(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        AdminClient adminClient = this.createAdminClient(opts);
        String offsetJsonFile = opts.options().valueOf(opts.offsetJsonFileOpt());
        String offsetJsonString = Utils.readFileAsString(offsetJsonFile);
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(offsetSeq.map((Function1<Tuple2, TopicPartition> & Serializable & scala.Serializable)x0$1 -> {
            TopicPartition tp;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
            return topicPartition;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicatePartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Offset json file contains duplicate topic partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatePartitions.mkString(",")})));
        }
        out.println("Executing records delete operation");
        Map<TopicPartition, AdminClient.DeleteRecordsResult> deleteRecordsResult = adminClient.deleteRecordsBefore(offsetSeq.toMap(Predef$.MODULE$.$conforms())).get();
        out.println("Records delete operation completed:");
        deleteRecordsResult.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
            DeleteRecordsCommand$.$anonfun$execute$2(out, x0$2);
            return BoxedUnit.UNIT;
        });
        adminClient.close();
    }

    private AdminClient createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps(opts.options().valueOf(opts.commandConfigOpt())) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient$.MODULE$.create(props);
    }

    public static final /* synthetic */ void $anonfun$execute$2(PrintStream out$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            AdminClient.DeleteRecordsResult partitionResult = (AdminClient.DeleteRecordsResult)tuple2._2();
            if (partitionResult.error() == null) {
                out$1.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\tlow_watermark: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tp, BoxesRunTime.boxToLong(partitionResult.lowWatermark())})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                out$1.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\terror: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tp, partitionResult.error().toString()})));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError(tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private DeleteRecordsCommand$() {
        MODULE$ = this;
    }
}

