/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.KafkaException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class BrokerEndPoint$
implements scala.Serializable {
    public static BrokerEndPoint$ MODULE$;
    private final Regex uriParseExp;

    static {
        new BrokerEndPoint$();
    }

    private Regex uriParseExp() {
        return this.uriParseExp;
    }

    public Option<Tuple2<String, Object>> parseHostPort(String connectionString) {
        Option option;
        String string = connectionString;
        Option<List<String>> option2 = this.uriParseExp().unapplySeq(string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            Option option3;
            String host = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String port = (String)((LinearSeqOptimized)option2.get()).apply(1);
            try {
                option3 = new Some<Tuple2<String, Integer>>(new Tuple2<String, Integer>(host, BoxesRunTime.boxToInteger(new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            }
            catch (NumberFormatException numberFormatException) {
                option3 = None$.MODULE$;
            }
            option = option3;
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public BrokerEndPoint createBrokerEndPoint(int brokerId, String connectionString) {
        return (BrokerEndPoint)this.parseHostPort(connectionString).map((Function1<Tuple2, BrokerEndPoint> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, host, port);
            return brokerEndPoint;
        }).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
            throw new KafkaException("Unable to parse " + connectionString + " to a broker endpoint");
        });
    }

    public BrokerEndPoint readFrom(ByteBuffer buffer) {
        int brokerId = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new BrokerEndPoint(brokerId, host, port);
    }

    public BrokerEndPoint apply(int id, String host, int port) {
        return new BrokerEndPoint(id, host, port);
    }

    public Option<Tuple3<Object, String, Object>> unapply(BrokerEndPoint x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Integer, String, Integer>>(new Tuple3<Integer, String, Integer>(BoxesRunTime.boxToInteger(x$0.id()), x$0.host(), BoxesRunTime.boxToInteger(x$0.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BrokerEndPoint$() {
        MODULE$ = this;
        this.uriParseExp = new StringOps(Predef$.MODULE$.augmentString("\\[?([0-9a-zA-Z\\-%._:]*)\\]?:([0-9]+)")).r();
    }
}

