/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.common.NotificationHandler;
import kafka.common.ZkNodeChangeNotificationListener$;
import kafka.common.ZkNodeChangeNotificationListener$ChangeNotificationHandler$;
import kafka.common.ZkNodeChangeNotificationListener$ZkStateChangeHandler$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$String$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0001\u001d\u0011\u0001EW6O_\u0012,7\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o\u0019&\u001cH/\u001a8fe*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\t\u0001B_6DY&,g\u000e^\u000b\u0002/A\u0011\u0001dG\u0007\u00023)\u0011!\u0004B\u0001\u0003u.L!\u0001H\r\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011!q\u0002A!A!\u0002\u00139\u0012!\u0003>l\u00072LWM\u001c;!\u0011!\u0001\u0003A!b\u0001\n\u0013\t\u0013aC:fc:{G-\u001a*p_R,\u0012A\t\t\u0003G)r!\u0001\n\u0015\u0011\u0005\u0015RQ\"\u0001\u0014\u000b\u0005\u001d2\u0011A\u0002\u001fs_>$h(\u0003\u0002*\u0015\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tI#\u0002\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003#\u00031\u0019X-\u001d(pI\u0016\u0014vn\u001c;!\u0011!\u0001\u0004A!b\u0001\n\u0013\t\u0013!D:fc:{G-\u001a)sK\u001aL\u0007\u0010\u0003\u00053\u0001\t\u0005\t\u0015!\u0003#\u00039\u0019X-\u001d(pI\u0016\u0004&/\u001a4jq\u0002B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%I!N\u0001\u0014]>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM]\u000b\u0002mA\u0011q\u0007O\u0007\u0002\u0005%\u0011\u0011H\u0001\u0002\u0014\u001d>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005m\u0005!bn\u001c;jM&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7fe\u0002B\u0001\"\u0010\u0001\u0003\u0006\u0004%IAP\u0001\u0013G\"\fgnZ3FqBL'/\u0019;j_:l5/F\u0001@!\tI\u0001)\u0003\u0002B\u0015\t!Aj\u001c8h\u0011!\u0019\u0005A!A!\u0002\u0013y\u0014aE2iC:<W-\u0012=qSJ\fG/[8o\u001bN\u0004\u0003\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0002$\u0002\tQLW.Z\u000b\u0002\u000fB\u0011\u0001\nU\u0007\u0002\u0013*\u0011\u0011C\u0013\u0006\u0003\u0007-S!!\u0002'\u000b\u00055s\u0015AB1qC\u000eDWMC\u0001P\u0003\ry'oZ\u0005\u0003#&\u0013A\u0001V5nK\"A1\u000b\u0001B\u0001B\u0003%q)A\u0003uS6,\u0007\u0005C\u0003V\u0001\u0011\u0005a+\u0001\u0004=S:LGO\u0010\u000b\b/bK&l\u0017/^!\t9\u0004\u0001C\u0003\u0016)\u0002\u0007q\u0003C\u0003!)\u0002\u0007!\u0005C\u00031)\u0002\u0007!\u0005C\u00035)\u0002\u0007a\u0007C\u0004>)B\u0005\t\u0019A \t\u000f\u0015#\u0006\u0013!a\u0001\u000f\"9q\f\u0001a\u0001\n\u0013q\u0014A\u00057bgR,\u00050Z2vi\u0016$7\t[1oO\u0016Dq!\u0019\u0001A\u0002\u0013%!-\u0001\fmCN$X\t_3dkR,Gm\u00115b]\u001e,w\fJ3r)\t\u0019g\r\u0005\u0002\nI&\u0011QM\u0003\u0002\u0005+:LG\u000fC\u0004hA\u0006\u0005\t\u0019A \u0002\u0007a$\u0013\u0007\u0003\u0004j\u0001\u0001\u0006KaP\u0001\u0014Y\u0006\u001cH/\u0012=fGV$X\rZ\"iC:<W\r\t\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0003\u0015\tX/Z;f+\u0005i\u0007c\u00018vo6\tqN\u0003\u0002qc\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005I\u001c\u0018\u0001B;uS2T\u0011\u0001^\u0001\u0005U\u00064\u0018-\u0003\u0002w_\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB\u0011\u00010_\u0007\u0002\u0001\u0019!!\u0010\u0001\u0001|\u0005I\u0019\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8\u0014\u0005eD\u0001\"B+z\t\u0003iH#A<\t\r}LH\u0011AA\u0001\u0003\u001d\u0001(o\\2fgN$\u0012a\u0019\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003n\u0003\u0019\tX/Z;fA!I\u0011\u0011\u0002\u0001C\u0002\u0013%\u00111B\u0001\u0007i\"\u0014X-\u00193\u0016\u0005\u00055\u0001c\u0001=\u0002\u0010\u00191\u0011\u0011\u0003\u0001\u0001\u0003'\u0011\u0001d\u00115b]\u001e,WI^3oiB\u0013xnY3tgRC'/Z1e'\u0011\ty!!\u0006\u0011\u0007=\t9\"C\u0002\u0002\u001aA\u0011!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\"a\u0011QDA\b\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002 \u0005!a.Y7f\u0013\u0011\ti\"a\u0006\t\u000fU\u000by\u0001\"\u0001\u0002$Q!\u0011QBA\u0013\u0011\u001d\ti\"!\tA\u0002\tB\u0001\"!\u000b\u0002\u0010\u0011\u0005\u0013\u0011A\u0001\u0007I><vN]6\t\u0011\u00055\u0002\u0001)A\u0005\u0003\u001b\tq\u0001\u001e5sK\u0006$\u0007\u0005C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024\u0005A\u0011n]\"m_N,G-\u0006\u0002\u00026A!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<=\fa!\u0019;p[&\u001c\u0017\u0002BA \u0003s\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CA\"\u0001\u0001\u0006I!!\u000e\u0002\u0013%\u001c8\t\\8tK\u0012\u0004\u0003bBA$\u0001\u0011\u0005\u0011\u0011A\u0001\u0005S:LG\u000fC\u0004\u0002L\u0001!\t!!\u0001\u0002\u000b\rdwn]3\t\u000f\u0005=\u0003\u0001\"\u0003\u0002\u0002\u0005!\u0002O]8dKN\u001chj\u001c;jM&\u001c\u0017\r^5p]NDq!a\u0015\u0001\t\u0013\t\t!A\u000bbI\u0012\u001c\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005Q\u0002/\u001e:hK>\u00137o\u001c7fi\u0016tu\u000e^5gS\u000e\fG/[8ogR)1-a\u0017\u0002`!9\u0011QLA+\u0001\u0004y\u0014a\u00018po\"A\u0011\u0011MA+\u0001\u0004\t\u0019'A\u0007o_RLg-[2bi&|gn\u001d\t\u0006\u0003K\nyG\t\b\u0005\u0003O\nYGD\u0002&\u0003SJ\u0011aC\u0005\u0004\u0003[R\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003c\n\u0019HA\u0002TKFT1!!\u001c\u000b\u0011\u001d\t9\b\u0001C\u0005\u0003s\nAb\u00195b]\u001e,g*^7cKJ$2aPA>\u0011\u001d\ti\"!\u001eA\u0002\t:q!a \u0001\u0011\u0003\t\t)A\rDQ\u0006tw-\u001a(pi&4\u0017nY1uS>t\u0007*\u00198eY\u0016\u0014\bc\u0001=\u0002\u0004\u001a9\u0011Q\u0011\u0001\t\u0002\u0005\u001d%!G\"iC:<WMT8uS\u001aL7-\u0019;j_:D\u0015M\u001c3mKJ\u001cR!a!\t\u0003\u0013\u0003B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f#\u0011!\u0003>p_.,W\r]3s\u0013\u0011\t\u0019*!$\u0003/isu\u000eZ3DQ&dGm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014\bbB+\u0002\u0004\u0012\u0005\u0011q\u0013\u000b\u0003\u0003\u0003C\u0011\"a'\u0002\u0004\n\u0007I\u0011I\u0011\u0002\tA\fG\u000f\u001b\u0005\t\u0003?\u000b\u0019\t)A\u0005E\u0005)\u0001/\u0019;iA!A\u00111UAB\t\u0003\n\t!A\tiC:$G.Z\"iS2$7\t[1oO\u0016<q!a*\u0001\u0011\u0003\tI+\u0001\u000b[WN#\u0018\r^3DQ\u0006tw-\u001a%b]\u0012dWM\u001d\t\u0004q\u0006-faBAW\u0001!\u0005\u0011q\u0016\u0002\u00155.\u001cF/\u0019;f\u0007\"\fgnZ3IC:$G.\u001a:\u0014\u000b\u0005-\u0006\"!-\u0011\t\u0005-\u00151W\u0005\u0005\u0003k\u000biI\u0001\nTi\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014\bbB+\u0002,\u0012\u0005\u0011\u0011\u0018\u000b\u0003\u0003SC\u0011\"!\b\u0002,\n\u0007I\u0011I\u0011\t\u0011\u0005}\u00161\u0016Q\u0001\n\t\nQA\\1nK\u0002B\u0001\"a1\u0002,\u0012\u0005\u0013\u0011A\u0001\u0019C\u001a$XM]%oSRL\u0017\r\\5{S:<7+Z:tS>tw!CAd\u0005\u0005\u0005\t\u0012AAe\u0003\u0001R6NT8eK\u000eC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\u001c'jgR,g.\u001a:\u0011\u0007]\nYM\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAg'\r\tY\r\u0003\u0005\b+\u0006-G\u0011AAi)\t\tI\r\u0003\u0006\u0002V\u0006-\u0017\u0013!C\u0001\u0003/\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAAmU\ry\u00141\\\u0016\u0003\u0003;\u0004B!a8\u0002j6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u001d\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002l\u0006\u0005(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011q^Af#\u0003%\t!!=\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\t\u0019PK\u0002H\u00037\u0004")
public class ZkNodeChangeNotificationListener
implements Logging {
    private volatile ZkNodeChangeNotificationListener$ChangeNotificationHandler$ ChangeNotificationHandler$module;
    private volatile ZkNodeChangeNotificationListener$ZkStateChangeHandler$ ZkStateChangeHandler$module;
    private final KafkaZkClient zkClient;
    private final String kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot;
    private final String seqNodePrefix;
    private final NotificationHandler notificationHandler;
    private final long changeExpirationMs;
    private final Time time;
    private long lastExecutedChange;
    private final LinkedBlockingQueue<ChangeNotification> kafka$common$ZkNodeChangeNotificationListener$$queue;
    private final ChangeEventProcessThread thread;
    private final AtomicBoolean isClosed;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$6() {
        return ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6();
    }

    public static long $lessinit$greater$default$5() {
        return ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkNodeChangeNotificationListener$ChangeNotificationHandler$ ChangeNotificationHandler() {
        if (this.ChangeNotificationHandler$module == null) {
            this.ChangeNotificationHandler$lzycompute$1();
        }
        return this.ChangeNotificationHandler$module;
    }

    public ZkNodeChangeNotificationListener$ZkStateChangeHandler$ ZkStateChangeHandler() {
        if (this.ZkStateChangeHandler$module == null) {
            this.ZkStateChangeHandler$lzycompute$1();
        }
        return this.ZkStateChangeHandler$module;
    }

    private Logger logger$lzycompute() {
        ZkNodeChangeNotificationListener zkNodeChangeNotificationListener = this;
        synchronized (zkNodeChangeNotificationListener) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public String kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot() {
        return this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot;
    }

    private String seqNodePrefix() {
        return this.seqNodePrefix;
    }

    private NotificationHandler notificationHandler() {
        return this.notificationHandler;
    }

    private long changeExpirationMs() {
        return this.changeExpirationMs;
    }

    private Time time() {
        return this.time;
    }

    private long lastExecutedChange() {
        return this.lastExecutedChange;
    }

    private void lastExecutedChange_$eq(long x$1) {
        this.lastExecutedChange = x$1;
    }

    public LinkedBlockingQueue<ChangeNotification> kafka$common$ZkNodeChangeNotificationListener$$queue() {
        return this.kafka$common$ZkNodeChangeNotificationListener$$queue;
    }

    private ChangeEventProcessThread thread() {
        return this.thread;
    }

    private AtomicBoolean isClosed() {
        return this.isClosed;
    }

    public void init() {
        this.zkClient().registerStateChangeHandler(this.ZkStateChangeHandler());
        this.zkClient().registerZNodeChildChangeHandler(this.ChangeNotificationHandler());
        this.kafka$common$ZkNodeChangeNotificationListener$$addChangeNotification();
        this.thread().start();
    }

    public void close() {
        this.isClosed().set(true);
        this.zkClient().unregisterStateChangeHandler(this.ZkStateChangeHandler().name());
        this.zkClient().unregisterZNodeChildChangeHandler(this.ChangeNotificationHandler().path());
        this.kafka$common$ZkNodeChangeNotificationListener$$queue().clear();
        this.thread().shutdown();
    }

    public void kafka$common$ZkNodeChangeNotificationListener$$processNotifications() {
        try {
            Seq notifications = (Seq)this.zkClient().getChildren(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).sorted(Ordering$String$.MODULE$);
            if (notifications.nonEmpty()) {
                this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing notification(s) to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()})));
                long now = this.time().milliseconds();
                notifications.foreach((Function1<String, Object> & Serializable & scala.Serializable)notification -> {
                    ZkNodeChangeNotificationListener.$anonfun$processNotifications$2(this, notification);
                    return BoxedUnit.UNIT;
                });
                this.purgeObsoleteNotifications(now, notifications);
            }
        }
        catch (InterruptedException e) {
            if (!this.isClosed().get()) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while processing notification change for path = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()})), (Function0<Throwable>)(Function0<InterruptedException> & Serializable & scala.Serializable)() -> e);
            }
        }
        catch (Exception e) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while processing notification change for path = ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()})), (Function0<Throwable>)(Function0<Exception> & Serializable & scala.Serializable)() -> e);
        }
    }

    public void kafka$common$ZkNodeChangeNotificationListener$$addChangeNotification() {
        block0: {
            if (this.isClosed().get() || this.kafka$common$ZkNodeChangeNotificationListener$$queue().peek() != null) break block0;
            this.kafka$common$ZkNodeChangeNotificationListener$$queue().put(new ChangeNotification());
        }
    }

    private void purgeObsoleteNotifications(long now, Seq<String> notifications) {
        ((IterableLike)notifications.sorted(Ordering$String$.MODULE$)).foreach((Function1<String, Object> & Serializable & scala.Serializable)notification -> {
            Serializable serializable;
            String notificationNode = this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot() + "/" + notification;
            Tuple2<Option<byte[]>, Stat> tuple2 = this.zkClient().getDataAndStat(notificationNode);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option<byte[]> data = tuple2._1();
            Stat stat = tuple2._2();
            Tuple2<Option<byte[]>, Stat> tuple22 = new Tuple2<Option<byte[]>, Stat>(data, stat);
            Tuple2<Option<byte[]>, Stat> tuple23 = tuple22;
            Option<byte[]> data2 = tuple23._1();
            Stat stat2 = tuple23._2();
            if (data2.isDefined()) {
                if (now - stat2.getCtime() > this.changeExpirationMs()) {
                    this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Purging change notification ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{notificationNode})));
                    serializable = BoxesRunTime.boxToBoolean(this.zkClient().deletePath(notificationNode));
                } else {
                    serializable = BoxedUnit.UNIT;
                }
            } else {
                serializable = BoxedUnit.UNIT;
            }
            return serializable;
        });
    }

    private long changeNumber(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(name.substring(this.seqNodePrefix().length()))).toLong();
    }

    private final void ChangeNotificationHandler$lzycompute$1() {
        ZkNodeChangeNotificationListener zkNodeChangeNotificationListener = this;
        synchronized (zkNodeChangeNotificationListener) {
            if (this.ChangeNotificationHandler$module == null) {
                this.ChangeNotificationHandler$module = new ZkNodeChangeNotificationListener$ChangeNotificationHandler$(this);
            }
        }
    }

    private final void ZkStateChangeHandler$lzycompute$1() {
        ZkNodeChangeNotificationListener zkNodeChangeNotificationListener = this;
        synchronized (zkNodeChangeNotificationListener) {
            if (this.ZkStateChangeHandler$module == null) {
                this.ZkStateChangeHandler$module = new ZkNodeChangeNotificationListener$ZkStateChangeHandler$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processNotifications$2(ZkNodeChangeNotificationListener $this, String notification) {
        block5: {
            Option<byte[]> data;
            Option<byte[]> data2;
            long changeId = $this.changeNumber(notification);
            if (changeId <= $this.lastExecutedChange()) break block5;
            String changeZnode = $this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot() + "/" + notification;
            Tuple2<Option<byte[]>, Stat> tuple2 = $this.zkClient().getDataAndStat(changeZnode);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option<byte[]> option = data2 = tuple2._1();
            Option<byte[]> option2 = data = option;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                byte[] d = (byte[])some.value();
                $this.notificationHandler().processNotification(d);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option2)) {
                $this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read null data from ", " when processing notification ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{changeZnode, notification})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
            $this.lastExecutedChange_$eq(changeId);
        }
    }

    public ZkNodeChangeNotificationListener(KafkaZkClient zkClient, String seqNodeRoot, String seqNodePrefix, NotificationHandler notificationHandler, long changeExpirationMs, Time time) {
        this.zkClient = zkClient;
        this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot = seqNodeRoot;
        this.seqNodePrefix = seqNodePrefix;
        this.notificationHandler = notificationHandler;
        this.changeExpirationMs = changeExpirationMs;
        this.time = time;
        Logging.$init$(this);
        this.lastExecutedChange = -1L;
        this.kafka$common$ZkNodeChangeNotificationListener$$queue = new LinkedBlockingQueue();
        this.thread = new ChangeEventProcessThread(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-event-process-thread"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{seqNodeRoot})));
        this.isClosed = new AtomicBoolean(false);
    }

    public class ChangeEventProcessThread
    extends ShutdownableThread {
        @Override
        public void doWork() {
            this.kafka$common$ZkNodeChangeNotificationListener$ChangeEventProcessThread$$$outer().kafka$common$ZkNodeChangeNotificationListener$$queue().take().process();
        }

        public /* synthetic */ ZkNodeChangeNotificationListener kafka$common$ZkNodeChangeNotificationListener$ChangeEventProcessThread$$$outer() {
            return ZkNodeChangeNotificationListener.this;
        }

        public ChangeEventProcessThread(String name) {
            if (ZkNodeChangeNotificationListener.this == null) {
                throw null;
            }
            super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public class ChangeNotification {
        public void process() {
            this.kafka$common$ZkNodeChangeNotificationListener$ChangeNotification$$$outer().kafka$common$ZkNodeChangeNotificationListener$$processNotifications();
        }

        public /* synthetic */ ZkNodeChangeNotificationListener kafka$common$ZkNodeChangeNotificationListener$ChangeNotification$$$outer() {
            return ZkNodeChangeNotificationListener.this;
        }

        public ChangeNotification() {
            if (ZkNodeChangeNotificationListener.this == null) {
                throw null;
            }
        }
    }
}

