/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Cluster;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherThread;
import kafka.consumer.PartitionTopicInfo;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndInitialOffset;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0001\u001d\u0011acQ8ogVlWM\u001d$fi\u000eDWM]'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t\u0001bY8ogVlWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0004tKJ4XM]\u0005\u0003\u001b)\u0011a#\u00112tiJ\f7\r\u001e$fi\u000eDWM]'b]\u0006<WM\u001d\u0005\t\u001f\u0001\u0011)\u0019!C\u0005!\u0005\u00012m\u001c8tk6,'/\u00133TiJLgnZ\u000b\u0002#A\u0011!c\u0007\b\u0003'e\u0001\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011A$\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i9\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\t\u0002#\r|gn];nKJLEm\u0015;sS:<\u0007\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0003#\u0003\u0019\u0019wN\u001c4jOV\t1\u0005\u0005\u0002%K5\t!!\u0003\u0002'\u0005\tq1i\u001c8tk6,'oQ8oM&<\u0007\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u000f\r|gNZ5hA!A!\u0006\u0001BC\u0002\u0013%1&A\u0004{WV#\u0018\u000e\\:\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R!a\f\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Er#a\u0002.l+RLGn\u001d\u0005\tg\u0001\u0011\t\u0011)A\u0005Y\u0005A!p[+uS2\u001c\b\u0005C\u00036\u0001\u0011\u0005a'\u0001\u0004=S:LGO\u0010\u000b\u0005oaJ$\b\u0005\u0002%\u0001!)q\u0002\u000ea\u0001#!)\u0011\u0005\u000ea\u0001G!)!\u0006\u000ea\u0001Y!9A\b\u0001a\u0001\n\u0013i\u0014\u0001\u00049beRLG/[8o\u001b\u0006\u0004X#\u0001 \u0011\t}\"e)U\u0007\u0002\u0001*\u0011\u0011IQ\u0001\nS6lW\u000f^1cY\u0016T!aQ\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002F\u0001\n\u0019Q*\u00199\u0011\u0005\u001d{U\"\u0001%\u000b\u0005%S\u0015AB2p[6|gN\u0003\u0002\u0006\u0017*\u0011A*T\u0001\u0007CB\f7\r[3\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001\u0006J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005\u0011\u0012\u0016BA*\u0003\u0005I\u0001\u0016M\u001d;ji&|g\u000eV8qS\u000eLeNZ8\t\u000fU\u0003\u0001\u0019!C\u0005-\u0006\u0001\u0002/\u0019:uSRLwN\\'ba~#S-\u001d\u000b\u0003/n\u0003\"\u0001W-\u000e\u0003]I!AW\f\u0003\tUs\u0017\u000e\u001e\u0005\b9R\u000b\t\u00111\u0001?\u0003\rAH%\r\u0005\u0007=\u0002\u0001\u000b\u0015\u0002 \u0002\u001bA\f'\u000f^5uS>tW*\u00199!\u0011\u001d\u0001\u0007A1A\u0005\n\u0005\fAC\\8MK\u0006$WM\u001d)beRLG/[8o'\u0016$X#\u00012\u0011\u0007\r4g)D\u0001e\u0015\t)')A\u0004nkR\f'\r\\3\n\u0005\u001d$'a\u0002%bg\"\u001cV\r\u001e\u0005\u0007S\u0002\u0001\u000b\u0011\u00022\u0002+9|G*Z1eKJ\u0004\u0016M\u001d;ji&|gnU3uA!91\u000e\u0001b\u0001\n\u0013a\u0017\u0001\u00027pG.,\u0012!\u001c\t\u0003]^l\u0011a\u001c\u0006\u0003aF\fQ\u0001\\8dWNT!A]:\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002uk\u0006!Q\u000f^5m\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_8\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019Q\b\u0001)A\u0005[\u0006)An\\2lA!9A\u0010\u0001b\u0001\n\u0013i\u0018\u0001B2p]\u0012,\u0012A \t\u0003]~L1!!\u0001p\u0005%\u0019uN\u001c3ji&|g\u000eC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002@\u0002\u000b\r|g\u000e\u001a\u0011\t\u0013\u0005%\u0001\u00011A\u0005\n\u0005-\u0011A\u00057fC\u0012,'OR5oI\u0016\u0014H\u000b\u001b:fC\u0012,\"!!\u0004\u0011\u00075\ny!C\u0002\u0002\u00129\u0012!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\"I\u0011Q\u0003\u0001A\u0002\u0013%\u0011qC\u0001\u0017Y\u0016\fG-\u001a:GS:$WM\u001d+ie\u0016\fGm\u0018\u0013fcR\u0019q+!\u0007\t\u0013q\u000b\u0019\"!AA\u0002\u00055\u0001\u0002CA\u000f\u0001\u0001\u0006K!!\u0004\u0002'1,\u0017\rZ3s\r&tG-\u001a:UQJ,\u0017\r\u001a\u0011\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0012!D2peJ,G.\u0019;j_:LE-\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,E\fa!\u0019;p[&\u001c\u0017\u0002BA\u0018\u0003S\u0011Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\b\u0002CA\u001a\u0001\u0001\u0006I!!\n\u0002\u001d\r|'O]3mCRLwN\\%eA\u00191\u0011q\u0007\u0001\u0005\u0003s\u0011!\u0003T3bI\u0016\u0014h)\u001b8eKJ$\u0006N]3bIN!\u0011QGA\u0007\u00111\ti$!\u000e\u0003\u0002\u0003\u0006I!EA \u0003\u0011q\u0017-\\3\n\t\u0005u\u0012q\u0002\u0005\bk\u0005UB\u0011AA\")\u0011\t)%!\u0013\u0011\t\u0005\u001d\u0013QG\u0007\u0002\u0001!9\u0011QHA!\u0001\u0004\t\u0002\u0002CA'\u0003k!\t%a\u0014\u0002\r\u0011|wk\u001c:l)\u00059\u0006bBA*\u0001\u0011\u0005\u0013QK\u0001\u0014GJ,\u0017\r^3GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u000b\u0007\u0003/\ni&a\u001a\u0011\u0007%\tI&C\u0002\u0002\\)\u0011Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\r\u0003\u0005\u0002`\u0005E\u0003\u0019AA1\u0003%1W\r^2iKJLE\rE\u0002Y\u0003GJ1!!\u001a\u0018\u0005\rIe\u000e\u001e\u0005\t\u0003S\n\t\u00061\u0001\u0002l\u0005a1o\\;sG\u0016\u0014%o\\6feB!\u0011QNA:\u001b\t\tyGC\u0002\u0002r\u0011\tqa\u00197vgR,'/\u0003\u0003\u0002v\u0005=$A\u0004\"s_.,'/\u00128e!>Lg\u000e\u001e\u0005\b\u0003s\u0002A\u0011AA>\u0003A\u0019H/\u0019:u\u0007>tg.Z2uS>t7\u000fF\u0003X\u0003{\n\u0019\n\u0003\u0005\u0002\u0000\u0005]\u0004\u0019AAA\u0003)!x\u000e]5d\u0013:4wn\u001d\t\u0006\u0003\u0007\u000bi)\u0015\b\u0005\u0003\u000b\u000bIID\u0002\u0015\u0003\u000fK\u0011\u0001G\u0005\u0004\u0003\u0017;\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\u000b\tJ\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tYi\u0006\u0005\t\u0003c\n9\b1\u0001\u0002\u0016B!\u0011QNAL\u0013\u0011\tI*a\u001c\u0003\u000f\rcWo\u001d;fe\"9\u0011Q\u0014\u0001\u0005\u0002\u0005=\u0013aD:u_B\u001cuN\u001c8fGRLwN\\:\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\u00061\u0012\r\u001a3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5FeJ|'\u000fF\u0002X\u0003KC\u0001\"a*\u0002 \u0002\u0007\u0011\u0011V\u0001\u000ea\u0006\u0014H/\u001b;j_:d\u0015n\u001d;\u0011\u000b\u0005\r\u0015Q\u0012$)\u000f\u0001\ti+a-\u00028B\u0019\u0001,a,\n\u0007\u0005EvC\u0001\u0006eKB\u0014XmY1uK\u0012\f#!!.\u0002\u000fRC\u0017n\u001d\u0011dY\u0006\u001c8\u000f\t5bg\u0002\u0012W-\u001a8!I\u0016\u0004(/Z2bi\u0016$\u0007%\u00198eA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012\u0004\u0013N\u001c\u0011bA\u0019,H/\u001e:fAI,G.Z1tK:\n#!!/\u0002\u0011Ar\u0013'\r\u00181]A\u0002")
public class ConsumerFetcherManager
extends AbstractFetcherManager {
    private final String consumerIdString;
    private final ConsumerConfig kafka$consumer$ConsumerFetcherManager$$config;
    private final ZkUtils kafka$consumer$ConsumerFetcherManager$$zkUtils;
    private Map<TopicPartition, PartitionTopicInfo> kafka$consumer$ConsumerFetcherManager$$partitionMap;
    private final HashSet<TopicPartition> kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet;
    private final ReentrantLock kafka$consumer$ConsumerFetcherManager$$lock;
    private final Condition kafka$consumer$ConsumerFetcherManager$$cond;
    private ShutdownableThread leaderFinderThread;
    private final AtomicInteger kafka$consumer$ConsumerFetcherManager$$correlationId;

    private String consumerIdString() {
        return this.consumerIdString;
    }

    public ConsumerConfig kafka$consumer$ConsumerFetcherManager$$config() {
        return this.kafka$consumer$ConsumerFetcherManager$$config;
    }

    public ZkUtils kafka$consumer$ConsumerFetcherManager$$zkUtils() {
        return this.kafka$consumer$ConsumerFetcherManager$$zkUtils;
    }

    public Map<TopicPartition, PartitionTopicInfo> kafka$consumer$ConsumerFetcherManager$$partitionMap() {
        return this.kafka$consumer$ConsumerFetcherManager$$partitionMap;
    }

    private void kafka$consumer$ConsumerFetcherManager$$partitionMap_$eq(Map<TopicPartition, PartitionTopicInfo> x$1) {
        this.kafka$consumer$ConsumerFetcherManager$$partitionMap = x$1;
    }

    public HashSet<TopicPartition> kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet() {
        return this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet;
    }

    public ReentrantLock kafka$consumer$ConsumerFetcherManager$$lock() {
        return this.kafka$consumer$ConsumerFetcherManager$$lock;
    }

    public Condition kafka$consumer$ConsumerFetcherManager$$cond() {
        return this.kafka$consumer$ConsumerFetcherManager$$cond;
    }

    private ShutdownableThread leaderFinderThread() {
        return this.leaderFinderThread;
    }

    private void leaderFinderThread_$eq(ShutdownableThread x$1) {
        this.leaderFinderThread = x$1;
    }

    public AtomicInteger kafka$consumer$ConsumerFetcherManager$$correlationId() {
        return this.kafka$consumer$ConsumerFetcherManager$$correlationId;
    }

    @Override
    public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
        return new ConsumerFetcherThread(this.consumerIdString(), fetcherId, this.kafka$consumer$ConsumerFetcherManager$$config(), sourceBroker, this.kafka$consumer$ConsumerFetcherManager$$partitionMap(), this);
    }

    public void startConnections(Iterable<PartitionTopicInfo> topicInfos, Cluster cluster) {
        this.leaderFinderThread_$eq(new LeaderFinderThread(this.consumerIdString() + "-leader-finder-thread"));
        this.leaderFinderThread().start();
        CoreUtils$.MODULE$.inLock(this.kafka$consumer$ConsumerFetcherManager$$lock(), (JFunction0$mcV$sp & scala.Serializable)() -> {
            this.kafka$consumer$ConsumerFetcherManager$$partitionMap_$eq(((TraversableOnce)topicInfos.map((Function1<PartitionTopicInfo, Tuple2> & Serializable & scala.Serializable)tpi -> new Tuple2<TopicPartition, PartitionTopicInfo>(new TopicPartition(tpi.topic(), tpi.partitionId()), (PartitionTopicInfo)tpi), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().$plus$plus$eq(topicInfos.map((Function1<PartitionTopicInfo, TopicPartition> & Serializable & scala.Serializable)tpi -> new TopicPartition(tpi.topic(), tpi.partitionId()), Iterable$.MODULE$.canBuildFrom()));
            this.kafka$consumer$ConsumerFetcherManager$$cond().signalAll();
        });
    }

    public void stopConnections() {
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "Stopping leader finder thread");
        if (this.leaderFinderThread() != null) {
            this.leaderFinderThread().shutdown();
            this.leaderFinderThread_$eq(null);
        }
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "Stopping all fetchers");
        this.closeAllFetchers();
        this.kafka$consumer$ConsumerFetcherManager$$partitionMap_$eq(null);
        this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().clear();
        this.info((Function0<String> & Serializable & scala.Serializable)() -> "All connections stopped");
    }

    public void addPartitionsWithError(Iterable<TopicPartition> partitionList) {
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("adding partitions with error %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partitionList})));
        CoreUtils$.MODULE$.inLock(this.kafka$consumer$ConsumerFetcherManager$$lock(), (JFunction0$mcV$sp & scala.Serializable)() -> {
            block0: {
                if (this.kafka$consumer$ConsumerFetcherManager$$partitionMap() == null) break block0;
                this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().$plus$plus$eq(partitionList);
                this.kafka$consumer$ConsumerFetcherManager$$cond().signalAll();
            }
        });
    }

    public ConsumerFetcherManager(String consumerIdString, ConsumerConfig config, ZkUtils zkUtils) {
        this.consumerIdString = consumerIdString;
        this.kafka$consumer$ConsumerFetcherManager$$config = config;
        this.kafka$consumer$ConsumerFetcherManager$$zkUtils = zkUtils;
        super(new StringOps(Predef$.MODULE$.augmentString("ConsumerFetcherManager-%d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(Time.SYSTEM.milliseconds())})), config.clientId(), config.numConsumerFetchers());
        this.kafka$consumer$ConsumerFetcherManager$$partitionMap = null;
        this.kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet = new HashSet();
        this.kafka$consumer$ConsumerFetcherManager$$lock = new ReentrantLock();
        this.kafka$consumer$ConsumerFetcherManager$$cond = this.kafka$consumer$ConsumerFetcherManager$$lock().newCondition();
        this.leaderFinderThread = null;
        this.kafka$consumer$ConsumerFetcherManager$$correlationId = new AtomicInteger(0);
    }

    public class LeaderFinderThread
    extends ShutdownableThread {
        @Override
        public void doWork() {
            HashMap leaderForPartitionsMap = new HashMap();
            this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$lock().lock();
            try {
                try {
                    while (this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().isEmpty()) {
                        this.trace((Function0<String> & Serializable & scala.Serializable)() -> "No partition for leader election.");
                        this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$cond().await();
                    }
                    this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partitions without leader %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet()})));
                    Seq<BrokerEndPoint> brokers = ClientUtils$.MODULE$.getPlaintextBrokerEndPoints(this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$zkUtils());
                    Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata(((TraversableOnce)this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().map((Function1<TopicPartition, String> & Serializable & scala.Serializable)m -> m.topic(), HashSet$.MODULE$.canBuildFrom())).toSet(), brokers, this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$config().clientId(), this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$config().socketTimeoutMs(), this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$correlationId().getAndIncrement()).topicsMetadata();
                    if (this.isDebugEnabled()) {
                        topicsMetadata.foreach((Function1<TopicMetadata, Object> & Serializable & scala.Serializable)topicMetadata -> {
                            this.debug((Function0<String> & Serializable & scala.Serializable)() -> topicMetadata.toString());
                            return BoxedUnit.UNIT;
                        });
                    }
                    topicsMetadata.foreach((Function1<TopicMetadata, Object> & Serializable & scala.Serializable)tmd -> {
                        LeaderFinderThread.$anonfun$doWork$6(this, leaderForPartitionsMap, tmd);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    if (!this.isRunning()) {
                        throw t;
                    }
                    this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to find leader for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet()})), (Function0<Throwable> & Serializable & scala.Serializable)() -> t);
                }
            }
            finally {
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$lock().unlock();
            }
            try {
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().addFetcherForPartitions(leaderForPartitionsMap.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    BrokerEndPoint broker = (BrokerEndPoint)tuple2._2();
                    Tuple2<TopicPartition, BrokerAndInitialOffset> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), new BrokerAndInitialOffset(broker, ((PartitionTopicInfo)this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$partitionMap().apply(topicPartition)).getFetchOffset()));
                    return tuple22;
                }, HashMap$.MODULE$.canBuildFrom()));
            }
            catch (Throwable t) {
                if (!this.isRunning()) {
                    throw t;
                }
                this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to add leader for partitions %s; will retry")).format(Predef$.MODULE$.genericWrapArray(new Object[]{leaderForPartitionsMap.keySet().mkString(",")})), (Function0<Throwable> & Serializable & scala.Serializable)() -> t);
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$lock().lock();
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().$plus$plus$eq((TraversableOnce<TopicPartition>)((Object)leaderForPartitionsMap.keySet()));
                this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$lock().unlock();
            }
            this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().shutdownIdleFetcherThreads();
            Thread.sleep(this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$config().refreshLeaderBackoffMs());
        }

        public /* synthetic */ ConsumerFetcherManager kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer() {
            return ConsumerFetcherManager.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$6(LeaderFinderThread $this, HashMap leaderForPartitionsMap$1, TopicMetadata tmd) {
            String topic = tmd.topic();
            tmd.partitionsMetadata().foreach((Function1<PartitionMetadata, Object> & Serializable & scala.Serializable)pmd -> {
                Object object;
                TopicPartition topicAndPartition = new TopicPartition(topic, pmd.partitionId());
                if (pmd.leader().isDefined() && $this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().contains(topicAndPartition)) {
                    BrokerEndPoint leaderBroker = pmd.leader().get();
                    leaderForPartitionsMap$1.put(topicAndPartition, leaderBroker);
                    object = $this.kafka$consumer$ConsumerFetcherManager$LeaderFinderThread$$$outer().kafka$consumer$ConsumerFetcherManager$$noLeaderPartitionSet().$minus$eq((Object)topicAndPartition);
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
        }

        public LeaderFinderThread(String name) {
            if (ConsumerFetcherManager.this == null) {
                throw null;
            }
            super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        }
    }
}

