/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionAndReplica;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaRequestInfo;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001\u001d\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007N\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bC\u0001\f\u001d\u0013\ti\"AA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtDcA\u0011#GA\u0011a\u0003\u0001\u0005\u0006\u0007y\u0001\r!\u0006\u0005\u00065y\u0001\ra\u0007\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u000b\u0002OA\u0011a\u0003K\u0005\u0003S\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011\u0019Y\u0003\u0001)A\u0005O\u0005\u00112m\u001c8ue>dG.\u001a:D_:$X\r\u001f;!\u0011\u001di\u0003A1A\u0005\u00029\nAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012a\f\t\u0003\u0013AJ!!\r\u0006\u0003\u0007%sG\u000f\u0003\u00044\u0001\u0001\u0006IaL\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\t\u000fU\u0002!\u0019!C\u0001m\u00051B.Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti6\u000b\u0007/F\u00018!\u0011AThL \u000e\u0003eR!AO\u001e\u0002\u000f5,H/\u00192mK*\u0011AHC\u0001\u000bG>dG.Z2uS>t\u0017B\u0001 :\u0005\ri\u0015\r\u001d\t\u0005qu\u00025\n\u0005\u0002B\u00136\t!I\u0003\u0002D\t\u000611m\\7n_:T!!B#\u000b\u0005\u0019;\u0015AB1qC\u000eDWMC\u0001I\u0003\ry'oZ\u0005\u0003\u0015\n\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002M%:\u0011Q\nU\u0007\u0002\u001d*\u0011qJQ\u0001\te\u0016\fX/Z:ug&\u0011\u0011KT\u0001\u0014\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f^\u0005\u0003'R\u0013a\u0002U1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0002R\u001d\"1a\u000b\u0001Q\u0001\n]\nq\u0003\\3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgRl\u0015\r\u001d\u0011\t\u000fa\u0003!\u0019!C\u00013\u0006)2\u000f^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u\u001b\u0006\u0004X#\u0001.\u0011\tajtf\u0017\t\u00049\u0012<gBA/c\u001d\tq\u0016-D\u0001`\u0015\t\u0001g!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u00111MC\u0001\ba\u0006\u001c7.Y4f\u0013\t)gMA\u0002TKFT!a\u0019\u0006\u0011\u0005YA\u0017BA5\u0003\u0005Y\u0019Fo\u001c9SKBd\u0017nY1SKF,Xm\u001d;J]\u001a|\u0007BB6\u0001A\u0003%!,\u0001\fti>\u0004(+\u001a9mS\u000e\f'+Z9vKN$X*\u00199!\u0011\u001di\u0007A1A\u0005\u00029\fa$\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHO\u0011:pW\u0016\u00148+\u001a;\u0016\u0003=\u00042\u0001\u000f90\u0013\t\t\u0018HA\u0002TKRDaa\u001d\u0001!\u0002\u0013y\u0017aH;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\"s_.,'oU3uA!9Q\u000f\u0001b\u0001\n\u00031\u0018!J;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e)beRLG/[8o\u0013:4w.T1q+\u00059\b\u0003\u0002\u001d>\u0001b\u0004\"!\u001f?\u000f\u00055S\u0018BA>O\u0003U)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgRL!aU?\u000b\u0005mt\u0005BB@\u0001A\u0003%q/\u0001\u0014va\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;QCJ$\u0018\u000e^5p]&sgm\\'ba\u0002Bq!a\u0001\u0001\t\u0003\t)!\u0001\u0005oK^\u0014\u0015\r^2i)\t\t9\u0001E\u0002\n\u0003\u0013I1!a\u0003\u000b\u0005\u0011)f.\u001b;\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0006\u0005)1\r\\3be\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011\u0001I1eI2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;G_J\u0014%o\\6feN$B\"a\u0002\u0002\u0018\u0005u\u0011\u0011EA\u0016\u0003_A\u0001\"!\u0007\u0002\u0012\u0001\u0007\u00111D\u0001\nEJ|7.\u001a:JIN\u00042\u0001\u001830\u0011\u001d\ty\"!\u0005A\u0002\u0001\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002$\u0005E\u0001\u0019AA\u0013\u0003maW-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQB\u0019a#a\n\n\u0007\u0005%\"AA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\t\u0003[\t\t\u00021\u0001\u0002\u001c\u0005A!/\u001a9mS\u000e\f7\u000f\u0003\u0005\u00022\u0005E\u0001\u0019AA\u001a\u0003\u0015I7OT3x!\rI\u0011QG\u0005\u0004\u0003oQ!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003w\u0001A\u0011AA\u001f\u0003}\tG\rZ*u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgR4uN\u001d\"s_.,'o\u001d\u000b\u000b\u0003\u000f\ty$!\u0011\u0002D\u0005\u001d\u0003\u0002CA\r\u0003s\u0001\r!a\u0007\t\u000f\u0005}\u0011\u0011\ba\u0001\u0001\"A\u0011QIA\u001d\u0001\u0004\t\u0019$A\beK2,G/\u001a)beRLG/[8o\u0011!\tI%!\u000fA\u0002\u0005-\u0013\u0001C2bY2\u0014\u0017mY6\u0011\u0011%\ti%!\u00150\u0003\u000fI1!a\u0014\u000b\u0005%1UO\\2uS>t'\u0007E\u0002N\u0003'J1!!\u0016O\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX\rC\u0004\u0002Z\u0001!\t!a\u0017\u0002E\u0005$G-\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHOR8s\u0005J|7.\u001a:t)\u0019\t9!!\u0018\u0002`!A\u0011\u0011DA,\u0001\u0004\tY\u0002\u0003\u0005\u0002b\u0005]\u0003\u0019AA2\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0003K\n9\u0007Q\u0007\u0002w%\u0011\u0011o\u000f\u0005\b\u0003W\u0002A\u0011AA7\u0003U\u0019XM\u001c3SKF,Xm\u001d;t)>\u0014%o\\6feN$B!a\u0002\u0002p!9\u0011\u0011OA5\u0001\u0004y\u0013aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195")
public class ControllerBrokerRequestBatch
implements Logging {
    private final KafkaController controller;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final int controllerId;
    private final Map<Object, Map<TopicPartition, LeaderAndIsrRequest.PartitionState>> leaderAndIsrRequestMap;
    private final Map<Object, Seq<StopReplicaRequestInfo>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final Map<TopicPartition, UpdateMetadataRequest.PartitionState> updateMetadataRequestPartitionInfoMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ControllerBrokerRequestBatch controllerBrokerRequestBatch = this;
        synchronized (controllerBrokerRequestBatch) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public Map<Object, Map<TopicPartition, LeaderAndIsrRequest.PartitionState>> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public Map<Object, Seq<StopReplicaRequestInfo>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public Map<TopicPartition, UpdateMetadataRequest.PartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException("Controller to broker state change requests batch is not empty while creating " + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a new one. Some LeaderAndIsr state changes ", " might be lost "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.leaderAndIsrRequestMap()})));
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException("Controller to broker state change requests batch is not empty while creating a " + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new one. Some StopReplica state changes ", " might be lost "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.stopReplicaRequestMap()})));
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException("Controller to broker state change requests batch is not empty while creating a " + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new one. Some UpdateMetadata state changes to brokers ", " with partition info "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.updateMetadataRequestBrokerSet()})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updateMetadataRequestPartitionInfoMap might be lost "})).s(Nil$.MODULE$));
        }
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, Seq<Object> replicas, boolean isNew) {
        ((IterableLike)brokerIds.filter((JFunction1$mcZI$sp & scala.Serializable)x$3 -> x$3 >= 0)).foreach((Function1<Object, Option> & Serializable & scala.Serializable)brokerId -> ControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, topicPartition, leaderIsrAndControllerEpoch, replicas, isNew, BoxesRunTime.unboxToInt(brokerId)));
        this.addUpdateMetadataRequestForBrokers(this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition, Function2<AbstractResponse, Object, BoxedUnit> callback) {
        ((IterableLike)brokerIds.filter((JFunction1$mcZI$sp & scala.Serializable)b -> b >= 0)).foreach((JFunction1$mcVI$sp & scala.Serializable)brokerId -> {
            this.stopReplicaRequestMap().getOrElseUpdate(BoxesRunTime.boxToInteger(brokerId), (Function0<Seq> & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
            Seq v = (Seq)this.stopReplicaRequestMap().apply(BoxesRunTime.boxToInteger(brokerId));
            this.stopReplicaRequestMap().update(BoxesRunTime.boxToInteger(brokerId), v.$colon$plus(new StopReplicaRequestInfo(new PartitionAndReplica(topicPartition, brokerId), deletePartition, (Function1<AbstractResponse, BoxedUnit>)(Function1<AbstractResponse, Object> & Serializable & scala.Serializable)r -> {
                callback.apply(r, BoxesRunTime.boxToInteger(brokerId));
                return BoxedUnit.UNIT;
            }), Seq$.MODULE$.canBuildFrom()));
        });
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        Set givenPartitions = partitions.isEmpty() ? this.controllerContext().partitionLeadershipInfo().keySet() : partitions;
        Set filteredPartitions = this.controller.topicDeletionManager().partitionsToBeDeleted().isEmpty() ? givenPartitions : (Set)givenPartitions.$minus$minus(this.controller.topicDeletionManager().partitionsToBeDeleted());
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((JFunction1$mcZI$sp & scala.Serializable)x$6 -> x$6 >= 0));
        filteredPartitions.foreach((Function1<TopicPartition, Object> & Serializable & scala.Serializable)partition -> {
            this.updateMetadataRequestPartitionInfo$1(partition, false);
            return BoxedUnit.UNIT;
        });
        this.controller.topicDeletionManager().partitionsToBeDeleted().foreach((Function1<TopicPartition, Object> & Serializable & scala.Serializable)partition -> {
            this.updateMetadataRequestPartitionInfo$1(partition, true);
            return BoxedUnit.UNIT;
        });
    }

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            short leaderAndIsrRequestVersion = this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? (short)1 : 0;
            this.leaderAndIsrRequestMap().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
                ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$1(this, controllerEpoch, stateChangeLog, leaderAndIsrRequestVersion, x0$1);
                return BoxedUnit.UNIT;
            });
            this.leaderAndIsrRequestMap().clear();
            this.updateMetadataRequestPartitionInfoMap().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> {
                ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$8(this, stateChangeLog, x0$3);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Map partitionStates = Predef$.MODULE$.Map().empty().$plus$plus(this.updateMetadataRequestPartitionInfoMap());
            short updateMetadataRequestVersion = this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? (short)4 : (this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_2_IV0$.MODULE$) ? (short)3 : (this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV1$.MODULE$) ? (short)2 : (this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? (short)1 : 0)));
            Set liveBrokers = updateMetadataRequestVersion == 0 ? this.controllerContext().liveOrShuttingDownBrokers().map((Function1<Broker, UpdateMetadataRequest.Broker> & Serializable & scala.Serializable)broker -> {
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                ListenerName listenerName = ListenerName.forSecurityProtocol(securityProtocol);
                Node node = broker.node(listenerName);
                Seq endPoints = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint(node.host(), node.port(), securityProtocol, listenerName)}));
                return new UpdateMetadataRequest.Broker(broker.id(), JavaConverters$.MODULE$.seqAsJavaListConverter(endPoints).asJava(), (String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
            }, Set$.MODULE$.canBuildFrom()) : this.controllerContext().liveOrShuttingDownBrokers().map((Function1<Broker, UpdateMetadataRequest.Broker> & Serializable & scala.Serializable)broker -> {
                Seq endPoints = broker.endPoints().map((Function1<EndPoint, UpdateMetadataRequest.EndPoint> & Serializable & scala.Serializable)endPoint -> new UpdateMetadataRequest.EndPoint(endPoint.host(), endPoint.port(), endPoint.securityProtocol(), endPoint.listenerName()), Seq$.MODULE$.canBuildFrom());
                return new UpdateMetadataRequest.Broker(broker.id(), JavaConverters$.MODULE$.seqAsJavaListConverter(endPoints).asJava(), (String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
            }, Set$.MODULE$.canBuildFrom());
            UpdateMetadataRequest.Builder updateMetadataRequest = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion, this.controllerId(), controllerEpoch, JavaConverters$.MODULE$.mapAsJavaMapConverter(partitionStates).asJava(), JavaConverters$.MODULE$.setAsJavaSetConverter(liveBrokers).asJava());
            this.updateMetadataRequestBrokerSet().foreach((JFunction1$mcVI$sp & scala.Serializable)broker -> $this.controller.sendRequest(broker, ApiKeys.UPDATE_METADATA, updateMetadataRequest, null));
            this.updateMetadataRequestBrokerSet().clear();
            this.updateMetadataRequestPartitionInfoMap().clear();
            this.stopReplicaRequestMap().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$4 -> {
                ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$14(this, controllerEpoch, x0$4);
                return BoxedUnit.UNIT;
            });
            this.stopReplicaRequestMap().clear();
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> "Haven't been able to send leader and isr requests, current state of " + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the map is ", ". Exception message: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.leaderAndIsrRequestMap(), e})));
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Haven't been able to send metadata update requests to brokers ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.updateMetadataRequestBrokerSet()})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current state of the partition info is ", ". Exception message: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.updateMetadataRequestPartitionInfoMap(), e})));
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> "Haven't been able to send stop replica requests, current state of " + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the map is ", ". Exception message: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.stopReplicaRequestMap(), e})));
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$2(ControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, Seq replicas$1, boolean isNew$1, int brokerId) {
        Map result2 = (Map)$this.leaderAndIsrRequestMap().getOrElseUpdate(BoxesRunTime.boxToInteger(brokerId), (Function0<Map> & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        boolean alreadyNew = result2.get(topicPartition$1).exists((Function1<LeaderAndIsrRequest.PartitionState, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.isNew));
        return result2.put(topicPartition$1, new LeaderAndIsrRequest.PartitionState(leaderIsrAndControllerEpoch$1.controllerEpoch(), leaderIsrAndControllerEpoch$1.leaderAndIsr().leader(), leaderIsrAndControllerEpoch$1.leaderAndIsr().leaderEpoch(), JavaConverters$.MODULE$.seqAsJavaListConverter(leaderIsrAndControllerEpoch$1.leaderAndIsr().isr().map((Function1<Object, Integer> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1), List$.MODULE$.canBuildFrom())).asJava(), leaderIsrAndControllerEpoch$1.leaderAndIsr().zkVersion(), JavaConverters$.MODULE$.seqAsJavaListConverter(replicas$1.map((Function1<Object, Integer> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1), Seq$.MODULE$.canBuildFrom())).asJava(), isNew$1 || alreadyNew));
    }

    private final void updateMetadataRequestPartitionInfo$1(TopicPartition partition, boolean beingDeleted) {
        Some some;
        LeaderIsrAndControllerEpoch l;
        Option leaderIsrAndControllerEpochOpt = this.controllerContext().partitionLeadershipInfo().get(partition);
        Option option = leaderIsrAndControllerEpochOpt;
        if (option instanceof Some && (l = (LeaderIsrAndControllerEpoch)(some = (Some)option).value()) != null) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
            LeaderAndIsr leaderAndIsr = l.leaderAndIsr();
            int controllerEpoch = l.controllerEpoch();
            Seq replicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply(partition);
            Seq offlineReplicas = (Seq)replicas.filter((JFunction1$mcZI$sp & scala.Serializable)x$5 -> !this.controllerContext().isReplicaOnline(x$5, partition, this.controllerContext().isReplicaOnline$default$3()));
            if (beingDeleted) {
                LeaderAndIsr leaderDuringDelete = LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr());
                leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderDuringDelete, controllerEpoch);
            } else {
                leaderIsrAndControllerEpoch = l;
            }
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = leaderIsrAndControllerEpoch;
            UpdateMetadataRequest.PartitionState partitionStateInfo = new UpdateMetadataRequest.PartitionState(leaderIsrAndControllerEpoch2.controllerEpoch(), leaderIsrAndControllerEpoch2.leaderAndIsr().leader(), leaderIsrAndControllerEpoch2.leaderAndIsr().leaderEpoch(), JavaConverters$.MODULE$.seqAsJavaListConverter(leaderIsrAndControllerEpoch2.leaderAndIsr().isr().map((Function1<Object, Integer> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1), List$.MODULE$.canBuildFrom())).asJava(), leaderIsrAndControllerEpoch2.leaderAndIsr().zkVersion(), JavaConverters$.MODULE$.seqAsJavaListConverter(replicas.map((Function1<Object, Integer> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1), Seq$.MODULE$.canBuildFrom())).asJava(), JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicas.map((Function1<Object, Integer> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt(x$1), Seq$.MODULE$.canBuildFrom())).asJava());
            this.updateMetadataRequestPartitionInfoMap().put(partition, partitionStateInfo);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader not yet assigned for partition ", ". Skip sending UpdateMetadataRequest."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{partition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$2(StateChangeLogger stateChangeLog$1, int broker$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        LeaderAndIsrRequest.PartitionState state = (LeaderAndIsrRequest.PartitionState)tuple2._2();
        String typeOfRequest = broker$2 == state.basePartitionState.leader ? "become-leader" : "become-follower";
        stateChangeLog$1.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending ", " LeaderAndIsr request ", " to broker ", " for partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{typeOfRequest, state, BoxesRunTime.boxToInteger(broker$2), topicPartition})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$7(ControllerBrokerRequestBatch $this, int broker$2, AbstractResponse r) {
        $this.controller.eventManager().put(new KafkaController.LeaderAndIsrResponseReceived($this.controller, r, broker$2));
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$1(ControllerBrokerRequestBatch $this, int controllerEpoch$1, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int broker = tuple2._1$mcI$sp();
        Map leaderAndIsrPartitionStates = (Map)tuple2._2();
        leaderAndIsrPartitionStates.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
            ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$2(stateChangeLog$1, broker, x0$2);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set leaderIds = ((TraversableOnce)leaderAndIsrPartitionStates.map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger(((LeaderAndIsrRequest.PartitionState)x$7._2()).basePartitionState.leader), Iterable$.MODULE$.canBuildFrom())).toSet();
        Set leaders = ((SetLike)$this.controllerContext().liveOrShuttingDownBrokers().filter((Function1<Broker, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean(leaderIds.contains(BoxesRunTime.boxToInteger(b.id()))))).map((Function1<Broker, Node> & Serializable & scala.Serializable)x$8 -> x$8.node($this.controller.config().interBrokerListenerName()), Set$.MODULE$.canBuildFrom());
        LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = new LeaderAndIsrRequest.Builder(leaderAndIsrRequestVersion$1, $this.controllerId(), controllerEpoch$1, JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(leaderAndIsrPartitionStates).asJava(), JavaConverters$.MODULE$.setAsJavaSetConverter(leaders).asJava());
        $this.controller.sendRequest(broker, ApiKeys.LEADER_AND_ISR, leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1<AbstractResponse, Object> & Serializable & scala.Serializable)r -> {
            ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$7($this, broker, r);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$8(ControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)tuple2._2();
        stateChangeLog$1.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending UpdateMetadata request ", " to brokers ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{partitionState, $this.updateMetadataRequestBrokerSet()})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tp})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$sendRequestsToBrokers$21(StopReplicaRequestInfo r) {
        return !r.deletePartition() && r.callback() == null;
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$23(ControllerBrokerRequestBatch $this, int controllerEpoch$1, int broker$3, StopReplicaRequestInfo r) {
        StopReplicaRequest.Builder stopReplicaRequest = new StopReplicaRequest.Builder($this.controllerId(), controllerEpoch$1, r.deletePartition(), JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{r.replica().topicPartition()}))).asJava());
        $this.controller.sendRequest(broker$3, ApiKeys.STOP_REPLICA, stopReplicaRequest, r.callback());
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$14(ControllerBrokerRequestBatch $this, int controllerEpoch$1, Tuple2 x0$4) {
        Tuple2<Seq, Seq> tuple2;
        int broker;
        Tuple2 tuple22 = x0$4;
        if (tuple22 != null) {
            broker = tuple22._1$mcI$sp();
            Seq replicaInfoList = (Seq)tuple22._2();
            scala.collection.immutable.Set stopReplicaWithDelete = ((TraversableOnce)((TraversableLike)replicaInfoList.filter((Function1<StopReplicaRequestInfo, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(x$9.deletePartition()))).map((Function1<StopReplicaRequestInfo, PartitionAndReplica> & Serializable & scala.Serializable)x$10 -> x$10.replica(), Seq$.MODULE$.canBuildFrom())).toSet();
            scala.collection.immutable.Set stopReplicaWithoutDelete = ((TraversableOnce)((TraversableLike)replicaInfoList.filterNot((Function1<StopReplicaRequestInfo, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean(x$11.deletePartition()))).map((Function1<StopReplicaRequestInfo, PartitionAndReplica> & Serializable & scala.Serializable)x$12 -> x$12.replica(), Seq$.MODULE$.canBuildFrom())).toSet();
            $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The stop replica request (delete = true) sent to broker ", " is ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(broker), stopReplicaWithDelete.mkString(",")})));
            $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The stop replica request (delete = false) sent to broker ", " is ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(broker), stopReplicaWithoutDelete.mkString(",")})));
            Tuple2 tuple23 = replicaInfoList.partition((Function1<StopReplicaRequestInfo, Object> & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean(ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$21(r)));
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            Seq replicasToGroup = (Seq)tuple23._1();
            Seq replicasToNotGroup = (Seq)tuple23._2();
            tuple2 = new Tuple2<Seq, Seq>(replicasToGroup, replicasToNotGroup);
        } else {
            throw new MatchError(tuple22);
        }
        Tuple2<Seq, Seq> tuple24 = tuple2;
        Seq replicasToGroup = tuple24._1();
        Seq replicasToNotGroup = tuple24._2();
        StopReplicaRequest.Builder stopReplicaRequest = new StopReplicaRequest.Builder($this.controllerId(), controllerEpoch$1, false, JavaConverters$.MODULE$.setAsJavaSetConverter(((TraversableOnce)replicasToGroup.map((Function1<StopReplicaRequestInfo, TopicPartition> & Serializable & scala.Serializable)x$14 -> x$14.replica().topicPartition(), Seq$.MODULE$.canBuildFrom())).toSet()).asJava());
        $this.controller.sendRequest(broker, ApiKeys.STOP_REPLICA, stopReplicaRequest, $this.controller.sendRequest$default$4());
        replicasToNotGroup.foreach((Function1<StopReplicaRequestInfo, Object> & Serializable & scala.Serializable)r -> {
            ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$23($this, controllerEpoch$1, broker, r);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ControllerBrokerRequestBatch(KafkaController controller, StateChangeLogger stateChangeLogger) {
        this.controller = controller;
        this.stateChangeLogger = stateChangeLogger;
        Logging.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.leaderAndIsrRequestMap = Map$.MODULE$.empty();
        this.stopReplicaRequestMap = Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = scala.collection.mutable.Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = Map$.MODULE$.empty();
    }
}

