/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.regex.Pattern;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric$LongIsIntegral$;
import scala.runtime.BoxesRunTime;

public final class Log$ {
    public static Log$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String TimeIndexFileSuffix;
    private final String ProducerSnapshotFileSuffix;
    private final String TxnIndexFileSuffix;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String CleanShutdownFile;
    private final String DeleteDirSuffix;
    private final String FutureDirSuffix;
    private final Pattern DeleteDirPattern;
    private final Pattern FutureDirPattern;
    private final long UnknownLogStartOffset;

    static {
        new Log$();
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return this.TimeIndexFileSuffix;
    }

    public String ProducerSnapshotFileSuffix() {
        return this.ProducerSnapshotFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return this.TxnIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return this.FutureDirSuffix;
    }

    private Pattern DeleteDirPattern() {
        return this.DeleteDirPattern;
    }

    private Pattern FutureDirPattern() {
        return this.FutureDirPattern;
    }

    public long UnknownLogStartOffset() {
        return this.UnknownLogStartOffset;
    }

    public Log apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, LogDirFailureChannel logDirFailureChannel) {
        TopicPartition topicPartition = this.parseTopicPartitionName(dir);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxProducerIdExpirationMs);
        return new Log(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, topicPartition, producerStateManager, logDirFailureChannel);
    }

    public Time apply$default$7() {
        return Time.SYSTEM;
    }

    public String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public File logFile(File dir, long offset, String suffix) {
        return new File(dir, this.filenamePrefixFromOffset(offset) + this.LogFileSuffix() + suffix);
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffix(topicPartition, this.DeleteDirSuffix());
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return this.logDirNameWithSuffix(topicPartition, this.FutureDirSuffix());
    }

    private String logDirNameWithSuffix(TopicPartition topicPartition, String suffix) {
        String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.logDirName(topicPartition), uniqueId, suffix}));
    }

    public String logDirName(TopicPartition topicPartition) {
        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition.topic(), BoxesRunTime.boxToInteger(topicPartition.partition())}));
    }

    public File offsetIndexFile(File dir, long offset, String suffix) {
        return new File(dir, this.filenamePrefixFromOffset(offset) + this.IndexFileSuffix() + suffix);
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset, String suffix) {
        return new File(dir, this.filenamePrefixFromOffset(offset) + this.TimeIndexFileSuffix() + suffix);
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public File producerSnapshotFile(File dir, long offset) {
        return new File(dir, this.filenamePrefixFromOffset(offset) + this.ProducerSnapshotFileSuffix());
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return new File(dir, this.filenamePrefixFromOffset(offset) + this.TxnIndexFileSuffix() + suffix);
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public long offsetFromFile(File file) {
        String filename = file.getName();
        return new StringOps(Predef$.MODULE$.augmentString(filename.substring(0, filename.indexOf(46)))).toLong();
    }

    public long sizeInBytes(Iterable<LogSegment> segments) {
        return BoxesRunTime.unboxToLong(((TraversableOnce)segments.map((Function1<LogSegment, Object> & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong(x$23.size()), Iterable$.MODULE$.canBuildFrom())).sum(Numeric$LongIsIntegral$.MODULE$));
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        int n;
        if (dir == null) {
            throw new KafkaException("dir should not be null");
        }
        String dirName = dir.getName();
        if (dirName == null || dirName.isEmpty() || !new StringOps(Predef$.MODULE$.augmentString(dirName)).contains(BoxesRunTime.boxToCharacter('-'))) {
            throw Log$.exception$1(dir);
        }
        if (dirName.endsWith(this.DeleteDirSuffix()) && !this.DeleteDirPattern().matcher(dirName).matches() || dirName.endsWith(this.FutureDirSuffix()) && !this.FutureDirPattern().matcher(dirName).matches()) {
            throw Log$.exception$1(dir);
        }
        String name = dirName.endsWith(this.DeleteDirSuffix()) || dirName.endsWith(this.FutureDirSuffix()) ? dirName.substring(0, dirName.lastIndexOf(46)) : dirName;
        int index = name.lastIndexOf(45);
        String topic = name.substring(0, index);
        String partitionString = name.substring(index + 1);
        if (topic.isEmpty() || partitionString.isEmpty()) {
            throw Log$.exception$1(dir);
        }
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw Log$.exception$1(dir);
        }
        int partition = n;
        return new TopicPartition(topic, partition);
    }

    public boolean kafka$log$Log$$isIndexFile(File file) {
        String filename = file.getName();
        return filename.endsWith(this.IndexFileSuffix()) || filename.endsWith(this.TimeIndexFileSuffix()) || filename.endsWith(this.TxnIndexFileSuffix());
    }

    public boolean kafka$log$Log$$isLogFile(File file) {
        return file.getPath().endsWith(this.LogFileSuffix());
    }

    private static final KafkaException exception$1(File dir) {
        return new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found directory ", ", '", "' is not in the form of "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{dir.getCanonicalPath(), dir.getName()})) + "topic-partition or topic-partition.uniqueId-delete (if marked for deletion).\n" + "Kafka's log directories (and children) should only contain Kafka topic data.");
    }

    private Log$() {
        MODULE$ = this;
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.TimeIndexFileSuffix = ".timeindex";
        this.ProducerSnapshotFileSuffix = ".snapshot";
        this.TxnIndexFileSuffix = ".txnindex";
        this.DeletedFileSuffix = ".deleted";
        this.CleanedFileSuffix = ".cleaned";
        this.SwapFileSuffix = ".swap";
        this.CleanShutdownFile = ".kafka_cleanshutdown";
        this.DeleteDirSuffix = "-delete";
        this.FutureDirSuffix = "-future";
        this.DeleteDirPattern = Pattern.compile(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\\\S+)-(\\\\S+)\\\\.(\\\\S+)", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.DeleteDirSuffix()})));
        this.FutureDirPattern = Pattern.compile(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\\\S+)-(\\\\S+)\\\\.(\\\\S+)", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.FutureDirSuffix()})));
        this.UnknownLogStartOffset = -1L;
    }
}

