/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import kafka.log.OffsetMap;
import kafka.log.SkimpyOffsetMap$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001\u001d\u0011qbU6j[BLxJ\u001a4tKRl\u0015\r\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tIqJ\u001a4tKRl\u0015\r\u001d\u0005\t'\u0001\u0011)\u0019!C\u0001)\u00051Q.Z7pef,\u0012!\u0006\t\u0003\u0013YI!a\u0006\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u001diW-\\8ss\u0002B\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u000eQ\u0006\u001c\b.\u00117h_JLG\u000f[7\u0016\u0003u\u0001\"AH\u0013\u000f\u0005}\u0019\u0003C\u0001\u0011\u000b\u001b\u0005\t#B\u0001\u0012\u0007\u0003\u0019a$o\\8u}%\u0011AEC\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#AB*ue&twM\u0003\u0002%\u0015!A\u0011\u0006\u0001B\u0001B\u0003%Q$\u0001\biCND\u0017\t\\4pe&$\b.\u001c\u0011\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\ricf\f\t\u0003\u001f\u0001AQa\u0005\u0016A\u0002UAqa\u0007\u0016\u0011\u0002\u0003\u0007Q\u0004C\u00042\u0001\t\u0007I\u0011\u0002\u001a\u0002\u000b\tLH/Z:\u0016\u0003M\u0002\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u00079LwNC\u00019\u0003\u0011Q\u0017M^1\n\u0005i*$A\u0003\"zi\u0016\u0014UO\u001a4fe\"1A\b\u0001Q\u0001\nM\naAY=uKN\u0004\u0003b\u0002 \u0001\u0005\u0004%IaP\u0001\u0007I&<Wm\u001d;\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!aQ\u001c\u0002\u0011M,7-\u001e:jifL!!\u0012\"\u0003\u001b5+7o]1hK\u0012Kw-Z:u\u0011\u00199\u0005\u0001)A\u0005\u0001\u00069A-[4fgR\u0004\u0003bB%\u0001\u0005\u0004%I\u0001F\u0001\tQ\u0006\u001c\bnU5{K\"11\n\u0001Q\u0001\nU\t\u0011\u0002[1tQNK'0\u001a\u0011\t\u000f5\u0003!\u0019!C\u0005\u001d\u0006)\u0001.Y:icU\tq\nE\u0002\n!JK!!\u0015\u0006\u0003\u000b\u0005\u0013(/Y=\u0011\u0005%\u0019\u0016B\u0001+\u000b\u0005\u0011\u0011\u0015\u0010^3\t\rY\u0003\u0001\u0015!\u0003P\u0003\u0019A\u0017m\u001d52A!9\u0001\f\u0001b\u0001\n\u0013q\u0015!\u00025bg\"\u0014\u0004B\u0002.\u0001A\u0003%q*\u0001\u0004iCND'\u0007\t\u0005\b9\u0002\u0001\r\u0011\"\u0003\u0015\u0003\u001d)g\u000e\u001e:jKNDqA\u0018\u0001A\u0002\u0013%q,A\u0006f]R\u0014\u0018.Z:`I\u0015\fHC\u00011d!\tI\u0011-\u0003\u0002c\u0015\t!QK\\5u\u0011\u001d!W,!AA\u0002U\t1\u0001\u001f\u00132\u0011\u00191\u0007\u0001)Q\u0005+\u0005AQM\u001c;sS\u0016\u001c\b\u0005C\u0004i\u0001\u0001\u0007I\u0011B5\u0002\u000f1|wn[;qgV\t!\u000e\u0005\u0002\nW&\u0011AN\u0003\u0002\u0005\u0019>tw\rC\u0004o\u0001\u0001\u0007I\u0011B8\u0002\u00171|wn[;qg~#S-\u001d\u000b\u0003ABDq\u0001Z7\u0002\u0002\u0003\u0007!\u000e\u0003\u0004s\u0001\u0001\u0006KA[\u0001\tY>|7.\u001e9tA!9A\u000f\u0001a\u0001\n\u0013I\u0017A\u00029s_\n,7\u000fC\u0004w\u0001\u0001\u0007I\u0011B<\u0002\u0015A\u0014xNY3t?\u0012*\u0017\u000f\u0006\u0002aq\"9A-^A\u0001\u0002\u0004Q\u0007B\u0002>\u0001A\u0003&!.A\u0004qe>\u0014Wm\u001d\u0011\t\u000fq\u0004\u0001\u0019!C\u0005S\u0006QA.Y:u\u001f\u001a47/\u001a;\t\u000fy\u0004\u0001\u0019!C\u0005\u007f\u0006qA.Y:u\u001f\u001a47/\u001a;`I\u0015\fHc\u00011\u0002\u0002!9A-`A\u0001\u0002\u0004Q\u0007bBA\u0003\u0001\u0001\u0006KA[\u0001\fY\u0006\u001cHo\u00144gg\u0016$\b\u0005\u0003\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001\u0015\u00035\u0011\u0017\u0010^3t!\u0016\u0014XI\u001c;ss\"9\u0011Q\u0002\u0001!\u0002\u0013)\u0012A\u00042zi\u0016\u001c\b+\u001a:F]R\u0014\u0018\u0010\t\u0005\t\u0003#\u0001!\u0019!C\u0001)\u0005)1\u000f\\8ug\"9\u0011Q\u0003\u0001!\u0002\u0013)\u0012AB:m_R\u001c\b\u0005C\u0004\u0002\u001a\u0001!\t%a\u0007\u0002\u0007A,H\u000fF\u0003a\u0003;\t\t\u0003C\u0004\u0002 \u0005]\u0001\u0019A\u001a\u0002\u0007-,\u0017\u0010C\u0004\u0002$\u0005]\u0001\u0019\u00016\u0002\r=4gm]3u\u0011\u001d\t9\u0003\u0001C\u0005\u0003S\tq![:F[B$\u0018\u0010\u0006\u0003\u0002,\u0005E\u0002cA\u0005\u0002.%\u0019\u0011q\u0006\u0006\u0003\u000f\t{w\u000e\\3b]\"9\u00111GA\u0013\u0001\u0004)\u0012\u0001\u00039pg&$\u0018n\u001c8\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:\u0005\u0019q-\u001a;\u0015\u0007)\fY\u0004C\u0004\u0002 \u0005U\u0002\u0019A\u001a\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B\u0005)1\r\\3beR\t\u0001\r\u0003\u0004\u0002F\u0001!\t\u0005F\u0001\u0005g&TX\rC\u0004\u0002J\u0001!\t!a\u0013\u0002\u001b\r|G\u000e\\5tS>t'+\u0019;f+\t\ti\u0005E\u0002\n\u0003\u001fJ1!!\u0015\u000b\u0005\u0019!u.\u001e2mK\"1\u0011Q\u000b\u0001\u0005B%\fA\u0002\\1uKN$xJ\u001a4tKRDq!!\u0017\u0001\t\u0003\nY&\u0001\nva\u0012\fG/\u001a'bi\u0016\u001cHo\u00144gg\u0016$Hc\u00011\u0002^!9\u00111EA,\u0001\u0004Q\u0007bBA1\u0001\u0011%\u00111M\u0001\u000ba>\u001c\u0018\u000e^5p]>3G#B\u000b\u0002f\u0005%\u0004bBA4\u0003?\u0002\raT\u0001\u0005Q\u0006\u001c\b\u000eC\u0004\u0002l\u0005}\u0003\u0019A\u000b\u0002\u000f\u0005$H/Z7qi\"9\u0011q\u000e\u0001\u0005\n\u0005E\u0014\u0001\u00035bg\"Le\u000e^8\u0015\u000b\u0001\f\u0019(!\u001e\t\u000f\u0005}\u0011Q\u000ea\u0001g!9\u0011qOA7\u0001\u0004y\u0015A\u00022vM\u001a,'\u000fK\u0002\u0001\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003#\u0011!B;uS2\u001c\u0018\u0002BAC\u0003\u007f\u0012QB\\8oi\"\u0014X-\u00193tC\u001a,w!CAE\u0005\u0005\u0005\t\u0012AAF\u0003=\u00196.[7qs>3gm]3u\u001b\u0006\u0004\bcA\b\u0002\u000e\u001aA\u0011AAA\u0001\u0012\u0003\tyiE\u0002\u0002\u000e\"AqaKAG\t\u0003\t\u0019\n\u0006\u0002\u0002\f\"Q\u0011qSAG#\u0003%\t!!'\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tYJK\u0002\u001e\u0003;[#!a(\u0011\t\u0005\u0005\u00161V\u0007\u0003\u0003GSA!!*\u0002(\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003SS\u0011AC1o]>$\u0018\r^5p]&!\u0011QVAR\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class SkimpyOffsetMap
implements OffsetMap {
    private final int memory;
    private final String hashAlgorithm;
    private final ByteBuffer bytes;
    private final MessageDigest digest;
    private final int hashSize;
    private final byte[] hash1;
    private final byte[] hash2;
    private int entries;
    private long lookups;
    private long probes;
    private long lastOffset;
    private final int bytesPerEntry;
    private final int slots;

    public static String $lessinit$greater$default$2() {
        return SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public double utilization() {
        return OffsetMap.utilization$(this);
    }

    public int memory() {
        return this.memory;
    }

    public String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private MessageDigest digest() {
        return this.digest;
    }

    private int hashSize() {
        return this.hashSize;
    }

    private byte[] hash1() {
        return this.hash1;
    }

    private byte[] hash2() {
        return this.hash2;
    }

    private int entries() {
        return this.entries;
    }

    private void entries_$eq(int x$1) {
        this.entries = x$1;
    }

    private long lookups() {
        return this.lookups;
    }

    private void lookups_$eq(long x$1) {
        this.lookups = x$1;
    }

    private long probes() {
        return this.probes;
    }

    private void probes_$eq(long x$1) {
        this.probes = x$1;
    }

    private long lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(long x$1) {
        this.lastOffset = x$1;
    }

    public int bytesPerEntry() {
        return this.bytesPerEntry;
    }

    @Override
    public int slots() {
        return this.slots;
    }

    @Override
    public void put(ByteBuffer key, long offset) {
        Predef$.MODULE$.require(this.entries() < this.slots(), (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "Attempt to add a new entry to a full offset map.");
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = this.positionOf(this.hash1(), attempt);
        while (!this.isEmpty(pos)) {
            this.bytes().position(pos);
            this.bytes().get(this.hash2());
            if (Arrays.equals(this.hash1(), this.hash2())) {
                this.bytes().putLong(offset);
                this.lastOffset_$eq(offset);
                return;
            }
            pos = this.positionOf(this.hash1(), ++attempt);
        }
        this.bytes().position(pos);
        this.bytes().put(this.hash1());
        this.bytes().putLong(offset);
        this.lastOffset_$eq(offset);
        this.entries_$eq(this.entries() + 1);
    }

    private boolean isEmpty(int position) {
        return this.bytes().getLong(position) == 0L && this.bytes().getLong(position + 8) == 0L && this.bytes().getLong(position + 16) == 0L;
    }

    @Override
    public long get(ByteBuffer key) {
        this.lookups_$eq(this.lookups() + 1L);
        this.hashInto(key, this.hash1());
        int attempt = 0;
        int pos = 0;
        int maxAttempts = this.slots() + this.hashSize() - 4;
        do {
            if (attempt >= maxAttempts) {
                return -1L;
            }
            pos = this.positionOf(this.hash1(), attempt);
            this.bytes().position(pos);
            if (this.isEmpty(pos)) {
                return -1L;
            }
            this.bytes().get(this.hash2());
            ++attempt;
        } while (!Arrays.equals(this.hash1(), this.hash2()));
        return this.bytes().getLong();
    }

    @Override
    public void clear() {
        this.entries_$eq(0);
        this.lookups_$eq(0L);
        this.probes_$eq(0L);
        this.lastOffset_$eq(-1L);
        Arrays.fill(this.bytes().array(), this.bytes().arrayOffset(), this.bytes().arrayOffset() + this.bytes().limit(), (byte)0);
    }

    @Override
    public int size() {
        return this.entries();
    }

    public double collisionRate() {
        return (double)(this.probes() - this.lookups()) / (double)this.lookups();
    }

    @Override
    public long latestOffset() {
        return this.lastOffset();
    }

    @Override
    public void updateLatestOffset(long offset) {
        this.lastOffset_$eq(offset);
    }

    private int positionOf(byte[] hash, int attempt) {
        int probe = CoreUtils$.MODULE$.readInt(hash, package$.MODULE$.min(attempt, this.hashSize() - 4)) + package$.MODULE$.max(0, attempt - this.hashSize() + 4);
        int slot = Utils.abs(probe) % this.slots();
        this.probes_$eq(this.probes() + 1L);
        return slot * this.bytesPerEntry();
    }

    private void hashInto(ByteBuffer key, byte[] buffer) {
        key.mark();
        this.digest().update(key);
        key.reset();
        this.digest().digest(buffer, 0, this.hashSize());
    }

    public SkimpyOffsetMap(int memory, String hashAlgorithm) {
        this.memory = memory;
        this.hashAlgorithm = hashAlgorithm;
        OffsetMap.$init$(this);
        this.bytes = ByteBuffer.allocate(memory);
        this.digest = MessageDigest.getInstance(hashAlgorithm);
        this.hashSize = this.digest().getDigestLength();
        this.hash1 = new byte[this.hashSize()];
        this.hash2 = new byte[this.hashSize()];
        this.entries = 0;
        this.lookups = 0L;
        this.probes = 0L;
        this.lastOffset = -1L;
        this.bytesPerEntry = this.hashSize() + 8;
        this.slots = memory / this.bytesPerEntry();
    }
}

