/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.runtime.java8.JFunction0$mcZ$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002V5nK&sG-\u001a=\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0003\n\u00151aQ\"\u0001\u0002\n\u0005-\u0011!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007\u0010\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0003M_:<\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0001!\u0011!Q\u0001\ni\tQa\u00184jY\u0016\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0005%|'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011AAR5mK\"I1\u0005\u0001B\u0001B\u0003%A\u0002J\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\u0018BA\u0012\u000b\u0011%1\u0003A!A!\u0002\u00139#&\u0001\u0007nCbLe\u000eZ3y'&TX\r\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\u0004\u0013:$\u0018B\u0001\u0014\u000b\u0011%a\u0003A!A!\u0002\u0013i\u0003'\u0001\u0005xe&$\u0018M\u00197f!\tia&\u0003\u00020\u001d\t9!i\\8mK\u0006t\u0017B\u0001\u0017\u000b\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q)A'\u000e\u001c8qA\u0011\u0011\u0002\u0001\u0005\u00063E\u0002\rA\u0007\u0005\u0006GE\u0002\r\u0001\u0004\u0005\bME\u0002\n\u00111\u0001(\u0011\u001da\u0013\u0007%AA\u00025BqA\u000f\u0001A\u0002\u0013%1(\u0001\u0006`Y\u0006\u001cH/\u00128uef,\u0012\u0001\u0010\t\u0003\u0013uJ!A\u0010\u0002\u0003\u001fQKW.Z:uC6\u0004xJ\u001a4tKRDq\u0001\u0011\u0001A\u0002\u0013%\u0011)\u0001\b`Y\u0006\u001cH/\u00128uef|F%Z9\u0015\u0005\t+\u0005CA\u0007D\u0013\t!eB\u0001\u0003V]&$\bb\u0002$@\u0003\u0003\u0005\r\u0001P\u0001\u0004q\u0012\n\u0004B\u0002%\u0001A\u0003&A(A\u0006`Y\u0006\u001cH/\u00128uef\u0004\u0003FA$K!\ti1*\u0003\u0002M\u001d\tAao\u001c7bi&dW\rC\u0003O\u0001\u0011\u0005s*A\u0005f]R\u0014\u0018pU5{KV\tq\u0005C\u0003R\u0001\u0011\u0005#+\u0001\u0004jg\u001a+H\u000e\\\u000b\u0002[!)A\u000b\u0001C\u0005+\u0006IA/[7fgR\fW\u000e\u001d\u000b\u0004\u0019Ys\u0006\"B,T\u0001\u0004A\u0016A\u00022vM\u001a,'\u000f\u0005\u0002Z96\t!L\u0003\u0002\\=\u0005\u0019a.[8\n\u0005uS&A\u0003\"zi\u0016\u0014UO\u001a4fe\")ql\u0015a\u0001O\u0005\ta\u000eC\u0003b\u0001\u0011%!-\u0001\bsK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\u0007\u001d\u001aG\rC\u0003XA\u0002\u0007\u0001\fC\u0003`A\u0002\u0007q\u0005C\u0003g\u0001\u0011\u00051(A\u0005mCN$XI\u001c;ss\")\u0001\u000e\u0001C\u0005w\u00051B.Y:u\u000b:$(/\u001f$s_6Le\u000eZ3y\r&dW\rC\u0003k\u0001\u0011\u00051.A\u0003f]R\u0014\u0018\u0010\u0006\u0002=Y\")q,\u001ba\u0001O!)a\u000e\u0001C!_\u0006Q\u0001/\u0019:tK\u0016sGO]=\u0015\u0007A\u001cH\u000f\u0005\u0002\nc&\u0011!O\u0001\u0002\u000b\u0013:$W\r_#oiJL\b\"B,n\u0001\u0004A\u0006\"B0n\u0001\u00049\u0003\"\u0002<\u0001\t\u00039\u0018aC7bs\n,\u0017\t\u001d9f]\u0012$BA\u0011=zw\")A+\u001ea\u0001\u0019!)!0\u001ea\u0001\u0019\u00051qN\u001a4tKRDq\u0001`;\u0011\u0002\u0003\u0007Q&A\u0007tW&\u0004h)\u001e7m\u0007\",7m\u001b\u0005\u0006}\u0002!\ta`\u0001\u0007Y>|7.\u001e9\u0015\u0007q\n\t\u0001\u0003\u0004\u0002\u0004u\u0004\r\u0001D\u0001\u0010i\u0006\u0014x-\u001a;US6,7\u000f^1na\"9\u0011q\u0001\u0001\u0005B\u0005%\u0011\u0001\u0003;sk:\u001c\u0017\r^3\u0015\u0003\tCq!!\u0004\u0001\t\u0003\ny!\u0001\u0006ueVt7-\u0019;f)>$2AQA\t\u0011\u0019Q\u00181\u0002a\u0001\u0019!9\u0011Q\u0003\u0001\u0005B\u0005]\u0011A\u0002:fg&TX\rF\u0002.\u00033Aq!a\u0007\u0002\u0014\u0001\u0007q%A\u0004oK^\u001c\u0016N_3\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"\u0005\tBO];oG\u0006$X\rV8F]R\u0014\u0018.Z:\u0015\u0007\t\u000b\u0019\u0003C\u0004\u0002&\u0005u\u0001\u0019A\u0014\u0002\u000f\u0015tGO]5fg\"9\u0011\u0011\u0006\u0001\u0005B\u0005%\u0011aC:b]&$\u0018p\u00115fG.D\u0011\"!\f\u0001#\u0003%\t!a\f\u0002+5\f\u0017PY3BaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0007\u0016\u0004[\u0005M2FAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}b\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0011\u0002:\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u001b\u0005\u001d\u0003\u0001%A\u0002\u0002\u0003%I!!\u0013%\u0003A\u0019X\u000f]3sI\t\f7/Z(gMN,G/F\u0001\r\u00119\ti\u0005\u0001I\u0001\u0004\u0003\u0005I\u0011BA(\u0003'\nAb];qKJ$#/Z:ju\u0016$2!LA)\u0011\u001d\tY\"a\u0013A\u0002\u001dJ1!!\u0006\u000b\u000f%\t9FAA\u0001\u0012\u0003\tI&A\u0005US6,\u0017J\u001c3fqB\u0019\u0011\"a\u0017\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003;\u001aB!a\u0017\u0002`A\u0019Q\"!\u0019\n\u0007\u0005\rdB\u0001\u0004B]f\u0014VM\u001a\u0005\be\u0005mC\u0011AA4)\t\tI\u0006\u0003\u0006\u0002l\u0005m\u0013\u0013!C\u0001\u0003[\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA8U\r9\u00131\u0007\u0005\u000b\u0003g\nY&%A\u0005\u0002\u0005=\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    private volatile TimestampOffset _lastEntry = this.lastEntryFromIndexFile();

    public static boolean $lessinit$greater$default$4() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    private /* synthetic */ boolean super$resize(int newSize) {
        return super.resize(newSize);
    }

    private TimestampOffset _lastEntry() {
        return this._lastEntry;
    }

    private void _lastEntry_$eq(TimestampOffset x$1) {
        this._lastEntry = x$1;
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return this._lastEntry();
    }

    private TimestampOffset lastEntryFromIndexFile() {
        return (TimestampOffset)CoreUtils$.MODULE$.inLock(this.lock(), (Function0<TimestampOffset> & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            int n = this._entries();
            switch (n) {
                case 0: {
                    timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
                    break;
                }
                default: {
                    timestampOffset = (TimestampOffset)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return timestampOffset;
        });
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0<TimestampOffset> & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from a time index of size %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(n), BoxesRunTime.boxToInteger(this._entries())})));
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new TimestampOffset(this.timestamp(idx, n), this.relativeOffset(idx, n));
        });
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0$mcV$sp & scala.Serializable)() -> {
            block3: {
                if (!skipFullCheck) {
                    Predef$.MODULE$.require(!this.isFull(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Attempt to append to a full time index (size = " + this._entries() + ").");
                }
                if (this._entries() != 0 && offset < this.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to slot %d no larger than the last offset appended (%d) to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(offset), BoxesRunTime.boxToInteger(this._entries()), BoxesRunTime.boxToLong(this.lastEntry().offset()), this.file().getAbsolutePath()})));
                }
                if (this._entries() != 0 && timestamp < this.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append a timestamp (%d) to slot %d no larger than the last timestamp appended (%d) to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(timestamp), BoxesRunTime.boxToInteger(this._entries()), BoxesRunTime.boxToLong(this.lastEntry().timestamp()), this.file().getAbsolutePath()})));
                }
                if (timestamp <= this.lastEntry().timestamp()) break block3;
                this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(timestamp), BoxesRunTime.boxToLong(offset), this.file().getName()})));
                this.mmap().putLong(timestamp);
                this.mmap().putInt((int)(offset - this.super$baseOffset()));
                this._entries_$eq(this._entries() + 1);
                this._lastEntry_$eq(new TimestampOffset(timestamp, offset));
                Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> this._entries() + " entries but file position in index is " + this.mmap().position() + ".");
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0<TimestampOffset> & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetTimestamp, IndexSearchType$.MODULE$.KEY());
            if (slot == -1) {
                timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
            } else {
                TimestampOffset entry = (TimestampOffset)this.parseEntry(idx, slot);
                timestampOffset = new TimestampOffset(entry.timestamp(), entry.offset());
            }
            return timestampOffset;
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0$mcV$sp & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.VALUE());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    @Override
    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0$mcZ$sp & scala.Serializable)() -> {
            boolean bl;
            if (this.super$resize(newSize)) {
                this._lastEntry_$eq(this.lastEntryFromIndexFile());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }));
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0$mcV$sp & scala.Serializable)() -> {
            this._entries_$eq(entries);
            this.mmap().position(this._entries() * this.entrySize());
            this._lastEntry_$eq(this.lastEntryFromIndexFile());
        });
    }

    @Override
    public void sanityCheck() {
        long lastTimestamp = this.lastEntry().timestamp();
        long lastOffset = this.lastEntry().offset();
        if (this._entries() != 0 && lastTimestamp < this.timestamp(this.mmap(), 0)) {
            throw new CorruptIndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.file().getAbsolutePath()})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-zero size but the last timestamp is ", " which is less than the first timestamp "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(lastTimestamp)})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.timestamp(this.mmap(), 0))})));
        }
        if (this._entries() != 0 && lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.file().getAbsolutePath()})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non-zero size but the last offset is ", " which is less than the first offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(lastOffset), BoxesRunTime.boxToLong(super.baseOffset())})));
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time index file ", " is corrupt, found ", " bytes "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToLong(this.length())})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which is neither positive nor a multiple of ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.entrySize())})));
        }
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
    }
}

