/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.reporting.CsvReporter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaCSVMetricsReporterMBean;
import kafka.metrics.KafkaMetricsConfig;
import kafka.metrics.KafkaMetricsReporter;
import kafka.utils.Logging;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0005\u000f\t92*\u00194lC\u000e\u001bf+T3ue&\u001c7OU3q_J$XM\u001d\u0006\u0003\u0007\u0011\tq!\\3ue&\u001c7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019R\u0001\u0001\u0005\u000f%U\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005QY\u0015MZ6b\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;feB\u0011qbE\u0005\u0003)\t\u0011AdS1gW\u0006\u001c5KV'fiJL7m\u001d*fa>\u0014H/\u001a:N\u0005\u0016\fg\u000e\u0005\u0002\u001735\tqC\u0003\u0002\u0019\t\u0005)Q\u000f^5mg&\u0011!d\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002\u0010\u0001!9\u0001\u0005\u0001a\u0001\n\u0013\t\u0013AB2tm\u0012K'/F\u0001#!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0002j_*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u00111\u0015\u000e\\3\t\u000f-\u0002\u0001\u0019!C\u0005Y\u0005Q1m\u001d<ESJ|F%Z9\u0015\u00055\u0002\u0004CA\u0005/\u0013\ty#B\u0001\u0003V]&$\bbB\u0019+\u0003\u0003\u0005\rAI\u0001\u0004q\u0012\n\u0004BB\u001a\u0001A\u0003&!%A\u0004dgZ$\u0015N\u001d\u0011\t\u000fU\u0002\u0001\u0019!C\u0005m\u0005QQO\u001c3fe2L\u0018N\\4\u0016\u0003]\u0002\"\u0001\u000f!\u000e\u0003eR!AO\u001e\u0002\u0013I,\u0007o\u001c:uS:<'BA\u0002=\u0015\tid(\u0001\u0004zC6lWM\u001d\u0006\u0002\u007f\u0005\u00191m\\7\n\u0005\u0005K$aC\"tmJ+\u0007o\u001c:uKJDqa\u0011\u0001A\u0002\u0013%A)\u0001\bv]\u0012,'\u000f\\=j]\u001e|F%Z9\u0015\u00055*\u0005bB\u0019C\u0003\u0003\u0005\ra\u000e\u0005\u0007\u000f\u0002\u0001\u000b\u0015B\u001c\u0002\u0017UtG-\u001a:ms&tw\r\t\u0005\b\u0013\u0002\u0001\r\u0011\"\u0003K\u0003\u001d\u0011XO\u001c8j]\u001e,\u0012a\u0013\t\u0003\u00131K!!\u0014\u0006\u0003\u000f\t{w\u000e\\3b]\"9q\n\u0001a\u0001\n\u0013\u0001\u0016a\u0003:v]:LgnZ0%KF$\"!L)\t\u000fEr\u0015\u0011!a\u0001\u0017\"11\u000b\u0001Q!\n-\u000b\u0001B];o]&tw\r\t\u0005\b+\u0002\u0001\r\u0011\"\u0003K\u0003-Ig.\u001b;jC2L'0\u001a3\t\u000f]\u0003\u0001\u0019!C\u00051\u0006y\u0011N\\5uS\u0006d\u0017N_3e?\u0012*\u0017\u000f\u0006\u0002.3\"9\u0011GVA\u0001\u0002\u0004Y\u0005BB.\u0001A\u0003&1*\u0001\u0007j]&$\u0018.\u00197ju\u0016$\u0007\u0005C\u0003^\u0001\u0011\u0005c,\u0001\u0007hKRl%)Z1o\u001d\u0006lW-F\u0001`!\t\u00017-D\u0001b\u0015\t\u0011g%\u0001\u0003mC:<\u0017B\u00013b\u0005\u0019\u0019FO]5oO\")a\r\u0001C!O\u0006!\u0011N\\5u)\ti\u0003\u000eC\u0003jK\u0002\u0007!.A\u0003qe>\u00048\u000f\u0005\u0002\u0017W&\u0011An\u0006\u0002\u0015-\u0016\u0014\u0018NZ5bE2,\u0007K]8qKJ$\u0018.Z:\t\u000b9\u0004A\u0011I8\u0002\u001bM$\u0018M\u001d;SKB|'\u000f^3s)\ti\u0003\u000fC\u0003r[\u0002\u0007!/A\tq_2d\u0017N\\4QKJLw\u000eZ*fGN\u0004\"!C:\n\u0005QT!\u0001\u0002'p]\u001eDQA\u001e\u0001\u0005B]\fAb\u001d;paJ+\u0007o\u001c:uKJ$\u0012!\f")
public class KafkaCSVMetricsReporter
implements KafkaMetricsReporter,
KafkaCSVMetricsReporterMBean,
Logging {
    private File csvDir;
    private CsvReporter underlying;
    private boolean running;
    private boolean initialized;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KafkaCSVMetricsReporter kafkaCSVMetricsReporter = this;
        synchronized (kafkaCSVMetricsReporter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private File csvDir() {
        return this.csvDir;
    }

    private void csvDir_$eq(File x$1) {
        this.csvDir = x$1;
    }

    private CsvReporter underlying() {
        return this.underlying;
    }

    private void underlying_$eq(CsvReporter x$1) {
        this.underlying = x$1;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    @Override
    public String getMBeanName() {
        return "kafka:type=kafka.metrics.KafkaCSVMetricsReporter";
    }

    @Override
    public synchronized void init(VerifiableProperties props) {
        block1: {
            if (this.initialized()) break block1;
            KafkaMetricsConfig metricsConfig = new KafkaMetricsConfig(props);
            this.csvDir_$eq(new File(props.getString("kafka.csv.metrics.dir", "kafka_metrics")));
            Utils.delete(this.csvDir());
            Files.createDirectories(this.csvDir().toPath(), new FileAttribute[0]);
            this.underlying_$eq(new CsvReporter(Metrics.defaultRegistry(), this.csvDir()));
            if (props.getBoolean("kafka.csv.metrics.reporter.enabled", false)) {
                this.initialized_$eq(true);
                this.startReporter(metricsConfig.pollingIntervalSecs());
            }
        }
    }

    @Override
    public synchronized void startReporter(long pollingPeriodSecs) {
        block0: {
            if (!this.initialized() || this.running()) break block0;
            this.underlying().start(pollingPeriodSecs, TimeUnit.SECONDS);
            this.running_$eq(true);
            this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Started Kafka CSV metrics reporter with polling period %d seconds")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(pollingPeriodSecs)})));
        }
    }

    @Override
    public synchronized void stopReporter() {
        block0: {
            if (!this.initialized() || !this.running()) break block0;
            this.underlying().shutdown();
            this.running_$eq(false);
            this.info((Function0<String> & Serializable & scala.Serializable)() -> "Stopped Kafka CSV metrics reporter");
            this.underlying_$eq(new CsvReporter(Metrics.defaultRegistry(), this.csvDir()));
        }
    }

    public KafkaCSVMetricsReporter() {
        Logging.$init$(this);
        this.csvDir = null;
        this.underlying = null;
        this.running = false;
        this.initialized = false;
    }
}

