/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.producer.BaseProducer;
import kafka.producer.NewShinyProducer;
import kafka.producer.OldProducer;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.NullEncoder;
import kafka.tools.PerfConfig;
import kafka.tools.ProducerPerformance$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Implicits$;
import kafka.utils.ToolsUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\r5u!B\u0001\u0003\u0011\u00039\u0011a\u0005)s_\u0012,8-\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014!J|G-^2feB+'OZ8s[\u0006t7-Z\n\u0004\u00131\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005)Q\u000f^5mg&\u0011q\u0003\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015I\u0012\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0003\u001d\u0013\u0011\u0005Q$\u0001\u0003nC&tGC\u0001\u0010\"!\tiq$\u0003\u0002!\u001d\t!QK\\5u\u0011\u0015\u00113\u00041\u0001$\u0003\u0011\t'oZ:\u0011\u00075!c%\u0003\u0002&\u001d\t)\u0011I\u001d:bsB\u0011qE\f\b\u0003Q1\u0002\"!\u000b\b\u000e\u0003)R!a\u000b\u0004\u0002\rq\u0012xn\u001c;?\u0013\tic\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017\u000f\r\u0011\u0011\u0014\u0002A\u001a\u0003%A\u0013x\u000eZ;dKJ\u0004VM\u001d4D_:4\u0017nZ\n\u0003cQ\u0002\"\u0001C\u001b\n\u0005Y\u0012!A\u0003)fe\u001a\u001cuN\u001c4jO\"A!%\rB\u0001B\u0003%1\u0005C\u0003\u001ac\u0011\u0005\u0011\b\u0006\u0002;yA\u00111(M\u0007\u0002\u0013!)!\u0005\u000fa\u0001G!9a(\rb\u0001\n\u0003y\u0014!\u00042s_.,'\u000fT5ti>\u0003H/F\u0001A!\r\tEIJ\u0007\u0002\u0005*\t1)\u0001\u0006k_B$8/[7qY\u0016L!!\u0012\"\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0011\u00199\u0015\u0007)A\u0005\u0001\u0006q!M]8lKJd\u0015n\u001d;PaR\u0004\u0003bB%2\u0005\u0004%\taP\u0001\u0012aJ|G-^2fe\u000e{gNZ5h\u001fB$\bBB&2A\u0003%\u0001)\u0001\nqe>$WoY3s\u0007>tg-[4PaR\u0004\u0003bB'2\u0005\u0004%\taP\u0001\ni>\u0004\u0018nY:PaRDaaT\u0019!\u0002\u0013\u0001\u0015A\u0003;pa&\u001c7o\u00149uA!9\u0011+\rb\u0001\n\u0003\u0011\u0016a\u00079s_\u0012,8-\u001a:SKF,Xm\u001d;US6,w.\u001e;Ng>\u0003H/F\u0001T!\r\tE\t\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bA\u0001\\1oO*\t\u0011,\u0001\u0003kCZ\f\u0017BA.W\u0005\u001dIe\u000e^3hKJDa!X\u0019!\u0002\u0013\u0019\u0016\u0001\b9s_\u0012,8-\u001a:SKF,Xm\u001d;US6,w.\u001e;Ng>\u0003H\u000f\t\u0005\b?F\u0012\r\u0011\"\u0001S\u0003U\u0001(o\u001c3vG\u0016\u0014h*^7SKR\u0014\u0018.Z:PaRDa!Y\u0019!\u0002\u0013\u0019\u0016A\u00069s_\u0012,8-\u001a:Ok6\u0014V\r\u001e:jKN|\u0005\u000f\u001e\u0011\t\u000f\r\f$\u0019!C\u0001%\u0006I\u0002O]8ek\u000e,'OU3uef\u0014\u0015mY6PM\u001al5o\u00149u\u0011\u0019)\u0017\u0007)A\u0005'\u0006Q\u0002O]8ek\u000e,'OU3uef\u0014\u0015mY6PM\u001al5o\u00149uA!9q-\rb\u0001\n\u0003\u0011\u0016A\b9s_\u0012,8-\u001a:SKF,Xm\u001d;SKF,\u0018N]3e\u0003\u000e\\7o\u00149u\u0011\u0019I\u0017\u0007)A\u0005'\u0006y\u0002O]8ek\u000e,'OU3rk\u0016\u001cHOU3rk&\u0014X\rZ!dWN|\u0005\u000f\u001e\u0011\t\u000f-\f$\u0019!C\u0001Y\u0006\u0011b/\u0019:z\u001b\u0016\u001c8/Y4f'&TXm\u00149u+\u0005i\u0007CA!o\u0013\ty'IA\tPaRLwN\\*qK\u000e\u0014U/\u001b7eKJDa!]\u0019!\u0002\u0013i\u0017a\u0005<beflUm]:bO\u0016\u001c\u0016N_3PaR\u0004\u0003bB:2\u0005\u0004%\t\u0001\\\u0001\bgft7m\u00149u\u0011\u0019)\u0018\u0007)A\u0005[\u0006A1/\u001f8d\u001fB$\b\u0005C\u0004xc\t\u0007I\u0011\u0001*\u0002\u001b9,X\u000e\u00165sK\u0006$7o\u00149u\u0011\u0019I\u0018\u0007)A\u0005'\u0006qa.^7UQJ,\u0017\rZ:PaR\u0004\u0003bB>2\u0005\u0004%\tAU\u0001\u0014S:LG/[1m\u001b\u0016\u001c8/Y4f\u0013\u0012|\u0005\u000f\u001e\u0005\u0007{F\u0002\u000b\u0011B*\u0002)%t\u0017\u000e^5bY6+7o]1hK&#w\n\u001d;!\u0011\u001dy\u0018G1A\u0005\u0002I\u000b1#\\3tg\u0006<WmU3oI\u001e\u000b\u0007/T:PaRDq!a\u00012A\u0003%1+\u0001\u000bnKN\u001c\u0018mZ3TK:$w)\u00199Ng>\u0003H\u000f\t\u0005\t\u0003\u000f\t$\u0019!C\u0001Y\u0006a2m\u001d<NKR\u0014\u0018nY:SKB|'\u000f^3s\u000b:\f'\r\\3e\u001fB$\bbBA\u0006c\u0001\u0006I!\\\u0001\u001eGN4X*\u001a;sS\u000e\u001c(+\u001a9peR,'/\u00128bE2,Gm\u00149uA!I\u0011qB\u0019C\u0002\u0013\u0005\u0011\u0011C\u0001\u0014[\u0016$(/[2t\t&\u0014Xm\u0019;pef|\u0005\u000f^\u000b\u0003\u0003'\u0001B!\u0011#\u0002\u0016A\u0019Q+a\u0006\n\u0005=2\u0006\u0002CA\u000ec\u0001\u0006I!a\u0005\u0002)5,GO]5dg\u0012K'/Z2u_JLx\n\u001d;!\u0011!\ty\"\rb\u0001\n\u0003a\u0017!E;tK:+w\u000f\u0015:pIV\u001cWM](qi\"9\u00111E\u0019!\u0002\u0013i\u0017AE;tK:+w\u000f\u0015:pIV\u001cWM](qi\u0002B\u0001\"a\n2\u0005\u0004%\tAU\u0001\u000f[\u0016\u001c8/Y4f'&TXm\u00149u\u0011\u001d\tY#\rQ\u0001\nM\u000bq\"\\3tg\u0006<WmU5{K>\u0003H\u000f\t\u0005\t\u0003_\t$\u0019!C\u0001%\u0006a!-\u0019;dQNK'0Z(qi\"9\u00111G\u0019!\u0002\u0013\u0019\u0016!\u00042bi\u000eD7+\u001b>f\u001fB$\b\u0005\u0003\u0005\u00028E\u0012\r\u0011\"\u0001S\u0003M\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7m\u00149u\u0011\u001d\tY$\rQ\u0001\nM\u000bAcY8naJ,7o]5p]\u000e{G-Z2PaR\u0004\u0003\"CA c\t\u0007I\u0011AA!\u0003\u001dy\u0007\u000f^5p]N,\"!a\u0011\u0011\u0007\u0005\u000b)%C\u0002\u0002H\t\u0013\u0011b\u00149uS>t7+\u001a;\t\u0011\u0005-\u0013\u0007)A\u0005\u0003\u0007\n\u0001b\u001c9uS>t7\u000f\t\u0005\n\u0003\u001f\n$\u0019!C\u0001\u0003#\n\u0011\u0002^8qS\u000e\u001c8\u000b\u001e:\u0016\u0003\u0019Bq!!\u00162A\u0003%a%\u0001\u0006u_BL7m]*ue\u0002B\u0011\"!\u00172\u0005\u0004%\t!a\u0017\u0002\rQ|\u0007/[2t+\t\ti\u0006\u0005\u0003\u000eI\u0005U\u0001\u0002CA1c\u0001\u0006I!!\u0018\u0002\u000fQ|\u0007/[2tA!I\u0011QM\u0019C\u0002\u0013\u0005\u0011qM\u0001\f]VlW*Z:tC\u001e,7/\u0006\u0002\u0002jA\u0019Q\"a\u001b\n\u0007\u00055dB\u0001\u0003M_:<\u0007\u0002CA9c\u0001\u0006I!!\u001b\u0002\u00199,X.T3tg\u0006<Wm\u001d\u0011\t\u0013\u0005U\u0014G1A\u0005\u0002\u0005]\u0014!\u0005:fa>\u0014H/\u001b8h\u0013:$XM\u001d<bYV\u0011\u0011\u0011\u0010\t\u0004\u001b\u0005m\u0014bAA?\u001d\t\u0019\u0011J\u001c;\t\u0011\u0005\u0005\u0015\u0007)A\u0005\u0003s\n!C]3q_J$\u0018N\\4J]R,'O^1mA!I\u0011QQ\u0019C\u0002\u0013\u0005\u0011qQ\u0001\u000bI\u0006$XMR8s[\u0006$XCAAE!\u0011\tY)!%\u000e\u0005\u00055%bAAH1\u0006!A/\u001a=u\u0013\u0011\t\u0019*!$\u0003!MKW\u000e\u001d7f\t\u0006$XMR8s[\u0006$\b\u0002CALc\u0001\u0006I!!#\u0002\u0017\u0011\fG/\u001a$pe6\fG\u000f\t\u0005\n\u00037\u000b$\u0019!C\u0001\u0003;\u000b!\u0002[5eK\"+\u0017\rZ3s+\t\ty\nE\u0002\u000e\u0003CK1!a)\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001\"a*2A\u0003%\u0011qT\u0001\fQ&$W\rS3bI\u0016\u0014\b\u0005C\u0005\u0002,F\u0012\r\u0011\"\u0001\u0002R\u0005Q!M]8lKJd\u0015n\u001d;\t\u000f\u0005=\u0016\u0007)A\u0005M\u0005Y!M]8lKJd\u0015n\u001d;!\u0011%\t\u0019,\rb\u0001\n\u0003\t9(A\u0006nKN\u001c\u0018mZ3TSj,\u0007\u0002CA\\c\u0001\u0006I!!\u001f\u0002\u00195,7o]1hKNK'0\u001a\u0011\t\u0013\u0005m\u0016\u00071A\u0005\u0002\u0005u\u0015aC5t\r&DX\rZ*ju\u0016D\u0011\"a02\u0001\u0004%\t!!1\u0002\u001f%\u001ch)\u001b=fINK'0Z0%KF$2AHAb\u0011)\t)-!0\u0002\u0002\u0003\u0007\u0011qT\u0001\u0004q\u0012\n\u0004\u0002CAec\u0001\u0006K!a(\u0002\u0019%\u001ch)\u001b=fINK'0\u001a\u0011\t\u0013\u00055\u0017\u00071A\u0005\u0002\u0005u\u0015AB5t'ft7\rC\u0005\u0002RF\u0002\r\u0011\"\u0001\u0002T\u0006Q\u0011n]*z]\u000e|F%Z9\u0015\u0007y\t)\u000e\u0003\u0006\u0002F\u0006=\u0017\u0011!a\u0001\u0003?C\u0001\"!72A\u0003&\u0011qT\u0001\bSN\u001c\u0016P\\2!\u0011%\ti.\ra\u0001\n\u0003\t9(A\u0005cCR\u001c\u0007nU5{K\"I\u0011\u0011]\u0019A\u0002\u0013\u0005\u00111]\u0001\u000eE\u0006$8\r[*ju\u0016|F%Z9\u0015\u0007y\t)\u000f\u0003\u0006\u0002F\u0006}\u0017\u0011!a\u0001\u0003sB\u0001\"!;2A\u0003&\u0011\u0011P\u0001\u000bE\u0006$8\r[*ju\u0016\u0004\u0003\"CAwc\u0001\u0007I\u0011AA<\u0003)qW/\u001c+ie\u0016\fGm\u001d\u0005\n\u0003c\f\u0004\u0019!C\u0001\u0003g\faB\\;n)\"\u0014X-\u00193t?\u0012*\u0017\u000fF\u0002\u001f\u0003kD!\"!2\u0002p\u0006\u0005\t\u0019AA=\u0011!\tI0\rQ!\n\u0005e\u0014a\u00038v[RC'/Z1eg\u0002B\u0011\"!@2\u0005\u0004%\t!a@\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cWC\u0001B\u0001!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!b\u0001B\u0004\t\u00059Q.Z:tC\u001e,\u0017\u0002\u0002B\u0006\u0005\u000b\u0011\u0001cQ8naJ,7o]5p]\u000e{G-Z2\t\u0011\t=\u0011\u0007)A\u0005\u0005\u0003\t\u0011cY8naJ,7o]5p]\u000e{G-Z2!\u0011%\u0011\u0019\"\rb\u0001\n\u0003\ti*A\u0005tKFLE-T8eK\"A!qC\u0019!\u0002\u0013\ty*\u0001\u0006tKFLE-T8eK\u0002B\u0011Ba\u00072\u0001\u0004%\t!a\u001e\u0002!%t\u0017\u000e^5bY6+7o]1hK&#\u0007\"\u0003B\u0010c\u0001\u0007I\u0011\u0001B\u0011\u0003QIg.\u001b;jC2lUm]:bO\u0016LEm\u0018\u0013fcR\u0019aDa\t\t\u0015\u0005\u0015'QDA\u0001\u0002\u0004\tI\b\u0003\u0005\u0003(E\u0002\u000b\u0015BA=\u0003EIg.\u001b;jC2lUm]:bO\u0016LE\r\t\u0005\n\u0005W\t$\u0019!C\u0001\u0003o\n\u0001\u0004\u001d:pIV\u001cWM\u001d*fcV,7\u000f\u001e+j[\u0016|W\u000f^'t\u0011!\u0011y#\rQ\u0001\n\u0005e\u0014!\u00079s_\u0012,8-\u001a:SKF,Xm\u001d;US6,w.\u001e;Ng\u0002B\u0011Ba\r2\u0005\u0004%\t!a\u001e\u00027A\u0014x\u000eZ;dKJ\u0014V-];fgR\u0014V-];je\u0016$\u0017iY6t\u0011!\u00119$\rQ\u0001\n\u0005e\u0014\u0001\b9s_\u0012,8-\u001a:SKF,Xm\u001d;SKF,\u0018N]3e\u0003\u000e\\7\u000f\t\u0005\n\u0005w\t$\u0019!C\u0001\u0003o\n!\u0003\u001d:pIV\u001cWM\u001d(v[J+GO]5fg\"A!qH\u0019!\u0002\u0013\tI(A\nqe>$WoY3s\u001dVl'+\u001a;sS\u0016\u001c\b\u0005C\u0005\u0003DE\u0012\r\u0011\"\u0001\u0002x\u00051\u0002O]8ek\u000e,'OU3uef\u0014\u0015mY6pM\u001al5\u000f\u0003\u0005\u0003HE\u0002\u000b\u0011BA=\u0003]\u0001(o\u001c3vG\u0016\u0014(+\u001a;ss\n\u000b7m[8gM6\u001b\b\u0005C\u0005\u0003LE\u0012\r\u0011\"\u0001\u0002\u001e\u0006qQo]3OK^\u0004&o\u001c3vG\u0016\u0014\b\u0002\u0003B(c\u0001\u0006I!a(\u0002\u001fU\u001cXMT3x!J|G-^2fe\u0002B\u0011Ba\u00152\u0005\u0004%\t!!(\u00023\r\u001ch/T3ue&\u001c7OU3q_J$XM]#oC\ndW\r\u001a\u0005\t\u0005/\n\u0004\u0015!\u0003\u0002 \u0006Q2m\u001d<NKR\u0014\u0018nY:SKB|'\u000f^3s\u000b:\f'\r\\3eA!I!1L\u0019C\u0002\u0013\u0005!QL\u0001\u000eaJ|G-^2feB\u0013x\u000e]:\u0016\u0005\t}\u0003\u0003\u0002B1\u0005Oj!Aa\u0019\u000b\u0007\t\u0015\u0004,\u0001\u0003vi&d\u0017\u0002\u0002B5\u0005G\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011!\u0011i'\rQ\u0001\n\t}\u0013A\u00049s_\u0012,8-\u001a:Qe>\u00048\u000f\t\u0005\n\u0005c\n$\u0019!C\u0001\u0003o\n\u0001#\\3tg\u0006<WmU3oI\u001e\u000b\u0007/T:\t\u0011\tU\u0014\u0007)A\u0005\u0003s\n\u0011#\\3tg\u0006<WmU3oI\u001e\u000b\u0007/T:!\r\u0019\u0011I(\u0003\u0001\u0003|\tq\u0001K]8ek\u000e,'\u000f\u00165sK\u0006$7C\u0002B<\u0005{\u0012\u0019\tE\u0002V\u0005\u007fJ1A!!W\u0005\u0019y%M[3diB\u0019QK!\"\n\u0007\t\u001deK\u0001\u0005Sk:t\u0017M\u00197f\u0011-\u0011YIa\u001e\u0003\u0006\u0004%\t!a\u001e\u0002\u0011QD'/Z1e\u0013\u0012D1Ba$\u0003x\t\u0005\t\u0015!\u0003\u0002z\u0005IA\u000f\u001b:fC\u0012LE\r\t\u0005\f\u0005'\u00139H!b\u0001\n\u0003\u0011)*\u0001\u0004d_:4\u0017nZ\u000b\u0002u!Q!\u0011\u0014B<\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002\u000f\r|gNZ5hA!Y!Q\u0014B<\u0005\u000b\u0007I\u0011\u0001BP\u00039!x\u000e^1m\u0005f$Xm]*f]R,\"A!)\u0011\t\t\r&QV\u0007\u0003\u0005KSAAa*\u0003*\u00061\u0011\r^8nS\u000eTAAa+\u0003d\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t=&Q\u0015\u0002\u000b\u0003R|W.[2M_:<\u0007b\u0003BZ\u0005o\u0012\t\u0011)A\u0005\u0005C\u000bq\u0002^8uC2\u0014\u0015\u0010^3t'\u0016tG\u000f\t\u0005\f\u0005o\u00139H!b\u0001\n\u0003\u0011y*A\tu_R\fG.T3tg\u0006<Wm]*f]RD1Ba/\u0003x\t\u0005\t\u0015!\u0003\u0003\"\u0006\u0011Bo\u001c;bY6+7o]1hKN\u001cVM\u001c;!\u0011-\u0011yLa\u001e\u0003\u0006\u0004%\tA!1\u0002\u000f\u0005dG\u000eR8oKV\u0011!1\u0019\t\u0005\u0005\u000b\u00149-\u0004\u0002\u0003*&!!\u0011\u001aBU\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D1B!4\u0003x\t\u0005\t\u0015!\u0003\u0003D\u0006A\u0011\r\u001c7E_:,\u0007\u0005C\u0006\u0003R\n]$Q1A\u0005\u0002\tM\u0017\u0001\u0002:b]\u0012,\"A!6\u0011\t\t\u0005$q[\u0005\u0005\u00053\u0014\u0019G\u0001\u0004SC:$w.\u001c\u0005\f\u0005;\u00149H!A!\u0002\u0013\u0011).A\u0003sC:$\u0007\u0005C\u0004\u001a\u0005o\"\tA!9\u0015\u001d\t\r(Q\u001dBt\u0005S\u0014YO!<\u0003pB\u00191Ha\u001e\t\u0011\t-%q\u001ca\u0001\u0003sBqAa%\u0003`\u0002\u0007!\b\u0003\u0005\u0003\u001e\n}\u0007\u0019\u0001BQ\u0011!\u00119La8A\u0002\t\u0005\u0006\u0002\u0003B`\u0005?\u0004\rAa1\t\u0011\tE'q\u001ca\u0001\u0005+D!Ba=\u0003x\t\u0007I\u0011AA<\u00035\u0019X-]%e\u001dVlG)[4ji\"I!q\u001fB<A\u0003%\u0011\u0011P\u0001\u000fg\u0016\f\u0018\n\u001a(v[\u0012Kw-\u001b;!\u0011)\u0011YPa\u001eC\u0002\u0013\u0005\u0011qM\u0001\u0012[\u0016\u001c8/Y4fgB+'\u000f\u00165sK\u0006$\u0007\"\u0003B\u0000\u0005o\u0002\u000b\u0011BA5\u0003IiWm]:bO\u0016\u001c\b+\u001a:UQJ,\u0017\r\u001a\u0011\t\u0015\r\r!q\u000fb\u0001\n\u0003\u0011i&A\u0003qe>\u00048\u000fC\u0005\u0004\b\t]\u0004\u0015!\u0003\u0003`\u00051\u0001O]8qg\u0002B!ba\u0003\u0003x\t\u0007I\u0011AB\u0007\u0003!\u0001(o\u001c3vG\u0016\u0014XCAB\b!\u0011\u0019\tb!\u0006\u000e\u0005\rM!bAB\u0006\t%!1qCB\n\u00051\u0011\u0015m]3Qe>$WoY3s\u0011%\u0019YBa\u001e!\u0002\u0013\u0019y!A\u0005qe>$WoY3sA!Q1q\u0004B<\u0005\u0004%Ia!\t\u0002\u0007M+\u0005+\u0006\u0002\u0002\u0016!I1Q\u0005B<A\u0003%\u0011QC\u0001\u0005'\u0016\u0003\u0006\u0005\u0003\u0006\u0004*\t]$\u0019!C\u0005\u0007C\ta\"\\3tg\u0006<W-\u00133MC\n,G\u000eC\u0005\u0004.\t]\u0004\u0015!\u0003\u0002\u0016\u0005yQ.Z:tC\u001e,\u0017\n\u001a'bE\u0016d\u0007\u0005\u0003\u0006\u00042\t]$\u0019!C\u0005\u0007C\tQ\u0002\u001e5sK\u0006$\u0017\n\u001a'bE\u0016d\u0007\"CB\u001b\u0005o\u0002\u000b\u0011BA\u000b\u00039!\bN]3bI&#G*\u00192fY\u0002B!b!\u000f\u0003x\t\u0007I\u0011BB\u0011\u0003)!x\u000e]5d\u0019\u0006\u0014W\r\u001c\u0005\n\u0007{\u00119\b)A\u0005\u0003+\t1\u0002^8qS\u000ed\u0015MY3mA!Q1\u0011\tB<\u0001\u0004%I!!\u0015\u0002\u001f1,g\r\u001e)bI\u0012,GmU3r\u0013\u0012D!b!\u0012\u0003x\u0001\u0007I\u0011BB$\u0003MaWM\u001a;QC\u0012$W\rZ*fc&#w\fJ3r)\rq2\u0011\n\u0005\n\u0003\u000b\u001c\u0019%!AA\u0002\u0019B\u0001b!\u0014\u0003x\u0001\u0006KAJ\u0001\u0011Y\u00164G\u000fU1eI\u0016$7+Z9JI\u0002B\u0001b!\u0015\u0003x\u0011%11K\u0001\u0019O\u0016tWM]1uK6+7o]1hK^KG\u000f[*fc&#G\u0003CB+\u0007;\u001a\tg!\u001a\u0011\t5!3q\u000b\t\u0004\u001b\re\u0013bAB.\u001d\t!!)\u001f;f\u0011\u001d\u0019yfa\u0014A\u0002\u0019\nQ\u0001^8qS\u000eD\u0001ba\u0019\u0004P\u0001\u0007\u0011\u0011N\u0001\u0006[N<\u0017\n\u001a\u0005\t\u0007O\u001ay\u00051\u0001\u0002z\u00059Qn]4TSj,\u0007\u0002CB6\u0005o\"Ia!\u001c\u0002)\u001d,g.\u001a:bi\u0016\u0004&o\u001c3vG\u0016\u0014H)\u0019;b)\u0019\u0019)fa\u001c\u0004r!91qLB5\u0001\u00041\u0003\u0002CB:\u0007S\u0002\r!!\u001b\u0002\u00135,7o]1hK&#\u0007\u0002CB<\u0005o\"\te!\u001f\u0002\u0007I,h\u000eF\u0001\u001fQ\u001dI1QPBB\u0007\u000f\u00032!DB@\u0013\r\u0019\tI\u0004\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EABC\u0003I$\u0006.[:!G2\f7o\u001d\u0011xS2d\u0007EY3!e\u0016\u0004H.Y2fI\u0002\u0012\u0017\u0010I8sO:\n\u0007/Y2iK:Z\u0017MZ6b]Q|w\u000e\\:/!J|G-^2feB+'OZ8s[\u0006t7-\u001a\u0011bMR,'\u000f\t;iK\u0002zG\u000e\u001a\u0011qe>$WoY3sA\rd\u0017.\u001a8uA%\u001c\bE]3n_Z,G-\t\u0002\u0004\n\u00069\u0001GL\u001d/a9\u0002\u0004f\u0002\u0001\u0004~\r\r5q\u0011")
public final class ProducerPerformance {
    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        ProducerPerformance$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        ProducerPerformance$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        ProducerPerformance$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        ProducerPerformance$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        ProducerPerformance$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return ProducerPerformance$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return ProducerPerformance$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        ProducerPerformance$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        ProducerPerformance$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return ProducerPerformance$.MODULE$.msgWithLogIdent(string);
    }

    public static String loggerName() {
        return ProducerPerformance$.MODULE$.loggerName();
    }

    public static void main(String[] stringArray) {
        ProducerPerformance$.MODULE$.main(stringArray);
    }

    public static String logIdent() {
        return ProducerPerformance$.MODULE$.logIdent();
    }

    public static Logger logger() {
        return ProducerPerformance$.MODULE$.logger();
    }

    public static class ProducerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt = this.parser().accepts("broker-list", "REQUIRED: broker info the list of broker host and port for bootstrap.").withRequiredArg().describedAs("hostname:port,..,hostname:port").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> producerConfigOpt = this.parser().accepts("producer.config", "Producer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicsOpt = this.parser().accepts("topics", "REQUIRED: The comma separated list of topics to produce to").withRequiredArg().describedAs("topic1,topic2..").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> producerRequestTimeoutMsOpt = this.parser().accepts("request-timeout-ms", "The producer request timeout in ms").withRequiredArg().ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(3000), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> producerNumRetriesOpt = this.parser().accepts("producer-num-retries", "The producer retries number").withRequiredArg().ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(3), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> producerRetryBackOffMsOpt = this.parser().accepts("producer-retry-backoff-ms", "The producer retry backoff time in milliseconds").withRequiredArg().ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(100), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> producerRequestRequiredAcksOpt = this.parser().accepts("request-num-acks", "Number of acks required for producer request to complete").withRequiredArg().ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(-1), (Integer[])((Object[])new Integer[0]));
        private final OptionSpecBuilder varyMessageSizeOpt = this.parser().accepts("vary-message-size", "If set, message size will vary up to the given maximum.");
        private final OptionSpecBuilder syncOpt = this.parser().accepts("sync", "If set, messages are sent synchronously.");
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of sending threads.").withRequiredArg().describedAs("number of threads").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> initialMessageIdOpt = this.parser().accepts("initial-message-id", "The is used for generating test data, If set, messages will be tagged with an ID and sent by producer starting from this ID sequentially. Message content will be String type and in the form of 'Message:000...1:xxx...'").withRequiredArg().describedAs("initial message id").ofType(Integer.class);
        private final ArgumentAcceptingOptionSpec<Integer> messageSendGapMsOpt = this.parser().accepts("message-send-gap-ms", "If set, the send thread will wait for specified time between two sends").withRequiredArg().describedAs("message send time gap").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0), (Integer[])((Object[])new Integer[0]));
        private final OptionSpecBuilder csvMetricsReporterEnabledOpt = this.parser().accepts("csv-reporter-enabled", "If set, the CSV metrics reporter will be enabled");
        private final ArgumentAcceptingOptionSpec<String> metricsDirectoryOpt = this.parser().accepts("metrics-dir", "If csv-reporter-enable is set, and this parameter isset, the csv metrics will be outputted here").withRequiredArg().describedAs("metrics directory").ofType(String.class);
        private final OptionSpecBuilder useNewProducerOpt = this.parser().accepts("new-producer", "Use the new producer implementation.");
        private final ArgumentAcceptingOptionSpec<Integer> messageSizeOpt = this.parser().accepts("message-size", "The size of each message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(100), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> batchSizeOpt = this.parser().accepts("batch-size", "Number of messages to write in a single batch.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(200), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> compressionCodecOpt = this.parser().accepts("compression-codec", "If set, messages are sent compressed").withRequiredArg().describedAs("supported codec: NoCompressionCodec as 0, GZIPCompressionCodec as 1, SnappyCompressionCodec as 2, LZ4CompressionCodec as 3").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0), (Integer[])((Object[])new Integer[0]));
        private final OptionSet options;
        private final String topicsStr;
        private final String[] topics;
        private final long numMessages;
        private final int reportingInterval;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;
        private final String brokerList;
        private final int messageSize;
        private boolean isFixedSize;
        private boolean isSync;
        private int batchSize;
        private int numThreads;
        private final CompressionCodec compressionCodec;
        private final boolean seqIdMode;
        private int initialMessageId;
        private final int producerRequestTimeoutMs;
        private final int producerRequestRequiredAcks;
        private final int producerNumRetries;
        private final int producerRetryBackoffMs;
        private final boolean useNewProducer;
        private final boolean csvMetricsReporterEnabled;
        private final Properties producerProps;
        private final int messageSendGapMs;

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerConfigOpt() {
            return this.producerConfigOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicsOpt() {
            return this.topicsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> producerRequestTimeoutMsOpt() {
            return this.producerRequestTimeoutMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> producerNumRetriesOpt() {
            return this.producerNumRetriesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> producerRetryBackOffMsOpt() {
            return this.producerRetryBackOffMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> producerRequestRequiredAcksOpt() {
            return this.producerRequestRequiredAcksOpt;
        }

        public OptionSpecBuilder varyMessageSizeOpt() {
            return this.varyMessageSizeOpt;
        }

        public OptionSpecBuilder syncOpt() {
            return this.syncOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> initialMessageIdOpt() {
            return this.initialMessageIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> messageSendGapMsOpt() {
            return this.messageSendGapMsOpt;
        }

        public OptionSpecBuilder csvMetricsReporterEnabledOpt() {
            return this.csvMetricsReporterEnabledOpt;
        }

        public ArgumentAcceptingOptionSpec<String> metricsDirectoryOpt() {
            return this.metricsDirectoryOpt;
        }

        public OptionSpecBuilder useNewProducerOpt() {
            return this.useNewProducerOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> messageSizeOpt() {
            return this.messageSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> batchSizeOpt() {
            return this.batchSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> compressionCodecOpt() {
            return this.compressionCodecOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public String topicsStr() {
            return this.topicsStr;
        }

        public String[] topics() {
            return this.topics;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public int messageSize() {
            return this.messageSize;
        }

        public boolean isFixedSize() {
            return this.isFixedSize;
        }

        public void isFixedSize_$eq(boolean x$1) {
            this.isFixedSize = x$1;
        }

        public boolean isSync() {
            return this.isSync;
        }

        public void isSync_$eq(boolean x$1) {
            this.isSync = x$1;
        }

        public int batchSize() {
            return this.batchSize;
        }

        public void batchSize_$eq(int x$1) {
            this.batchSize = x$1;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public void numThreads_$eq(int x$1) {
            this.numThreads = x$1;
        }

        public CompressionCodec compressionCodec() {
            return this.compressionCodec;
        }

        public boolean seqIdMode() {
            return this.seqIdMode;
        }

        public int initialMessageId() {
            return this.initialMessageId;
        }

        public void initialMessageId_$eq(int x$1) {
            this.initialMessageId = x$1;
        }

        public int producerRequestTimeoutMs() {
            return this.producerRequestTimeoutMs;
        }

        public int producerRequestRequiredAcks() {
            return this.producerRequestRequiredAcks;
        }

        public int producerNumRetries() {
            return this.producerNumRetries;
        }

        public int producerRetryBackoffMs() {
            return this.producerRetryBackoffMs;
        }

        public boolean useNewProducer() {
            return this.useNewProducer;
        }

        public boolean csvMetricsReporterEnabled() {
            return this.csvMetricsReporterEnabled;
        }

        public Properties producerProps() {
            return this.producerProps;
        }

        public int messageSendGapMs() {
            return this.messageSendGapMs;
        }

        public ProducerPerfConfig(String[] args) {
            super(args);
            Object object;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicsOpt(), this.brokerListOpt(), this.numMessagesOpt()}));
            this.topicsStr = this.options().valueOf(this.topicsOpt());
            this.topics = this.topicsStr().split(",");
            this.numMessages = this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = this.options().valueOf(this.reportingIntervalOpt());
            this.dateFormat = new SimpleDateFormat(this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has(this.hideHeaderOpt());
            this.brokerList = this.options().valueOf(this.brokerListOpt());
            ToolsUtils$.MODULE$.validatePortOrDie(this.parser(), this.brokerList());
            this.messageSize = this.options().valueOf(this.messageSizeOpt());
            this.isFixedSize = !this.options().has(this.varyMessageSizeOpt());
            this.isSync = this.options().has(this.syncOpt());
            this.batchSize = this.options().valueOf(this.batchSizeOpt());
            this.numThreads = this.options().valueOf(this.numThreadsOpt());
            this.compressionCodec = CompressionCodec$.MODULE$.getCompressionCodec(this.options().valueOf(this.compressionCodecOpt()));
            this.seqIdMode = this.options().has(this.initialMessageIdOpt());
            this.initialMessageId = 0;
            if (this.seqIdMode()) {
                this.initialMessageId_$eq(this.options().valueOf(this.initialMessageIdOpt()));
            }
            this.producerRequestTimeoutMs = this.options().valueOf(this.producerRequestTimeoutMsOpt());
            this.producerRequestRequiredAcks = this.options().valueOf(this.producerRequestRequiredAcksOpt());
            this.producerNumRetries = this.options().valueOf(this.producerNumRetriesOpt());
            this.producerRetryBackoffMs = this.options().valueOf(this.producerRetryBackOffMsOpt());
            this.useNewProducer = this.options().has(this.useNewProducerOpt());
            this.csvMetricsReporterEnabled = this.options().has(this.csvMetricsReporterEnabledOpt());
            Properties properties = this.producerProps = this.options().has(this.producerConfigOpt()) ? Utils.loadProps(this.options().valueOf(this.producerConfigOpt())) : new Properties();
            if (this.csvMetricsReporterEnabled()) {
                Properties props = new Properties();
                props.put("kafka.metrics.polling.interval.secs", "1");
                props.put("kafka.metrics.reporters", "kafka.metrics.KafkaCSVMetricsReporter");
                Object object2 = this.options().has(this.metricsDirectoryOpt()) ? props.put("kafka.csv.metrics.dir", this.options().valueOf(this.metricsDirectoryOpt())) : props.put("kafka.csv.metrics.dir", "kafka_metrics");
                props.put("kafka.csv.metrics.reporter.enabled", "true");
                VerifiableProperties verifiableProps = new VerifiableProperties(props);
                object = KafkaMetricsReporter$.MODULE$.startReporters(verifiableProps);
            } else {
                object = BoxedUnit.UNIT;
            }
            this.messageSendGapMs = this.options().valueOf(this.messageSendGapMsOpt());
        }
    }

    public static class ProducerThread
    implements Runnable {
        private final int threadId;
        private final ProducerPerfConfig config;
        private final AtomicLong totalBytesSent;
        private final AtomicLong totalMessagesSent;
        private final CountDownLatch allDone;
        private final Random rand;
        private final int seqIdNumDigit;
        private final long messagesPerThread;
        private final Properties props;
        private final BaseProducer producer;
        private final String SEP;
        private final String messageIdLabel;
        private final String threadIdLabel;
        private final String topicLabel;
        private String leftPaddedSeqId;

        public int threadId() {
            return this.threadId;
        }

        public ProducerPerfConfig config() {
            return this.config;
        }

        public AtomicLong totalBytesSent() {
            return this.totalBytesSent;
        }

        public AtomicLong totalMessagesSent() {
            return this.totalMessagesSent;
        }

        public CountDownLatch allDone() {
            return this.allDone;
        }

        public Random rand() {
            return this.rand;
        }

        public int seqIdNumDigit() {
            return this.seqIdNumDigit;
        }

        public long messagesPerThread() {
            return this.messagesPerThread;
        }

        public Properties props() {
            return this.props;
        }

        public BaseProducer producer() {
            return this.producer;
        }

        private String SEP() {
            return this.SEP;
        }

        private String messageIdLabel() {
            return this.messageIdLabel;
        }

        private String threadIdLabel() {
            return this.threadIdLabel;
        }

        private String topicLabel() {
            return this.topicLabel;
        }

        private String leftPaddedSeqId() {
            return this.leftPaddedSeqId;
        }

        private void leftPaddedSeqId_$eq(String x$1) {
            this.leftPaddedSeqId = x$1;
        }

        private byte[] generateMessageWithSeqId(String topic, long msgId, int msgSize) {
            this.leftPaddedSeqId_$eq(String.format("%0" + this.seqIdNumDigit() + "d", Predef$.MODULE$.long2Long(msgId)));
            String msgHeader = this.topicLabel() + this.SEP() + topic + this.SEP() + this.threadIdLabel() + this.SEP() + this.threadId() + this.SEP() + this.messageIdLabel() + this.SEP() + this.leftPaddedSeqId() + this.SEP();
            String seqMsgString = String.format("%1$-" + msgSize + "s", msgHeader).replace(' ', 'x');
            ProducerPerformance$.MODULE$.debug((Function0<String> & Serializable & scala.Serializable)() -> seqMsgString);
            return seqMsgString.getBytes(StandardCharsets.UTF_8);
        }

        private byte[] generateProducerData(String topic, long messageId) {
            byte[] byArray;
            int msgSize;
            int n = msgSize = this.config().isFixedSize() ? this.config().messageSize() : 1 + this.rand().nextInt(this.config().messageSize());
            if (this.config().seqIdMode()) {
                long seqId = (long)this.config().initialMessageId() + this.messagesPerThread() * (long)this.threadId() + messageId;
                byArray = this.generateMessageWithSeqId(topic, seqId, msgSize);
            } else {
                byArray = new byte[msgSize];
            }
            return byArray;
        }

        @Override
        public void run() {
            LongRef bytesSent = LongRef.create(0L);
            IntRef nSends = IntRef.create(0);
            LongRef i = LongRef.create(0L);
            ObjectRef<Object> message = ObjectRef.create(null);
            while (i.elem < this.messagesPerThread()) {
                try {
                    new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.config().topics())).foreach((Function1<String, Object> & Serializable & scala.Serializable)topic -> {
                        ProducerThread.$anonfun$run$1(this, bytesSent, nSends, i, message, topic);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    ProducerPerformance$.MODULE$.error((Function0<String> & Serializable & scala.Serializable)() -> "Error when sending message " + new String((byte[])message$1.elem, StandardCharsets.UTF_8), (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
                }
                ++i.elem;
            }
            try {
                this.producer().close();
            }
            catch (Throwable e) {
                ProducerPerformance$.MODULE$.error((Function0<String> & Serializable & scala.Serializable)() -> "Error when closing producer", (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
            }
            this.totalBytesSent().addAndGet(bytesSent.elem);
            this.totalMessagesSent().addAndGet(nSends.elem);
            this.allDone().countDown();
        }

        public static final /* synthetic */ void $anonfun$run$1(ProducerThread $this, LongRef bytesSent$1, IntRef nSends$1, LongRef i$1, ObjectRef message$1, String topic) {
            block0: {
                message$1.elem = $this.generateProducerData(topic, i$1.elem);
                $this.producer().send(topic, BigInteger.valueOf(i$1.elem).toByteArray(), (byte[])message$1.elem);
                bytesSent$1.elem += (long)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])message$1.elem)).size();
                ++nSends$1.elem;
                if ($this.config().messageSendGapMs() <= 0) break block0;
                Thread.sleep($this.config().messageSendGapMs());
            }
        }

        public ProducerThread(int threadId, ProducerPerfConfig config, AtomicLong totalBytesSent, AtomicLong totalMessagesSent, CountDownLatch allDone, Random rand) {
            BaseProducer baseProducer;
            this.threadId = threadId;
            this.config = config;
            this.totalBytesSent = totalBytesSent;
            this.totalMessagesSent = totalMessagesSent;
            this.allDone = allDone;
            this.rand = rand;
            this.seqIdNumDigit = 10;
            this.messagesPerThread = config.numMessages() / (long)config.numThreads();
            ProducerPerformance$.MODULE$.debug((Function0<String> & Serializable & scala.Serializable)() -> "Messages per thread = " + this.messagesPerThread());
            this.props = new Properties();
            if (config.useNewProducer()) {
                Implicits$.MODULE$.PropertiesOps(this.props()).$plus$plus$eq(config.producerProps());
                this.props().put("bootstrap.servers", config.brokerList());
                this.props().put("send.buffer.bytes", ((Object)BoxesRunTime.boxToInteger(65536)).toString());
                this.props().put("client.id", "producer-performance");
                this.props().put("acks", ((Object)BoxesRunTime.boxToInteger(config.producerRequestRequiredAcks())).toString());
                this.props().put("retries", ((Object)BoxesRunTime.boxToInteger(config.producerNumRetries())).toString());
                this.props().put("retry.backoff.ms", ((Object)BoxesRunTime.boxToInteger(config.producerRetryBackoffMs())).toString());
                this.props().put("compression.type", config.compressionCodec().name());
                this.props().put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
                this.props().put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
                baseProducer = new NewShinyProducer(this.props());
            } else {
                Object object;
                Implicits$.MODULE$.PropertiesOps(this.props()).$plus$plus$eq(config.producerProps());
                this.props().put("metadata.broker.list", config.brokerList());
                this.props().put("compression.codec", ((Object)BoxesRunTime.boxToInteger(config.compressionCodec().codec())).toString());
                this.props().put("send.buffer.bytes", ((Object)BoxesRunTime.boxToInteger(65536)).toString());
                if (!config.isSync()) {
                    this.props().put("producer.type", "async");
                    this.props().put("batch.num.messages", ((Object)BoxesRunTime.boxToInteger(config.batchSize())).toString());
                    object = this.props().put("queue.enqueue.timeout.ms", "-1");
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.props().put("client.id", "producer-performance");
                this.props().put("request.required.acks", ((Object)BoxesRunTime.boxToInteger(config.producerRequestRequiredAcks())).toString());
                this.props().put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger(config.producerRequestTimeoutMs())).toString());
                this.props().put("message.send.max.retries", ((Object)BoxesRunTime.boxToInteger(config.producerNumRetries())).toString());
                this.props().put("retry.backoff.ms", ((Object)BoxesRunTime.boxToInteger(config.producerRetryBackoffMs())).toString());
                this.props().put("serializer.class", DefaultEncoder.class.getName());
                this.props().put("key.serializer.class", NullEncoder.class.getName());
                baseProducer = new OldProducer(this.props());
            }
            this.producer = baseProducer;
            this.SEP = ":";
            this.messageIdLabel = "MessageID";
            this.threadIdLabel = "ThreadID";
            this.topicLabel = "Topic";
            this.leftPaddedSeqId = "";
        }
    }
}

