/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.tools.SimpleConsumerPerformance;
import kafka.utils.Exit$;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class SimpleConsumerPerformance$
implements LazyLogging {
    public static SimpleConsumerPerformance$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SimpleConsumerPerformance$();
    }

    private Logger logger$lzycompute() {
        SimpleConsumerPerformance$ simpleConsumerPerformance$ = this;
        synchronized (simpleConsumerPerformance$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public void main(String[] args) {
        block11: {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("WARNING: SimpleConsumerPerformance is deprecated and will be dropped in a future release following 0.11.0.0.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            SimpleConsumerPerformance.ConsumerPerfConfig config = new SimpleConsumerPerformance.ConsumerPerfConfig(args);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Starting SimpleConsumer...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!config.hideHeader()) {
                if (!config.showDetailedStats()) {
                    Predef$.MODULE$.println("start.time, end.time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
                } else {
                    Predef$.MODULE$.println("time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
                }
            }
            SimpleConsumer consumer = new SimpleConsumer(config.url().getHost(), config.url().getPort(), 30000, 2 * config.fetchSize(), config.clientId());
            TopicAndPartition topicAndPartition = new TopicAndPartition(config.topic(), config.partition());
            OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicAndPartition), new PartitionOffsetRequestInfo(config.fromLatest() ? OffsetRequest$.MODULE$.LatestTime() : OffsetRequest$.MODULE$.EarliestTime(), 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
            long offset = BoxesRunTime.unboxToLong(((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets().head());
            long startMs = System.currentTimeMillis();
            boolean done = false;
            long totalBytesRead = 0L;
            long totalMessagesRead = 0L;
            int consumedInterval = 0;
            long lastReportTime = startMs;
            long lastBytesRead = 0L;
            long lastMessagesRead = 0L;
            while (!done) {
                FetchRequest request2 = new FetchRequestBuilder().clientId(config.clientId()).addFetch(config.topic(), config.partition(), offset, config.fetchSize()).build();
                FetchResponse fetchResponse = consumer.fetch(request2);
                IntRef messagesRead = IntRef.create(0);
                IntRef bytesRead = IntRef.create(0);
                ByteBufferMessageSet messageSet = fetchResponse.messageSet(config.topic(), config.partition());
                messageSet.foreach((Function1<MessageAndOffset, Object> & Serializable & scala.Serializable)message -> {
                    SimpleConsumerPerformance$.$anonfun$main$1(messagesRead, bytesRead, message);
                    return BoxedUnit.UNIT;
                });
                if (messagesRead.elem == 0 || totalMessagesRead > config.numMessages()) {
                    done = true;
                } else {
                    offset = ((MessageAndOffset)messageSet.last()).nextOffset();
                }
                totalBytesRead += (long)bytesRead.elem;
                totalMessagesRead += (long)messagesRead.elem;
                if ((consumedInterval += messagesRead.elem) <= config.reportingInterval()) continue;
                if (config.showDetailedStats()) {
                    long reportTime = System.currentTimeMillis();
                    double elapsed = (double)(reportTime - lastReportTime) / 1000.0;
                    double totalMBRead = (double)(totalBytesRead - lastBytesRead) * 1.0 / (double)0x100000;
                    Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong(reportTime)), BoxesRunTime.boxToInteger(config.fetchSize()), BoxesRunTime.boxToDouble((double)totalBytesRead * 1.0 / (double)0x100000), BoxesRunTime.boxToDouble(totalMBRead / elapsed), BoxesRunTime.boxToLong(totalMessagesRead), BoxesRunTime.boxToDouble((double)(totalMessagesRead - lastMessagesRead) / elapsed)})));
                }
                lastReportTime = Time.SYSTEM.milliseconds();
                lastBytesRead = totalBytesRead;
                lastMessagesRead = totalMessagesRead;
                consumedInterval = 0;
            }
            long reportTime = System.currentTimeMillis();
            double elapsed = (double)(reportTime - startMs) / 1000.0;
            if (config.showDetailedStats()) break block11;
            double totalMBRead = (double)totalBytesRead * 1.0 / (double)0x100000;
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s, %s, %d, %.4f, %.4f, %d, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong(startMs)), config.dateFormat().format(BoxesRunTime.boxToLong(reportTime)), BoxesRunTime.boxToInteger(config.fetchSize()), BoxesRunTime.boxToDouble(totalMBRead), BoxesRunTime.boxToDouble(totalMBRead / elapsed), BoxesRunTime.boxToLong(totalMessagesRead), BoxesRunTime.boxToDouble((double)totalMessagesRead / elapsed)})));
        }
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    public static final /* synthetic */ void $anonfun$main$1(IntRef messagesRead$1, IntRef bytesRead$1, MessageAndOffset message) {
        ++messagesRead$1.elem;
        bytesRead$1.elem += message.message().payloadSize();
    }

    private SimpleConsumerPerformance$() {
        MODULE$ = this;
        LazyLogging.$init$(this);
    }
}

