/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.JsonArray;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005-baB\u0001\u0003!\u0003\r\t!\u0003\u0002\n\u0015N|gNV1mk\u0016T!a\u0001\u0003\u0002\t)\u001cxN\u001c\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003M\u0001\"a\u0003\u000b\n\u0005Ua!\u0001B+oSRDQa\u0006\u0001\u0007\u0012a\tAA\\8eKV\t\u0011\u0004\u0005\u0002\u001bG5\t1D\u0003\u0002\u001d;\u0005AA-\u0019;bE&tGM\u0003\u0002\u001f?\u00059!.Y2lg>t'B\u0001\u0011\"\u0003%1\u0017m\u001d;feblGNC\u0001#\u0003\r\u0019w.\\\u0005\u0003Im\u0011\u0001BS:p]:{G-\u001a\u0005\u0006M\u0001!\taJ\u0001\u0003i>,\"\u0001K\u0016\u0015\u0005%\"\u0004C\u0001\u0016,\u0019\u0001!Q\u0001L\u0013C\u00025\u0012\u0011\u0001V\t\u0003]E\u0002\"aC\u0018\n\u0005Ab!a\u0002(pi\"Lgn\u001a\t\u0003\u0017IJ!a\r\u0007\u0003\u0007\u0005s\u0017\u0010C\u00036K\u0001\u000fa'\u0001\u0006eK\u000e|G-\u001a&t_:\u00042a\u000e\u001d*\u001b\u0005\u0011\u0011BA\u001d\u0003\u0005)!UmY8eK*\u001bxN\u001c\u0005\u0006w\u0001!\t\u0001P\u0001\ti>,\u0015\u000e\u001e5feV\u0011Qh\u0015\u000b\u0003}Q\u0003BaP$K%:\u0011\u0001)\u0012\b\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\"\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005\u0019c\u0011a\u00029bG.\fw-Z\u0005\u0003\u0011&\u0013a!R5uQ\u0016\u0014(B\u0001$\r!\tYuJ\u0004\u0002M\u001bB\u0011\u0011\tD\u0005\u0003\u001d2\ta\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011a\n\u0004\t\u0003UM#Q\u0001\f\u001eC\u00025BQ!\u000e\u001eA\u0004U\u00032a\u000e\u001dS\u0011\u00159\u0006\u0001\"\u0001Y\u00031\t7OS:p]>\u0013'.Z2u+\u0005I\u0006CA\u001c[\u0013\tY&A\u0001\u0006Kg>twJ\u00196fGRDQ!\u0018\u0001\u0005\u0002y\u000b!#Y:Kg>twJ\u00196fGR|\u0005\u000f^5p]V\tq\fE\u0002\fAfK!!\u0019\u0007\u0003\r=\u0003H/[8o\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0003-\t7OS:p]\u0006\u0013(/Y=\u0016\u0003\u0015\u0004\"a\u000e4\n\u0005\u001d\u0014!!\u0003&t_:\f%O]1z\u0011\u0015I\u0007\u0001\"\u0001k\u0003E\t7OS:p]\u0006\u0013(/Y=PaRLwN\\\u000b\u0002WB\u00191\u0002Y3\t\u000b5\u0004A\u0011\t8\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u001c\t\u0003\u0017AL!!\u001d\u0007\u0003\u0007%sG\u000fC\u0003t\u0001\u0011\u0005C/\u0001\u0004fcV\fGn\u001d\u000b\u0003kb\u0004\"a\u0003<\n\u0005]d!a\u0002\"p_2,\u0017M\u001c\u0005\u0006sJ\u0004\r!M\u0001\u0002C\")1\u0010\u0001C!y\u0006AAo\\*ue&tw\rF\u0001K\u000f\u0015q(\u0001#\u0001\u0000\u0003%Q5o\u001c8WC2,X\rE\u00028\u0003\u00031a!\u0001\u0002\t\u0002\u0005\r1cAA\u0001\u0015!A\u0011qAA\u0001\t\u0003\tI!\u0001\u0004=S:LGO\u0010\u000b\u0002\u007f\"A\u0011QBA\u0001\t\u0003\ty!A\u0003baBd\u0017\u0010\u0006\u0003\u0002\u0012\u0005M\u0001CA\u001c\u0001\u0011\u00199\u00121\u0002a\u00013\u00199\u0011qCA\u0001\t\u0005e!A\u0004\"bg&\u001c'j]8o-\u0006dW/Z\n\u0006\u0003+Q\u0011\u0011\u0003\u0005\n/\u0005U!Q1A\u0005\u0012aA!\"a\b\u0002\u0016\t\u0005\t\u0015!\u0003\u001a\u0003\u0015qw\u000eZ3!\u0011%\t9!!\u0006\u0005\u0002\t\t\u0019\u0003\u0006\u0003\u0002&\u0005%\u0002\u0003BA\u0014\u0003+i!!!\u0001\t\r]\t\t\u00031\u0001\u001a\u0001")
public interface JsonValue {
    public static JsonValue apply(JsonNode jsonNode) {
        return JsonValue$.MODULE$.apply(jsonNode);
    }

    public JsonNode node();

    default public <T> T to(DecodeJson<T> decodeJson) {
        return decodeJson.decode(this.node());
    }

    default public <T> Either<String, T> toEither(DecodeJson<T> decodeJson) {
        return decodeJson.decodeEither(this.node());
    }

    default public JsonObject asJsonObject() {
        return (JsonObject)this.asJsonObjectOption().getOrElse((Function0<Nothing$> & java.io.Serializable & Serializable)() -> {
            throw new JsonMappingException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected JSON object, received ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.node()})));
        });
    }

    default public Option<JsonObject> asJsonObjectOption() {
        Option option;
        JsonValue jsonValue = this;
        if (jsonValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            option = new Some<JsonObject>(jsonObject);
        } else {
            Option option2;
            JsonNode jsonNode = this.node();
            if (jsonNode instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                option2 = new Some<JsonObject>(new JsonObject(objectNode));
            } else {
                option2 = None$.MODULE$;
            }
            option = option2;
        }
        return option;
    }

    default public JsonArray asJsonArray() {
        return (JsonArray)this.asJsonArrayOption().getOrElse((Function0<Nothing$> & java.io.Serializable & Serializable)() -> {
            throw new JsonMappingException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected JSON array, received ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.node()})));
        });
    }

    default public Option<JsonArray> asJsonArrayOption() {
        Option option;
        JsonValue jsonValue = this;
        if (jsonValue instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            option = new Some<JsonArray>(jsonArray);
        } else {
            Option option2;
            JsonNode jsonNode = this.node();
            if (jsonNode instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                option2 = new Some<JsonArray>(new JsonArray(arrayNode));
            } else {
                option2 = None$.MODULE$;
            }
            option = option2;
        }
        return option;
    }

    default public int hashCode() {
        return this.node().hashCode();
    }

    default public boolean equals(Object a) {
        boolean bl;
        Object object = a;
        if (object instanceof JsonValue) {
            JsonValue jsonValue = (JsonValue)object;
            JsonNode jsonNode = this.node();
            JsonNode jsonNode2 = jsonValue.node();
            bl = !(jsonNode != null ? !((Object)jsonNode).equals(jsonNode2) : jsonNode2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    default public String toString() {
        return this.node().toString();
    }

    public static void $init$(JsonValue $this) {
    }

    public static class BasicJsonValue
    implements JsonValue {
        private final JsonNode node;

        @Override
        public <T> T to(DecodeJson<T> decodeJson) {
            return (T)((JsonValue)this).to(decodeJson);
        }

        @Override
        public <T> Either<String, T> toEither(DecodeJson<T> decodeJson) {
            return ((JsonValue)this).toEither(decodeJson);
        }

        @Override
        public JsonObject asJsonObject() {
            return ((JsonValue)this).asJsonObject();
        }

        @Override
        public Option<JsonObject> asJsonObjectOption() {
            return ((JsonValue)this).asJsonObjectOption();
        }

        @Override
        public JsonArray asJsonArray() {
            return ((JsonValue)this).asJsonArray();
        }

        @Override
        public Option<JsonArray> asJsonArrayOption() {
            return ((JsonValue)this).asJsonArrayOption();
        }

        @Override
        public int hashCode() {
            return ((JsonValue)this).hashCode();
        }

        @Override
        public boolean equals(Object a) {
            return ((JsonValue)this).equals(a);
        }

        @Override
        public String toString() {
            return ((JsonValue)this).toString();
        }

        @Override
        public JsonNode node() {
            return this.node;
        }

        public BasicJsonValue(JsonNode node) {
            this.node = node;
            JsonValue.$init$(this);
        }
    }
}

