/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.connector;

import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;

public abstract class ConnectRecord<R extends ConnectRecord<R>> {
    private final String topic;
    private final Integer kafkaPartition;
    private final Schema keySchema;
    private final Object key;
    private final Schema valueSchema;
    private final Object value;
    private final Long timestamp;
    private final Headers headers;

    public ConnectRecord(String topic, Integer kafkaPartition, Schema keySchema, Object key, Schema valueSchema, Object value, Long timestamp) {
        this(topic, kafkaPartition, keySchema, key, valueSchema, value, timestamp, new ConnectHeaders());
    }

    public ConnectRecord(String topic, Integer kafkaPartition, Schema keySchema, Object key, Schema valueSchema, Object value, Long timestamp, Iterable<Header> headers) {
        this.topic = topic;
        this.kafkaPartition = kafkaPartition;
        this.keySchema = keySchema;
        this.key = key;
        this.valueSchema = valueSchema;
        this.value = value;
        this.timestamp = timestamp;
        this.headers = headers instanceof ConnectHeaders ? (ConnectHeaders)headers : new ConnectHeaders(headers);
    }

    public String topic() {
        return this.topic;
    }

    public Integer kafkaPartition() {
        return this.kafkaPartition;
    }

    public Object key() {
        return this.key;
    }

    public Schema keySchema() {
        return this.keySchema;
    }

    public Object value() {
        return this.value;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public Headers headers() {
        return this.headers;
    }

    public abstract R newRecord(String var1, Integer var2, Schema var3, Object var4, Schema var5, Object var6, Long var7);

    public abstract R newRecord(String var1, Integer var2, Schema var3, Object var4, Schema var5, Object var6, Long var7, Iterable<Header> var8);

    public String toString() {
        return "ConnectRecord{topic='" + this.topic + '\'' + ", kafkaPartition=" + this.kafkaPartition + ", key=" + this.key + ", value=" + this.value + ", timestamp=" + this.timestamp + ", headers=" + this.headers + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectRecord that = (ConnectRecord)o;
        if (this.kafkaPartition != null ? !this.kafkaPartition.equals(that.kafkaPartition) : that.kafkaPartition != null) {
            return false;
        }
        if (this.topic != null ? !this.topic.equals(that.topic) : that.topic != null) {
            return false;
        }
        if (this.keySchema != null ? !this.keySchema.equals(that.keySchema) : that.keySchema != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.valueSchema != null ? !this.valueSchema.equals(that.valueSchema) : that.valueSchema != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        return Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result2 = this.topic != null ? this.topic.hashCode() : 0;
        result2 = 31 * result2 + (this.kafkaPartition != null ? this.kafkaPartition.hashCode() : 0);
        result2 = 31 * result2 + (this.keySchema != null ? this.keySchema.hashCode() : 0);
        result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
        result2 = 31 * result2 + (this.valueSchema != null ? this.valueSchema.hashCode() : 0);
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        result2 = 31 * result2 + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result2 = 31 * result2 + this.headers.hashCode();
        return result2;
    }
}

