/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;

public class Struct {
    private final Schema schema;
    private final Object[] values;

    public Struct(Schema schema) {
        if (schema.type() != Schema.Type.STRUCT) {
            throw new DataException("Not a struct schema: " + schema);
        }
        this.schema = schema;
        this.values = new Object[schema.fields().size()];
    }

    public Schema schema() {
        return this.schema;
    }

    public Object get(String fieldName) {
        Field field2 = this.lookupField(fieldName);
        return this.get(field2);
    }

    public Object get(Field field2) {
        Object val = this.values[field2.index()];
        if (val == null && field2.schema().defaultValue() != null) {
            val = field2.schema().defaultValue();
        }
        return val;
    }

    public Object getWithoutDefault(String fieldName) {
        Field field2 = this.lookupField(fieldName);
        return this.values[field2.index()];
    }

    public Byte getInt8(String fieldName) {
        return (Byte)this.getCheckType(fieldName, Schema.Type.INT8);
    }

    public Short getInt16(String fieldName) {
        return (Short)this.getCheckType(fieldName, Schema.Type.INT16);
    }

    public Integer getInt32(String fieldName) {
        return (Integer)this.getCheckType(fieldName, Schema.Type.INT32);
    }

    public Long getInt64(String fieldName) {
        return (Long)this.getCheckType(fieldName, Schema.Type.INT64);
    }

    public Float getFloat32(String fieldName) {
        return (Float)this.getCheckType(fieldName, Schema.Type.FLOAT32);
    }

    public Double getFloat64(String fieldName) {
        return (Double)this.getCheckType(fieldName, Schema.Type.FLOAT64);
    }

    public Boolean getBoolean(String fieldName) {
        return (Boolean)this.getCheckType(fieldName, Schema.Type.BOOLEAN);
    }

    public String getString(String fieldName) {
        return (String)this.getCheckType(fieldName, Schema.Type.STRING);
    }

    public byte[] getBytes(String fieldName) {
        Object bytes = this.getCheckType(fieldName, Schema.Type.BYTES);
        if (bytes instanceof ByteBuffer) {
            return ((ByteBuffer)bytes).array();
        }
        return (byte[])bytes;
    }

    public <T> List<T> getArray(String fieldName) {
        return (List)this.getCheckType(fieldName, Schema.Type.ARRAY);
    }

    public <K, V> Map<K, V> getMap(String fieldName) {
        return (Map)this.getCheckType(fieldName, Schema.Type.MAP);
    }

    public Struct getStruct(String fieldName) {
        return (Struct)this.getCheckType(fieldName, Schema.Type.STRUCT);
    }

    public Struct put(String fieldName, Object value) {
        Field field2 = this.lookupField(fieldName);
        return this.put(field2, value);
    }

    public Struct put(Field field2, Object value) {
        if (null == field2) {
            throw new DataException("field cannot be null.");
        }
        ConnectSchema.validateValue(field2.name(), field2.schema(), value);
        this.values[field2.index()] = value;
        return this;
    }

    public void validate() {
        for (Field field2 : this.schema.fields()) {
            Schema fieldSchema = field2.schema();
            Object value = this.values[field2.index()];
            if (value == null && (fieldSchema.isOptional() || fieldSchema.defaultValue() != null)) continue;
            ConnectSchema.validateValue(field2.name(), fieldSchema, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Struct struct = (Struct)o;
        return Objects.equals(this.schema, struct.schema) && Arrays.deepEquals(this.values, struct.values);
    }

    public int hashCode() {
        return Objects.hash(this.schema, Arrays.deepHashCode(this.values));
    }

    private Field lookupField(String fieldName) {
        Field field2 = this.schema.field(fieldName);
        if (field2 == null) {
            throw new DataException(fieldName + " is not a valid field name");
        }
        return field2;
    }

    private Object getCheckType(String fieldName, Schema.Type type) {
        Field field2 = this.lookupField(fieldName);
        if (field2.schema().type() != type) {
            throw new DataException("Field '" + fieldName + "' is not of type " + (Object)((Object)type));
        }
        return this.values[field2.index()];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Struct{");
        boolean first = true;
        for (int i = 0; i < this.values.length; ++i) {
            Object value = this.values[i];
            if (value == null) continue;
            Field field2 = this.schema.fields().get(i);
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(field2.name()).append("=").append(value);
        }
        return sb.append("}").toString();
    }
}

