/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import org.apache.kafka.streams.KeyValue;
import org.junit.Assert;
import org.junit.Test;

public class KeyValueTest {
    @Test
    public void shouldHaveSaneEqualsAndHashCode() {
        KeyValue<String, Long> kv = KeyValue.pair("key1", 1L);
        KeyValue copyOfKV = KeyValue.pair(kv.key, kv.value);
        Assert.assertTrue((boolean)kv.equals(kv));
        Assert.assertTrue((kv.hashCode() == kv.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)kv.equals(copyOfKV));
        Assert.assertTrue((kv.hashCode() == copyOfKV.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((copyOfKV.hashCode() == kv.hashCode() ? 1 : 0) != 0);
        KeyValue copyOfCopyOfKV = KeyValue.pair(copyOfKV.key, copyOfKV.value);
        Assert.assertTrue((boolean)copyOfKV.equals(copyOfCopyOfKV));
        Assert.assertTrue((copyOfKV.hashCode() == copyOfCopyOfKV.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)kv.equals(copyOfCopyOfKV));
        Assert.assertTrue((kv.hashCode() == copyOfCopyOfKV.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"must be false for null", (boolean)kv.equals(null));
        Assert.assertFalse((String)"must be false if key is non-null and other key is null", (boolean)kv.equals(KeyValue.pair(null, kv.value)));
        Assert.assertFalse((String)"must be false if value is non-null and other value is null", (boolean)kv.equals(KeyValue.pair(kv.key, null)));
        KeyValue differentKeyType = KeyValue.pair(1L, kv.value);
        Assert.assertFalse((String)"must be false for different key types", (boolean)kv.equals(differentKeyType));
        KeyValue differentValueType = KeyValue.pair(kv.key, "anyString");
        Assert.assertFalse((String)"must be false for different value types", (boolean)kv.equals(differentValueType));
        KeyValue<Long, String> differentKeyValueTypes = KeyValue.pair(1L, "anyString");
        Assert.assertFalse((String)"must be false for different key and value types", (boolean)kv.equals(differentKeyValueTypes));
        Assert.assertFalse((String)"must be false for different types of objects", (boolean)kv.equals(new Object()));
        KeyValue differentKey = KeyValue.pair((String)kv.key + "suffix", kv.value);
        Assert.assertFalse((String)"must be false if key is different", (boolean)kv.equals(differentKey));
        Assert.assertFalse((String)"must be false if key is different", (boolean)differentKey.equals(kv));
        KeyValue differentValue = KeyValue.pair(kv.key, (Long)kv.value + 1L);
        Assert.assertFalse((String)"must be false if value is different", (boolean)kv.equals(differentValue));
        Assert.assertFalse((String)"must be false if value is different", (boolean)differentValue.equals(kv));
        KeyValue<String, Long> differentKeyAndValue = KeyValue.pair((String)kv.key + "suffix", (Long)kv.value + 1L);
        Assert.assertFalse((String)"must be false if key and value are different", (boolean)kv.equals(differentKeyAndValue));
        Assert.assertFalse((String)"must be false if key and value are different", (boolean)differentKeyAndValue.equals(kv));
    }
}

