/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.StreamPartitionAssignor;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamsConfigTest {
    private final Properties props = new Properties();
    private StreamsConfig streamsConfig;

    @Before
    public void setUp() {
        this.props.put("application.id", "streams-config-test");
        this.props.put("bootstrap.servers", "localhost:9092");
        this.props.put("default.key.serde", Serdes.String().getClass().getName());
        this.props.put("default.value.serde", Serdes.String().getClass().getName());
        this.props.put("key.deserializer.encoding", "UTF8");
        this.props.put("value.deserializer.encoding", "UTF-16");
        this.streamsConfig = new StreamsConfig(this.props);
    }

    @Test(expected=ConfigException.class)
    public void shouldThrowExceptionIfApplicationIdIsNotSet() {
        this.props.remove("application.id");
        new StreamsConfig(this.props);
    }

    @Test(expected=ConfigException.class)
    public void shouldThrowExceptionIfBootstrapServersIsNotSet() {
        this.props.remove("bootstrap.servers");
        new StreamsConfig(this.props);
    }

    @Test
    public void testGetProducerConfigs() {
        String clientId = "client";
        Map<String, Object> returnedProps = this.streamsConfig.getProducerConfigs("client");
        Assert.assertEquals((Object)returnedProps.get("client.id"), (Object)"client-producer");
        Assert.assertEquals((Object)returnedProps.get("linger.ms"), (Object)"100");
    }

    @Test
    public void testGetConsumerConfigs() {
        String groupId = "example-application";
        String clientId = "client";
        Map<String, Object> returnedProps = this.streamsConfig.getConsumerConfigs("example-application", "client");
        Assert.assertEquals((Object)returnedProps.get("client.id"), (Object)"client-consumer");
        Assert.assertEquals((Object)returnedProps.get("group.id"), (Object)"example-application");
        Assert.assertEquals((Object)returnedProps.get("max.poll.records"), (Object)"1000");
    }

    @Test
    public void consumerConfigMustContainStreamPartitionAssignorConfig() {
        this.props.put("replication.factor", (Object)42);
        this.props.put("num.standby.replicas", (Object)1);
        this.props.put("windowstore.changelog.additional.retention.ms", (Object)7L);
        this.props.put("application.server", "dummy:host");
        this.props.put("retries", (Object)10);
        this.props.put(StreamsConfig.adminClientPrefix("retries"), (Object)5);
        this.props.put(StreamsConfig.topicPrefix("segment.bytes"), (Object)100);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        String groupId = "example-application";
        String clientId = "client";
        Map<String, Object> returnedProps = streamsConfig.getConsumerConfigs("example-application", "client");
        Assert.assertEquals((Object)42, (Object)returnedProps.get("replication.factor"));
        Assert.assertEquals((Object)1, (Object)returnedProps.get("num.standby.replicas"));
        Assert.assertEquals((Object)StreamPartitionAssignor.class.getName(), (Object)returnedProps.get("partition.assignment.strategy"));
        Assert.assertEquals((Object)7L, (Object)returnedProps.get("windowstore.changelog.additional.retention.ms"));
        Assert.assertEquals((Object)"dummy:host", (Object)returnedProps.get("application.server"));
        Assert.assertEquals(null, (Object)returnedProps.get("retries"));
        Assert.assertEquals((Object)5, (Object)returnedProps.get(StreamsConfig.adminClientPrefix("retries")));
        Assert.assertEquals((Object)100, (Object)returnedProps.get(StreamsConfig.topicPrefix("segment.bytes")));
    }

    @Test
    public void consumerConfigMustUseAdminClientConfigForRetries() {
        this.props.put(StreamsConfig.adminClientPrefix("retries"), (Object)20);
        this.props.put("retries", (Object)10);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        String groupId = "example-application";
        String clientId = "client";
        Map<String, Object> returnedProps = streamsConfig.getConsumerConfigs("example-application", "client");
        Assert.assertEquals((Object)20, (Object)returnedProps.get(StreamsConfig.adminClientPrefix("retries")));
    }

    @Test
    public void testGetRestoreConsumerConfigs() {
        String clientId = "client";
        Map<String, Object> returnedProps = this.streamsConfig.getRestoreConsumerConfigs("client");
        Assert.assertEquals((Object)returnedProps.get("client.id"), (Object)"client-restore-consumer");
        Assert.assertNull((Object)returnedProps.get("group.id"));
    }

    @Test
    public void defaultSerdeShouldBeConfigured() {
        HashMap<String, String> serializerConfigs = new HashMap<String, String>();
        serializerConfigs.put("key.serializer.encoding", "UTF8");
        serializerConfigs.put("value.serializer.encoding", "UTF-16");
        Serializer<String> serializer = Serdes.String().serializer();
        String str = "my string for testing";
        String topic = "my topic";
        serializer.configure(serializerConfigs, true);
        Assert.assertEquals((String)"Should get the original string after serialization and deserialization with the configured encoding", (Object)"my string for testing", this.streamsConfig.defaultKeySerde().deserializer().deserialize("my topic", serializer.serialize("my topic", "my string for testing")));
        serializer.configure(serializerConfigs, false);
        Assert.assertEquals((String)"Should get the original string after serialization and deserialization with the configured encoding", (Object)"my string for testing", this.streamsConfig.defaultValueSerde().deserializer().deserialize("my topic", serializer.serialize("my topic", "my string for testing")));
    }

    @Test
    public void shouldSupportMultipleBootstrapServers() {
        List<String> expectedBootstrapServers = Arrays.asList("broker1:9092", "broker2:9092");
        String bootstrapServersString = Utils.join(expectedBootstrapServers, ",");
        Properties props = new Properties();
        props.put("application.id", "irrelevant");
        props.put("bootstrap.servers", bootstrapServersString);
        StreamsConfig config = new StreamsConfig(props);
        List<String> actualBootstrapServers = config.getList("bootstrap.servers");
        Assert.assertEquals(expectedBootstrapServers, actualBootstrapServers);
    }

    @Test
    public void shouldSupportPrefixedConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix("auto.offset.reset"), "earliest");
        this.props.put(StreamsConfig.consumerPrefix("metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientId");
        Assert.assertEquals((Object)"earliest", (Object)consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, (Object)consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportPrefixedRestoreConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix("metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Assert.assertEquals((Object)1, (Object)consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfConsumerConfig() {
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        this.props.put(StreamsConfig.consumerPrefix("interceptor.statsd.host"), "host");
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientId");
        Assert.assertEquals((Object)"host", (Object)consumerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfRestoreConsumerConfig() {
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        this.props.put(StreamsConfig.consumerPrefix("interceptor.statsd.host"), "host");
        Map<String, Object> consumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Assert.assertEquals((Object)"host", (Object)consumerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedPropertiesThatAreNotPartOfProducerConfig() {
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        this.props.put(StreamsConfig.producerPrefix("interceptor.statsd.host"), "host");
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)"host", (Object)producerConfigs.get("interceptor.statsd.host"));
    }

    @Test
    public void shouldSupportPrefixedProducerConfigs() {
        this.props.put(StreamsConfig.producerPrefix("buffer.memory"), (Object)10);
        this.props.put(StreamsConfig.producerPrefix("metrics.num.samples"), (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> configs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)10, (Object)configs.get("buffer.memory"));
        Assert.assertEquals((Object)1, (Object)configs.get("metrics.num.samples"));
    }

    @Test
    public void shouldBeSupportNonPrefixedConsumerConfigs() {
        this.props.put("auto.offset.reset", "earliest");
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientId");
        Assert.assertEquals((Object)"earliest", (Object)consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)1, (Object)consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldBeSupportNonPrefixedRestoreConsumerConfigs() {
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getRestoreConsumerConfigs("groupId");
        Assert.assertEquals((Object)1, (Object)consumerConfigs.get("metrics.num.samples"));
    }

    @Test
    public void shouldSupportNonPrefixedProducerConfigs() {
        this.props.put("buffer.memory", (Object)10);
        this.props.put("metrics.num.samples", (Object)1);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> configs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)10, (Object)configs.get("buffer.memory"));
        Assert.assertEquals((Object)1, (Object)configs.get("metrics.num.samples"));
    }

    @Test
    public void shouldForwardCustomConfigsWithNoPrefixToAllClients() {
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        this.props.put("custom.property.host", "host");
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientId");
        Map<String, Object> restoreConsumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Map<String, Object> adminConfigs = streamsConfig.getAdminConfigs("clientId");
        Assert.assertEquals((Object)"host", (Object)consumerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host", (Object)restoreConsumerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host", (Object)producerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host", (Object)adminConfigs.get("custom.property.host"));
    }

    @Test
    public void shouldOverrideNonPrefixedCustomConfigsWithPrefixedConfigs() {
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        this.props.put("custom.property.host", "host0");
        this.props.put(StreamsConfig.consumerPrefix("custom.property.host"), "host1");
        this.props.put(StreamsConfig.producerPrefix("custom.property.host"), "host2");
        this.props.put(StreamsConfig.adminClientPrefix("custom.property.host"), "host3");
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientId");
        Map<String, Object> restoreConsumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Map<String, Object> adminConfigs = streamsConfig.getAdminConfigs("clientId");
        Assert.assertEquals((Object)"host1", (Object)consumerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host1", (Object)restoreConsumerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host2", (Object)producerConfigs.get("custom.property.host"));
        Assert.assertEquals((Object)"host3", (Object)adminConfigs.get("custom.property.host"));
    }

    @Test
    public void shouldSupportNonPrefixedAdminConfigs() {
        this.props.put("retries", (Object)10);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> configs = streamsConfig.getAdminConfigs("clientId");
        Assert.assertEquals((Object)10, (Object)configs.get("retries"));
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfKeySerdeConfigFails() {
        this.props.put("default.key.serde", MisconfiguredSerde.class);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        streamsConfig.defaultKeySerde();
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfValueSerdeConfigFails() {
        this.props.put("default.value.serde", MisconfiguredSerde.class);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        streamsConfig.defaultValueSerde();
    }

    @Test
    public void shouldOverrideStreamsDefaultConsumerConfigs() {
        this.props.put(StreamsConfig.consumerPrefix("auto.offset.reset"), "latest");
        this.props.put(StreamsConfig.consumerPrefix("max.poll.records"), "10");
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientId");
        Assert.assertEquals((Object)"latest", (Object)consumerConfigs.get("auto.offset.reset"));
        Assert.assertEquals((Object)"10", (Object)consumerConfigs.get("max.poll.records"));
    }

    @Test
    public void shouldOverrideStreamsDefaultProducerConfigs() {
        this.props.put(StreamsConfig.producerPrefix("linger.ms"), "10000");
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertEquals((Object)"10000", (Object)producerConfigs.get("linger.ms"));
    }

    @Test
    public void shouldOverrideStreamsDefaultConsumerConifgsOnRestoreConsumer() {
        this.props.put(StreamsConfig.consumerPrefix("max.poll.records"), "10");
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getRestoreConsumerConfigs("clientId");
        Assert.assertEquals((Object)"10", (Object)consumerConfigs.get("max.poll.records"));
    }

    @Test
    public void shouldResetToDefaultIfConsumerAutoCommitIsOverridden() {
        this.props.put(StreamsConfig.consumerPrefix("enable.auto.commit"), "true");
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("a", "b");
        Assert.assertEquals((Object)"false", (Object)consumerConfigs.get("enable.auto.commit"));
    }

    @Test
    public void shouldResetToDefaultIfRestoreConsumerAutoCommitIsOverridden() {
        this.props.put(StreamsConfig.consumerPrefix("enable.auto.commit"), "true");
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getRestoreConsumerConfigs("client");
        Assert.assertEquals((Object)"false", (Object)consumerConfigs.get("enable.auto.commit"));
    }

    @Test
    public void shouldSetInternalLeaveGroupOnCloseConfigToFalseInConsumer() {
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientId");
        Assert.assertThat((Object)consumerConfigs.get("internal.leave.group.on.close"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldAcceptAtLeastOnce() {
        this.props.put("processing.guarantee", "at_least_once");
        new StreamsConfig(this.props);
    }

    @Test
    public void shouldAcceptExactlyOnce() {
        this.props.put("processing.guarantee", "exactly_once");
        new StreamsConfig(this.props);
    }

    @Test(expected=ConfigException.class)
    public void shouldThrowExceptionIfNotAtLestOnceOrExactlyOnce() {
        this.props.put("processing.guarantee", "bad_value");
        new StreamsConfig(this.props);
    }

    @Test
    public void shouldResetToDefaultIfConsumerIsolationLevelIsOverriddenIfEosEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("isolation.level", "anyValue");
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientId");
        Assert.assertThat((Object)((String)consumerConfigs.get("isolation.level")), (Matcher)IsEqual.equalTo((Object)IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT)));
    }

    @Test
    public void shouldAllowSettingConsumerIsolationLevelIfEosDisabled() {
        this.props.put("isolation.level", IsolationLevel.READ_UNCOMMITTED.name().toLowerCase(Locale.ROOT));
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientrId");
        Assert.assertThat((Object)((String)consumerConfigs.get("isolation.level")), (Matcher)IsEqual.equalTo((Object)IsolationLevel.READ_UNCOMMITTED.name().toLowerCase(Locale.ROOT)));
    }

    @Test
    public void shouldResetToDefaultIfProducerEnableIdempotenceIsOverriddenIfEosEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("enable.idempotence", "anyValue");
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertTrue((boolean)((Boolean)producerConfigs.get("enable.idempotence")));
    }

    @Test
    public void shouldAllowSettingProducerEnableIdempotenceIfEosDisabled() {
        this.props.put("enable.idempotence", (Object)false);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((Boolean)producerConfigs.get("enable.idempotence")), (Matcher)IsEqual.equalTo((Object)false));
    }

    @Test
    public void shouldResetToDefaultIfProducerMaxInFlightRequestPerConnectionsIsOverriddenIfEosEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("max.in.flight.requests.per.connection", "anyValue");
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((Integer)producerConfigs.get("max.in.flight.requests.per.connection")), (Matcher)IsEqual.equalTo((Object)1));
    }

    @Test
    public void shouldAllowSettingProducerMaxInFlightRequestPerConnectionsWhenEosDisabled() {
        this.props.put("max.in.flight.requests.per.connection", (Object)2);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((Integer)producerConfigs.get("max.in.flight.requests.per.connection")), (Matcher)IsEqual.equalTo((Object)2));
    }

    @Test
    public void shouldSetDifferentDefaultsIfEosEnabled() {
        this.props.put("processing.guarantee", "exactly_once");
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> consumerConfigs = streamsConfig.getConsumerConfigs("groupId", "clientId");
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((String)consumerConfigs.get("isolation.level")), (Matcher)IsEqual.equalTo((Object)IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT)));
        Assert.assertTrue((boolean)((Boolean)producerConfigs.get("enable.idempotence")));
        Assert.assertThat((Object)((Integer)producerConfigs.get("retries")), (Matcher)IsEqual.equalTo((Object)Integer.MAX_VALUE));
        Assert.assertThat((Object)((Integer)producerConfigs.get("max.in.flight.requests.per.connection")), (Matcher)IsEqual.equalTo((Object)1));
        Assert.assertThat((Object)streamsConfig.getLong("commit.interval.ms"), (Matcher)IsEqual.equalTo((Object)100L));
    }

    @Test
    public void shouldNotOverrideUserConfigRetriesIfExactlyOnceEnabled() {
        int numberOfRetries = 42;
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("retries", (Object)42);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Map<String, Object> producerConfigs = streamsConfig.getProducerConfigs("clientId");
        Assert.assertThat((Object)((Integer)producerConfigs.get("retries")), (Matcher)IsEqual.equalTo((Object)42));
    }

    @Test
    public void shouldNotOverrideUserConfigCommitIntervalMsIfExactlyOnceEnabled() {
        long commitIntervalMs = 73L;
        this.props.put("processing.guarantee", "exactly_once");
        this.props.put("commit.interval.ms", (Object)73L);
        StreamsConfig streamsConfig = new StreamsConfig(this.props);
        Assert.assertThat((Object)streamsConfig.getLong("commit.interval.ms"), (Matcher)IsEqual.equalTo((Object)73L));
    }

    @Test
    public void shouldBeBackwardsCompatibleWithDeprecatedConfigs() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("key.serde", Serdes.Double().getClass());
        props.put("value.serde", Serdes.Double().getClass());
        props.put("timestamp.extractor", MockTimestampExtractor.class);
        StreamsConfig config = new StreamsConfig(props);
        Assert.assertTrue((boolean)(config.defaultKeySerde() instanceof Serdes.DoubleSerde));
        Assert.assertTrue((boolean)(config.defaultValueSerde() instanceof Serdes.DoubleSerde));
        Assert.assertTrue((boolean)(config.defaultTimestampExtractor() instanceof MockTimestampExtractor));
    }

    @Test
    public void shouldUseNewConfigsWhenPresent() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("default.key.serde", Serdes.Long().getClass());
        props.put("default.value.serde", Serdes.Long().getClass());
        props.put("default.timestamp.extractor", MockTimestampExtractor.class);
        StreamsConfig config = new StreamsConfig(props);
        Assert.assertTrue((boolean)(config.defaultKeySerde() instanceof Serdes.LongSerde));
        Assert.assertTrue((boolean)(config.defaultValueSerde() instanceof Serdes.LongSerde));
        Assert.assertTrue((boolean)(config.defaultTimestampExtractor() instanceof MockTimestampExtractor));
    }

    @Test
    public void shouldUseCorrectDefaultsWhenNoneSpecified() {
        StreamsConfig config = new StreamsConfig(StreamsTestUtils.minimalStreamsConfig());
        Assert.assertTrue((boolean)(config.defaultKeySerde() instanceof Serdes.ByteArraySerde));
        Assert.assertTrue((boolean)(config.defaultValueSerde() instanceof Serdes.ByteArraySerde));
        Assert.assertTrue((boolean)(config.defaultTimestampExtractor() instanceof FailOnInvalidTimestamp));
    }

    @Test
    public void shouldSpecifyCorrectKeySerdeClassOnErrorUsingDeprecatedConfigs() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("key.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig(props);
        try {
            config.keySerde();
            Assert.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assert.assertEquals((Object)"Failed to configure key serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldSpecifyCorrectKeySerdeClassOnError() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("default.key.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig(props);
        try {
            config.keySerde();
            Assert.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assert.assertEquals((Object)"Failed to configure key serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldSpecifyCorrectValueSerdeClassOnErrorUsingDeprecatedConfigs() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("value.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig(props);
        try {
            config.valueSerde();
            Assert.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assert.assertEquals((Object)"Failed to configure value serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldSpecifyCorrectValueSerdeClassOnError() {
        Properties props = StreamsTestUtils.minimalStreamsConfig();
        props.put("default.value.serde", MisconfiguredSerde.class);
        StreamsConfig config = new StreamsConfig(props);
        try {
            config.valueSerde();
            Assert.fail((String)"Test should throw a StreamsException");
        }
        catch (StreamsException e) {
            Assert.assertEquals((Object)"Failed to configure value serde class org.apache.kafka.streams.StreamsConfigTest$MisconfiguredSerde", (Object)e.getMessage());
        }
    }

    public static class MockTimestampExtractor
    implements TimestampExtractor {
        @Override
        public long extract(ConsumerRecord<Object, Object> record, long previousTimestamp) {
            return 0L;
        }
    }

    static class MisconfiguredSerde
    implements Serde {
        MisconfiguredSerde() {
        }

        public void configure(Map configs, boolean isKey) {
            throw new RuntimeException("boom");
        }

        @Override
        public void close() {
        }

        public Serializer serializer() {
            return null;
        }

        public Deserializer deserializer() {
            return null;
        }
    }
}

