/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.AbstractJoinIntegrationTest;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.test.IntegrationTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={IntegrationTest.class})
@RunWith(value=Parameterized.class)
public class TableTableJoinIntegrationTest
extends AbstractJoinIntegrationTest {
    private KTable<Long, String> leftTable;
    private KTable<Long, String> rightTable;
    private final String expectedFinalJoinResult = "D-d";
    private final String expectedFinalMultiJoinResult = "D-d-d";
    private final String storeName = appID + "-store";
    private Materialized<Long, String, KeyValueStore<Bytes, byte[]>> materialized = Materialized.as(this.storeName).withKeySerde(Serdes.Long()).withValueSerde(Serdes.String()).withCachingDisabled().withLoggingDisabled();

    public TableTableJoinIntegrationTest(boolean cacheEnabled) {
        super(cacheEnabled);
    }

    @Before
    public void prepareTopology() throws InterruptedException {
        super.prepareEnvironment();
        appID = "table-table-join-integration-test";
        this.builder = new StreamsBuilder();
        this.leftTable = this.builder.table("inputTopicLeft");
        this.rightTable = this.builder.table("inputTopicRight");
    }

    @Test
    public void testInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner");
        if (this.cacheEnabled) {
            this.leftTable.join(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(false)).to("outputTopic");
            this.runTest("D-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList("A-a"), Collections.singletonList("B-a"), Collections.singletonList("B-b"), Collections.singletonList(null), null, null, Collections.singletonList("C-c"), Collections.singletonList(null), null, null, null, Collections.singletonList("D-d"));
            this.leftTable.join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-left");
        if (this.cacheEnabled) {
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(false)).to("outputTopic");
            this.runTest("D-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, Collections.singletonList("A-null"), Collections.singletonList("A-a"), Collections.singletonList("B-a"), Collections.singletonList("B-b"), Collections.singletonList(null), null, Collections.singletonList("C-null"), Collections.singletonList("C-c"), Collections.singletonList("C-null"), Collections.singletonList(null), null, null, Collections.singletonList("D-d"));
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-outer");
        if (this.cacheEnabled) {
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(false)).to("outputTopic");
            this.runTest("D-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, Collections.singletonList("A-null"), Collections.singletonList("A-a"), Collections.singletonList("B-a"), Collections.singletonList("B-b"), Collections.singletonList("null-b"), Collections.singletonList(null), Collections.singletonList("C-null"), Collections.singletonList("C-c"), Collections.singletonList("C-null"), Collections.singletonList(null), null, Collections.singletonList("null-d"), Collections.singletonList("D-d"));
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-inner");
        if (this.cacheEnabled) {
            this.leftTable.join(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(true)).to("outputTopic");
            this.runTest("D-d-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Arrays.asList("A-a-a", "A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("B-b-b", "B-b-b"), Collections.singletonList(null), null, null, Arrays.asList("C-c-c", "C-c-c"), null, null, null, null, Collections.singletonList("D-d-d"));
            this.leftTable.join(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-left");
        if (this.cacheEnabled) {
            this.leftTable.join(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(true)).to("outputTopic");
            this.runTest("D-d-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Arrays.asList("A-a-a", "A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("B-b-b", "B-b-b"), Collections.singletonList(null), null, null, Arrays.asList("C-c-c", "C-c-c"), Collections.singletonList(null), null, null, null, Collections.singletonList("D-d-d"));
            this.leftTable.join(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-outer");
        if (this.cacheEnabled) {
            this.leftTable.join(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(true)).to("outputTopic");
            this.runTest("D-d-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Arrays.asList("A-a-a", "A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("B-b-b", "B-b-b"), Collections.singletonList("null-b"), Collections.singletonList(null), null, Arrays.asList("C-c-c", "C-c-c"), Arrays.asList(null, null), null, null, null, Arrays.asList("null-d", "D-d-d"));
            this.leftTable.join(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-inner");
        if (this.cacheEnabled) {
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(true)).to("outputTopic");
            this.runTest("D-d-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Arrays.asList("A-a-a", "A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("B-b-b", "B-b-b"), Collections.singletonList(null), null, null, Arrays.asList("C-c-c", "C-c-c"), Collections.singletonList(null), null, null, null, Collections.singletonList("D-d-d"));
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-left");
        if (this.cacheEnabled) {
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(true)).to("outputTopic");
            this.runTest("D-d-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Arrays.asList("A-null-null", "A-a-a", "A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("B-b-b", "B-b-b"), Collections.singletonList(null), null, null, Arrays.asList("C-null-null", "C-c-c", "C-c-c"), Arrays.asList("C-null-null", "C-null-null"), Collections.singletonList(null), null, null, Collections.singletonList("D-d-d"));
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-outer");
        if (this.cacheEnabled) {
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(true)).to("outputTopic");
            this.runTest("D-d-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Arrays.asList("A-null-null", "A-a-a", "A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("B-b-b", "B-b-b"), Collections.singletonList("null-b"), Collections.singletonList(null), null, Arrays.asList("C-null-null", "C-c-c", "C-c-c"), Arrays.asList("C-null-null", "C-null-null"), Collections.singletonList(null), null, null, Arrays.asList("null-d", "D-d-d"));
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-inner");
        if (this.cacheEnabled) {
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(true)).to("outputTopic");
            this.runTest("D-d-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Arrays.asList("A-a-a", "A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("B-b-b", "B-b-b"), Collections.singletonList("null-b-b"), null, null, Arrays.asList("C-c-c", "C-c-c"), Collections.singletonList(null), null, null, Arrays.asList("null-d-d", "null-d-d"), Collections.singletonList("D-d-d"));
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-left");
        if (this.cacheEnabled) {
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(true)).to("outputTopic");
            this.runTest("D-d-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Arrays.asList("A-null-null", "A-a-a", "A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("B-b-b", "B-b-b"), Collections.singletonList("null-b-b"), Collections.singletonList(null), null, Arrays.asList("C-null-null", "C-c-c", "C-c-c"), Arrays.asList("C-null-null", "C-null-null"), Collections.singletonList(null), null, Arrays.asList("null-d-d", "null-d-d"), Collections.singletonList("D-d-d"));
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-outer");
        if (this.cacheEnabled) {
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek(new CountingPeek(true)).to("outputTopic");
            this.runTest("D-d-d", this.storeName);
        } else {
            List<List<String>> expectedResult = Arrays.asList(null, null, null, Arrays.asList("A-null-null", "A-a-a", "A-a-a"), Collections.singletonList("B-a-a"), Arrays.asList("B-b-b", "B-b-b"), Collections.singletonList("null-b-b"), Arrays.asList(null, null), null, Arrays.asList("C-null-null", "C-c-c", "C-c-c"), Arrays.asList("C-null-null", "C-null-null"), Collections.singletonList(null), null, null, Arrays.asList("null-d-d", "null-d-d", "D-d-d"));
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    private final class CountingPeek
    implements ForeachAction<Long, String> {
        private final String expected;

        CountingPeek(boolean multiJoin) {
            this.expected = multiJoin ? "D-d-d" : "D-d";
        }

        @Override
        public void apply(Long key, String value) {
            boolean ret;
            ++TableTableJoinIntegrationTest.this.numRecordsExpected;
            if (!this.expected.equals(value) || !(ret = TableTableJoinIntegrationTest.this.finalResultReached.compareAndSet(false, true))) {
                // empty if block
            }
        }
    }
}

