/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.MockTime;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.integration.utils.KafkaEmbedded;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;

public class EmbeddedKafkaCluster
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKafkaCluster.class);
    private static final int DEFAULT_BROKER_PORT = 0;
    private static final int TOPIC_CREATION_TIMEOUT = 30000;
    private static final int TOPIC_DELETION_TIMEOUT = 30000;
    private EmbeddedZookeeper zookeeper = null;
    private final KafkaEmbedded[] brokers;
    private ZkUtils zkUtils = null;
    private final Properties brokerConfig;
    public final MockTime time;

    public EmbeddedKafkaCluster(int numBrokers) {
        this(numBrokers, new Properties());
    }

    public EmbeddedKafkaCluster(int numBrokers, Properties brokerConfig) {
        this(numBrokers, brokerConfig, System.currentTimeMillis());
    }

    public EmbeddedKafkaCluster(int numBrokers, Properties brokerConfig, long mockTimeMillisStart) {
        this(numBrokers, brokerConfig, mockTimeMillisStart, System.nanoTime());
    }

    public EmbeddedKafkaCluster(int numBrokers, Properties brokerConfig, long mockTimeMillisStart, long mockTimeNanoStart) {
        this.brokers = new KafkaEmbedded[numBrokers];
        this.brokerConfig = brokerConfig;
        this.time = new MockTime(mockTimeMillisStart, mockTimeNanoStart);
    }

    public void start() throws IOException, InterruptedException {
        log.debug("Initiating embedded Kafka cluster startup");
        log.debug("Starting a ZooKeeper instance");
        this.zookeeper = new EmbeddedZookeeper();
        log.debug("ZooKeeper instance is running at {}", (Object)this.zKConnectString());
        this.zkUtils = ZkUtils.apply(this.zKConnectString(), 30000, 30000, JaasUtils.isZkSecurityEnabled());
        this.brokerConfig.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zKConnectString());
        this.brokerConfig.put(KafkaConfig$.MODULE$.PortProp(), (Object)0);
        this.putIfAbsent(this.brokerConfig, KafkaConfig$.MODULE$.DeleteTopicEnableProp(), true);
        this.putIfAbsent(this.brokerConfig, KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), 0x200000L);
        this.putIfAbsent(this.brokerConfig, KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), 0);
        this.putIfAbsent(this.brokerConfig, KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), 0);
        this.putIfAbsent(this.brokerConfig, KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), (short)1);
        this.putIfAbsent(this.brokerConfig, KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), true);
        for (int i = 0; i < this.brokers.length; ++i) {
            this.brokerConfig.put(KafkaConfig$.MODULE$.BrokerIdProp(), (Object)i);
            log.debug("Starting a Kafka instance on port {} ...", (Object)this.brokerConfig.getProperty(KafkaConfig$.MODULE$.PortProp()));
            this.brokers[i] = new KafkaEmbedded(this.brokerConfig, this.time);
            log.debug("Kafka instance is running at {}, connected to ZooKeeper at {}", (Object)this.brokers[i].brokerList(), (Object)this.brokers[i].zookeeperConnect());
        }
    }

    private void putIfAbsent(Properties props, String propertyKey, Object propertyValue) {
        if (!props.containsKey(propertyKey)) {
            this.brokerConfig.put(propertyKey, propertyValue);
        }
    }

    private void stop() {
        for (KafkaEmbedded broker : this.brokers) {
            broker.stop();
        }
        this.zkUtils.close();
        this.zookeeper.shutdown();
    }

    public String zKConnectString() {
        return "localhost:" + this.zookeeper.port();
    }

    public String bootstrapServers() {
        return this.brokers[0].brokerList();
    }

    protected void before() throws Throwable {
        this.start();
    }

    protected void after() {
        this.stop();
    }

    public void createTopics(String ... topics) throws InterruptedException {
        for (String topic : topics) {
            this.createTopic(topic, 1, 1, new Properties());
        }
    }

    public void createTopic(String topic) throws InterruptedException {
        this.createTopic(topic, 1, 1, new Properties());
    }

    public void createTopic(String topic, int partitions, int replication) throws InterruptedException {
        this.createTopic(topic, partitions, replication, new Properties());
    }

    public void createTopic(String topic, int partitions, int replication, Properties topicConfig) throws InterruptedException {
        this.brokers[0].createTopic(topic, partitions, replication, topicConfig);
        ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
        for (int partition = 0; partition < partitions; ++partition) {
            topicPartitions.add(new TopicPartition(topic, partition));
        }
        IntegrationTestUtils.waitForTopicPartitions(this.brokers(), topicPartitions, 30000L);
    }

    public void deleteTopic(String topic) throws InterruptedException {
        this.deleteTopicsAndWait(-1L, topic);
    }

    public void deleteTopicAndWait(String topic) throws InterruptedException {
        this.deleteTopicsAndWait(30000L, topic);
    }

    public void deleteTopicAndWait(long timeoutMs, String topic) throws InterruptedException {
        this.deleteTopicsAndWait(timeoutMs, topic);
    }

    public void deleteTopics(String ... topics) throws InterruptedException {
        this.deleteTopicsAndWait(-1L, topics);
    }

    public void deleteTopicsAndWait(String ... topics) throws InterruptedException {
        this.deleteTopicsAndWait(30000L, topics);
    }

    public void deleteTopicsAndWait(long timeoutMs, String ... topics) throws InterruptedException {
        for (String topic : topics) {
            try {
                this.brokers[0].deleteTopic(topic);
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                // empty catch block
            }
        }
        if (timeoutMs > 0L) {
            TestUtils.waitForCondition((TestCondition)new TopicsDeletedCondition(topics), (long)timeoutMs, (String)("Topics not deleted after " + timeoutMs + " milli seconds."));
        }
    }

    public void deleteAndRecreateTopics(String ... topics) throws InterruptedException {
        this.deleteTopicsAndWait(30000L, topics);
        this.createTopics(topics);
    }

    public void deleteAndRecreateTopics(long timeoutMs, String ... topics) throws InterruptedException {
        this.deleteTopicsAndWait(timeoutMs, topics);
        this.createTopics(topics);
    }

    public void waitForRemainingTopics(long timeoutMs, String ... topics) throws InterruptedException {
        TestUtils.waitForCondition((TestCondition)new TopicsRemainingCondition(topics), (long)timeoutMs, (String)("Topics are not expected after " + timeoutMs + " milli seconds."));
    }

    private List<KafkaServer> brokers() {
        ArrayList<KafkaServer> servers = new ArrayList<KafkaServer>();
        for (KafkaEmbedded broker : this.brokers) {
            servers.add(broker.kafkaServer());
        }
        return servers;
    }

    private final class TopicsRemainingCondition
    implements TestCondition {
        final Set<String> remainingTopics = new HashSet<String>();

        private TopicsRemainingCondition(String ... topics) {
            Collections.addAll(this.remainingTopics, topics);
        }

        public boolean conditionMet() {
            HashSet<String> allTopics = new HashSet<String>();
            allTopics.addAll(JavaConversions.seqAsJavaList(EmbeddedKafkaCluster.this.zkUtils.getAllTopics()));
            return allTopics.equals(this.remainingTopics);
        }
    }

    private final class TopicsDeletedCondition
    implements TestCondition {
        final Set<String> deletedTopics = new HashSet<String>();

        private TopicsDeletedCondition(String ... topics) {
            Collections.addAll(this.deletedTopics, topics);
        }

        public boolean conditionMet() {
            HashSet<String> allTopics = new HashSet<String>();
            allTopics.addAll(JavaConversions.seqAsJavaList(EmbeddedKafkaCluster.this.zkUtils.getAllTopics()));
            return !allTopics.removeAll(this.deletedTopics);
        }
    }
}

