/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.UnlimitedWindows;
import org.junit.Assert;
import org.junit.Test;

public class JoinWindowsTest {
    private static long anySize = 123L;
    private static long anyOtherSize = 456L;

    @Test
    public void shouldHaveSaneEqualsAndHashCode() {
        JoinWindows w1 = JoinWindows.of(anySize);
        JoinWindows w2 = JoinWindows.of(anySize);
        Assert.assertEquals((Object)w1, (Object)w1);
        Assert.assertEquals((long)w1.hashCode(), (long)w1.hashCode());
        Assert.assertEquals((Object)w1, (Object)w2);
        Assert.assertEquals((Object)w2, (Object)w1);
        Assert.assertEquals((long)w1.hashCode(), (long)w2.hashCode());
        JoinWindows w3 = JoinWindows.of(w2.afterMs).before(anyOtherSize);
        JoinWindows w4 = JoinWindows.of(anyOtherSize).after(w2.afterMs);
        Assert.assertEquals((Object)w3, (Object)w4);
        Assert.assertEquals((Object)w4, (Object)w3);
        Assert.assertEquals((long)w3.hashCode(), (long)w4.hashCode());
        Assert.assertNotEquals((String)"must be false for null", null, (Object)w1);
        Assert.assertNotEquals((String)"must be false for different window types", (Object)UnlimitedWindows.of(), (Object)w1);
        Assert.assertNotEquals((String)"must be false for different types", (Object)new Object(), (Object)w1);
        JoinWindows differentWindowSize = JoinWindows.of(w1.afterMs + 1L);
        Assert.assertNotEquals((String)"must be false when window sizes are different", (Object)differentWindowSize, (Object)w1);
        JoinWindows differentWindowSize2 = JoinWindows.of(w1.afterMs).after(w1.afterMs + 1L);
        Assert.assertNotEquals((String)"must be false when window sizes are different", (Object)differentWindowSize2, (Object)w1);
        JoinWindows differentWindowSize3 = JoinWindows.of(w1.afterMs).before(w1.beforeMs + 1L);
        Assert.assertNotEquals((String)"must be false when window sizes are different", (Object)differentWindowSize3, (Object)w1);
    }

    @Test
    public void validWindows() {
        JoinWindows.of(anyOtherSize).before(anySize).before(0L).before(-anySize).before(-anyOtherSize);
        JoinWindows.of(anyOtherSize).after(anySize).after(0L).after(-anySize).after(-anyOtherSize);
    }

    @Test(expected=IllegalArgumentException.class)
    public void timeDifferenceMustNotBeNegative() {
        JoinWindows.of(-1L);
    }

    @Test
    public void endTimeShouldNotBeBeforeStart() {
        JoinWindows windowSpec = JoinWindows.of(anySize);
        try {
            windowSpec.after(-anySize - 1L);
            Assert.fail((String)"window end time should not be before window start time");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void startTimeShouldNotBeAfterEnd() {
        JoinWindows windowSpec = JoinWindows.of(anySize);
        try {
            windowSpec.before(-anySize - 1L);
            Assert.fail((String)"window start time should not be after window end time");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void untilShouldSetMaintainDuration() {
        JoinWindows windowSpec = JoinWindows.of(anySize);
        long windowSize = windowSpec.size();
        Assert.assertEquals((long)windowSize, (long)windowSpec.until(windowSize).maintainMs());
    }

    @Test
    public void shouldUseWindowSizeForMaintainDurationWhenSizeLargerThanDefaultMaintainMs() {
        long size = 86400000L;
        JoinWindows windowSpec = JoinWindows.of(86400000L);
        long windowSize = windowSpec.size();
        Assert.assertEquals((long)windowSize, (long)windowSpec.maintainMs());
    }

    @Test
    public void retentionTimeMustNoBeSmallerThanWindowSize() {
        JoinWindows windowSpec = JoinWindows.of(anySize);
        long windowSize = windowSpec.size();
        try {
            windowSpec.until(windowSize - 1L);
            Assert.fail((String)"should not accept retention time smaller than window size");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

