/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.internals.GlobalKTableImpl;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.KTableSourceValueGetterSupplier;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.RocksDBKeyValueStoreSupplier;

@Deprecated
public class KStreamBuilder
extends TopologyBuilder {
    private final InternalStreamsBuilder internalStreamsBuilder;

    public KStreamBuilder() {
        this.internalStreamsBuilder = new InternalStreamsBuilder(this.internalTopologyBuilder);
    }

    private Topology.AutoOffsetReset translateAutoOffsetReset(TopologyBuilder.AutoOffsetReset resetPolicy) {
        if (resetPolicy == null) {
            return null;
        }
        return resetPolicy == TopologyBuilder.AutoOffsetReset.EARLIEST ? Topology.AutoOffsetReset.EARLIEST : Topology.AutoOffsetReset.LATEST;
    }

    public <K, V> KStream<K, V> stream(String ... topics) {
        return this.stream((TopologyBuilder.AutoOffsetReset)null, (TimestampExtractor)null, (Serde<K>)null, (Serde<V>)null, topics);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, String ... topics) {
        return this.stream(offsetReset, (TimestampExtractor)null, (Serde<K>)null, (Serde<V>)null, topics);
    }

    public <K, V> KStream<K, V> stream(Pattern topicPattern) {
        return this.stream(null, null, null, null, topicPattern);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, Pattern topicPattern) {
        return this.stream(offsetReset, null, null, null, topicPattern);
    }

    public <K, V> KStream<K, V> stream(Serde<K> keySerde, Serde<V> valSerde, String ... topics) {
        return this.stream(null, null, keySerde, valSerde, topics);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, Serde<K> keySerde, Serde<V> valSerde, String ... topics) {
        return this.stream(offsetReset, null, keySerde, valSerde, topics);
    }

    public <K, V> KStream<K, V> stream(TimestampExtractor timestampExtractor, Serde<K> keySerde, Serde<V> valSerde, String ... topics) {
        return this.stream(null, timestampExtractor, keySerde, valSerde, topics);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, Serde<K> keySerde, Serde<V> valSerde, String ... topics) {
        try {
            String name = this.newName("KSTREAM-SOURCE-");
            this.internalTopologyBuilder.addSource(this.translateAutoOffsetReset(offsetReset), name, timestampExtractor, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topics);
            return new KStreamImpl(this.internalStreamsBuilder, name, Collections.singleton(name), false);
        }
        catch (TopologyException e) {
            throw new TopologyBuilderException(e);
        }
    }

    public <K, V> KStream<K, V> stream(Serde<K> keySerde, Serde<V> valSerde, Pattern topicPattern) {
        return this.stream(null, null, keySerde, valSerde, topicPattern);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, Serde<K> keySerde, Serde<V> valSerde, Pattern topicPattern) {
        return this.stream(offsetReset, null, keySerde, valSerde, topicPattern);
    }

    public <K, V> KStream<K, V> stream(TimestampExtractor timestampExtractor, Serde<K> keySerde, Serde<V> valSerde, Pattern topicPattern) {
        return this.stream(null, timestampExtractor, keySerde, valSerde, topicPattern);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, Serde<K> keySerde, Serde<V> valSerde, Pattern topicPattern) {
        try {
            String name = this.newName("KSTREAM-SOURCE-");
            this.internalTopologyBuilder.addSource(this.translateAutoOffsetReset(offsetReset), name, timestampExtractor, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topicPattern);
            return new KStreamImpl(this.internalStreamsBuilder, name, Collections.singleton(name), false);
        }
        catch (TopologyException e) {
            throw new TopologyBuilderException(e);
        }
    }

    public <K, V> KTable<K, V> table(String topic, String queryableStoreName) {
        return this.table(null, null, null, null, topic, queryableStoreName);
    }

    public <K, V> KTable<K, V> table(String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        return this.table(null, null, null, null, topic, storeSupplier);
    }

    public <K, V> KTable<K, V> table(String topic) {
        return this.table(null, null, null, null, topic, (String)null);
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, String topic, String queryableStoreName) {
        return this.table(offsetReset, null, null, null, topic, queryableStoreName);
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        return this.table(offsetReset, null, null, null, topic, storeSupplier);
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, String topic) {
        return this.table(offsetReset, null, null, null, topic, (String)null);
    }

    public <K, V> KTable<K, V> table(TimestampExtractor timestampExtractor, String topic, String storeName) {
        return this.table(null, timestampExtractor, null, null, topic, storeName);
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, String topic, String storeName) {
        return this.table(offsetReset, timestampExtractor, null, null, topic, storeName);
    }

    public <K, V> KTable<K, V> table(Serde<K> keySerde, Serde<V> valSerde, String topic, String queryableStoreName) {
        return this.table(null, null, keySerde, valSerde, topic, queryableStoreName);
    }

    public <K, V> KTable<K, V> table(Serde<K> keySerde, Serde<V> valSerde, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        return this.table(null, null, keySerde, valSerde, topic, storeSupplier);
    }

    public <K, V> KTable<K, V> table(Serde<K> keySerde, Serde<V> valSerde, String topic) {
        return this.table(null, null, keySerde, valSerde, topic, (String)null);
    }

    private <K, V> KTable<K, V> doTable(TopologyBuilder.AutoOffsetReset offsetReset, Serde<K> keySerde, Serde<V> valSerde, TimestampExtractor timestampExtractor, String topic, StateStoreSupplier<KeyValueStore> storeSupplier, boolean isQueryable) {
        try {
            String source = this.newName("KSTREAM-SOURCE-");
            String name = this.newName("KTABLE-SOURCE-");
            KTableSource processorSupplier = new KTableSource(storeSupplier.name());
            this.internalTopologyBuilder.addSource(this.translateAutoOffsetReset(offsetReset), source, timestampExtractor, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topic);
            this.internalTopologyBuilder.addProcessor(name, processorSupplier, source);
            KTableImpl kTable = new KTableImpl(this.internalStreamsBuilder, name, processorSupplier, keySerde, valSerde, Collections.singleton(source), storeSupplier.name(), isQueryable);
            this.addStateStore(storeSupplier, name);
            this.connectSourceStoreAndTopic(storeSupplier.name(), topic);
            return kTable;
        }
        catch (TopologyException e) {
            throw new TopologyBuilderException(e);
        }
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, Serde<K> keySerde, Serde<V> valSerde, String topic, String queryableStoreName) {
        return this.table(offsetReset, null, keySerde, valSerde, topic, queryableStoreName);
    }

    public <K, V> KTable<K, V> table(TimestampExtractor timestampExtractor, Serde<K> keySerde, Serde<V> valSerde, String topic, String storeName) {
        return this.table(null, timestampExtractor, keySerde, valSerde, topic, storeName);
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, Serde<K> keySerde, Serde<V> valSerde, String topic, String queryableStoreName) {
        String internalStoreName = queryableStoreName != null ? queryableStoreName : this.newStoreName("KTABLE-SOURCE-");
        RocksDBKeyValueStoreSupplier<K, V> storeSupplier = new RocksDBKeyValueStoreSupplier<K, V>(internalStoreName, keySerde, valSerde, false, Collections.emptyMap(), true);
        return this.doTable(offsetReset, keySerde, valSerde, timestampExtractor, topic, storeSupplier, queryableStoreName != null);
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, Serde<K> keySerde, Serde<V> valSerde, String topic) {
        return this.table(offsetReset, null, keySerde, valSerde, topic, (String)null);
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, TimestampExtractor timestampExtractor, Serde<K> keySerde, Serde<V> valSerde, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doTable(offsetReset, keySerde, valSerde, timestampExtractor, topic, storeSupplier, true);
    }

    public <K, V> GlobalKTable<K, V> globalTable(String topic, String queryableStoreName) {
        return this.globalTable(null, null, null, topic, queryableStoreName);
    }

    public <K, V> GlobalKTable<K, V> globalTable(String topic) {
        return this.globalTable(null, null, null, topic, null);
    }

    public <K, V> GlobalKTable<K, V> globalTable(Serde<K> keySerde, Serde<V> valSerde, TimestampExtractor timestampExtractor, String topic, String queryableStoreName) {
        String internalStoreName = queryableStoreName != null ? queryableStoreName : this.newStoreName("KTABLE-SOURCE-");
        return this.doGlobalTable(keySerde, valSerde, timestampExtractor, topic, new RocksDBKeyValueStoreSupplier<K, V>(internalStoreName, keySerde, valSerde, false, Collections.emptyMap(), true));
    }

    public <K, V> GlobalKTable<K, V> globalTable(Serde<K> keySerde, Serde<V> valSerde, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        return this.doGlobalTable(keySerde, valSerde, null, topic, storeSupplier);
    }

    public <K, V> GlobalKTable<K, V> globalTable(Serde<K> keySerde, Serde<V> valSerde, String topic, String queryableStoreName) {
        return this.globalTable(keySerde, valSerde, null, topic, queryableStoreName);
    }

    private <K, V> GlobalKTable<K, V> doGlobalTable(Serde<K> keySerde, Serde<V> valSerde, TimestampExtractor timestampExtractor, String topic, StateStoreSupplier<KeyValueStore> storeSupplier) {
        try {
            Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
            String sourceName = this.newName("KSTREAM-SOURCE-");
            String processorName = this.newName("KTABLE-SOURCE-");
            KTableSource tableSource = new KTableSource(storeSupplier.name());
            Deserializer<K> keyDeserializer = keySerde == null ? null : keySerde.deserializer();
            Deserializer<V> valueDeserializer = valSerde == null ? null : valSerde.deserializer();
            this.internalTopologyBuilder.addGlobalStore(storeSupplier, sourceName, timestampExtractor, keyDeserializer, valueDeserializer, topic, processorName, tableSource);
            return new GlobalKTableImpl(new KTableSourceValueGetterSupplier(storeSupplier.name()));
        }
        catch (TopologyException e) {
            throw new TopologyBuilderException(e);
        }
    }

    public <K, V> GlobalKTable<K, V> globalTable(Serde<K> keySerde, Serde<V> valSerde, String topic) {
        return this.globalTable(keySerde, valSerde, null, topic, null);
    }

    public <K, V> KStream<K, V> merge(KStream<K, V> ... streams) {
        Objects.requireNonNull(streams, "streams can't be null");
        if (streams.length <= 1) {
            throw new IllegalArgumentException("Number of arguments required needs to be greater than one.");
        }
        try {
            KStream<K, V> mergedStream = streams[0];
            for (int i = 1; i < streams.length; ++i) {
                mergedStream = mergedStream.merge(streams[i]);
            }
            return mergedStream;
        }
        catch (TopologyException e) {
            throw new TopologyBuilderException(e);
        }
    }

    public String newName(String prefix) {
        return this.internalStreamsBuilder.newProcessorName(prefix);
    }

    public String newStoreName(String prefix) {
        return this.internalStreamsBuilder.newStoreName(prefix);
    }
}

