/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.junit.Test;

public class MaterializedTest {
    @Test
    public void shouldAllowValidTopicNamesAsStoreName() {
        Materialized.as("valid-name");
        Materialized.as("valid.name");
        Materialized.as("valid_name");
    }

    @Test(expected=InvalidTopicException.class)
    public void shouldNotAllowInvalidTopicNames() {
        Materialized.as("not:valid");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfWindowBytesStoreSupplierIsNull() {
        Materialized.as((WindowBytesStoreSupplier)null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfKeyValueBytesStoreSupplierIsNull() {
        Materialized.as((KeyValueBytesStoreSupplier)null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfSessionBytesStoreSupplierIsNull() {
        Materialized.as((SessionBytesStoreSupplier)null);
    }
}

