/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Printed;
import org.apache.kafka.streams.kstream.internals.PrintedInternal;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrintedTest {
    private final PrintStream originalSysOut = System.out;
    private final ByteArrayOutputStream sysOut = new ByteArrayOutputStream();
    private final Printed<String, Integer> sysOutPrinter = Printed.toSysOut();

    @Before
    public void before() {
        System.setOut(new PrintStream(this.sysOut));
    }

    @After
    public void after() {
        System.setOut(this.originalSysOut);
    }

    @Test
    public void shouldCreateProcessorThatPrintsToFile() throws IOException {
        File file = TestUtils.tempFile();
        ProcessorSupplier processorSupplier = new PrintedInternal(Printed.toFile(file.getPath())).build("processor");
        Processor<String, Integer> processor = processorSupplier.get();
        processor.process("hi", 1);
        processor.close();
        try (FileInputStream stream = new FileInputStream(file);){
            byte[] data = new byte[stream.available()];
            stream.read(data);
            Assert.assertThat((Object)new String(data, StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[processor]: hi, 1\n"));
        }
    }

    @Test
    public void shouldCreateProcessorThatPrintsToStdOut() throws UnsupportedEncodingException {
        ProcessorSupplier<String, Integer> supplier = new PrintedInternal<String, Integer>(this.sysOutPrinter).build("processor");
        supplier.get().process("good", 2);
        Assert.assertThat((Object)this.sysOut.toString(StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[processor]: good, 2\n"));
    }

    @Test
    public void shouldPrintWithLabel() throws UnsupportedEncodingException {
        Processor<String, Integer> processor = new PrintedInternal<String, Integer>(this.sysOutPrinter.withLabel("label")).build("processor").get();
        processor.process("hello", 3);
        Assert.assertThat((Object)this.sysOut.toString(StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[label]: hello, 3\n"));
    }

    @Test
    public void shouldPrintWithKeyValueMapper() throws UnsupportedEncodingException {
        Processor<String, Integer> processor = new PrintedInternal<String, Integer>(this.sysOutPrinter.withKeyValueMapper(new KeyValueMapper<String, Integer, String>(){

            @Override
            public String apply(String key, Integer value) {
                return String.format("%s -> %d", key, value);
            }
        })).build("processor").get();
        processor.process("hello", 1);
        Assert.assertThat((Object)this.sysOut.toString(StandardCharsets.UTF_8.name()), (Matcher)CoreMatchers.equalTo((Object)"[processor]: hello -> 1\n"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionIfFilePathIsNull() {
        Printed.toFile(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionIfMapperIsNull() {
        this.sysOutPrinter.withKeyValueMapper(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionIfLabelIsNull() {
        this.sysOutPrinter.withLabel(null);
    }

    @Test(expected=TopologyException.class)
    public void shouldThrowTopologyExceptionIfFilePathIsEmpty() {
        Printed.toFile("");
    }

    @Test(expected=TopologyException.class)
    public void shouldThrowTopologyExceptionIfFilePathDoesntExist() {
        Printed.toFile("/this/should/not/exist");
    }
}

