/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.streams.kstream.SessionWindows;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class SessionWindowsTest {
    @Test
    public void shouldSetWindowGap() {
        long anyGap = 42L;
        Assert.assertEquals((long)42L, (long)SessionWindows.with(42L).inactivityGap());
    }

    @Test
    public void shouldSetWindowRetentionTime() {
        long anyRetentionTime = 42L;
        Assert.assertEquals((long)42L, (long)SessionWindows.with(1L).until(42L).maintainMs());
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustNotBeNegative() {
        SessionWindows.with(-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustNotBeZero() {
        SessionWindows.with(0L);
    }

    @Test
    public void retentionTimeShouldBeGapIfGapIsLargerThanDefaultRetentionTime() {
        long windowGap = 172800000L;
        Assert.assertEquals((long)172800000L, (long)SessionWindows.with(172800000L).maintainMs());
    }

    @Test
    public void retentionTimeMustNotBeNegative() {
        SessionWindows windowSpec = SessionWindows.with(42L);
        try {
            windowSpec.until(41L);
            Assert.fail((String)"should not accept retention time smaller than gap");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldBeEqualWhenGapAndMaintainMsAreTheSame() {
        MatcherAssert.assertThat((Object)SessionWindows.with(5L), (Matcher)CoreMatchers.equalTo((Object)SessionWindows.with(5L)));
    }

    @Test
    public void shouldNotBeEqualWhenMaintainMsDifferent() {
        MatcherAssert.assertThat((Object)SessionWindows.with(5L), (Matcher)IsNot.not((Matcher)CoreMatchers.equalTo((Object)SessionWindows.with(5L).until(10L))));
    }

    @Test
    public void shouldNotBeEqualWhenGapIsDifferent() {
        MatcherAssert.assertThat((Object)SessionWindows.with(5L), (Matcher)IsNot.not((Matcher)CoreMatchers.equalTo((Object)SessionWindows.with(10L))));
    }
}

