/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.UnlimitedWindows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.Assert;
import org.junit.Test;

public class TimeWindowsTest {
    private static final long ANY_SIZE = 123L;

    @Test
    public void shouldSetWindowSize() {
        Assert.assertEquals((long)123L, (long)TimeWindows.of((long)123L).sizeMs);
    }

    @Test
    public void shouldSetWindowAdvance() {
        long anyAdvance = 4L;
        Assert.assertEquals((long)4L, (long)TimeWindows.of((long)123L).advanceBy((long)4L).advanceMs);
    }

    @Test
    public void shouldSetWindowRetentionTime() {
        Assert.assertEquals((long)123L, (long)TimeWindows.of(123L).until(123L).maintainMs());
    }

    @Test
    public void shouldUseWindowSizeAsRentitionTimeIfWindowSizeIsLargerThanDefaultRetentionTime() {
        long windowSize = 172800000L;
        Assert.assertEquals((long)172800000L, (long)TimeWindows.of(172800000L).maintainMs());
    }

    @Test
    public void shouldHaveSaneEqualsAndHashCode() {
        TimeWindows w1 = TimeWindows.of(123L);
        TimeWindows w2 = TimeWindows.of(w1.sizeMs);
        Assert.assertEquals((Object)w1, (Object)w1);
        Assert.assertEquals((long)w1.hashCode(), (long)w1.hashCode());
        Assert.assertEquals((Object)w1, (Object)w2);
        Assert.assertEquals((Object)w2, (Object)w1);
        Assert.assertEquals((long)w1.hashCode(), (long)w2.hashCode());
        TimeWindows w3 = TimeWindows.of(w2.sizeMs);
        Assert.assertEquals((Object)w2, (Object)w3);
        Assert.assertEquals((Object)w1, (Object)w3);
        Assert.assertEquals((long)w1.hashCode(), (long)w3.hashCode());
        Assert.assertNotEquals((String)"must be false for null", null, (Object)w1);
        Assert.assertNotEquals((String)"must be false for different window types", (Object)UnlimitedWindows.of(), (Object)w1);
        Assert.assertNotEquals((String)"must be false for different types", (Object)new Object(), (Object)w1);
        TimeWindows differentWindowSize = TimeWindows.of(w1.sizeMs + 1L);
        Assert.assertNotEquals((String)"must be false when window sizes are different", (Object)differentWindowSize, (Object)w1);
        TimeWindows differentAdvanceInterval = w1.advanceBy(w1.advanceMs - 1L);
        Assert.assertNotEquals((String)"must be false when advance intervals are different", (Object)differentAdvanceInterval, (Object)w1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustNotBeZero() {
        TimeWindows.of(0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void windowSizeMustNotBeNegative() {
        TimeWindows.of(-1L);
    }

    @Test
    public void advanceIntervalMustNotBeZero() {
        TimeWindows windowSpec = TimeWindows.of(123L);
        try {
            windowSpec.advanceBy(0L);
            Assert.fail((String)"should not accept zero advance parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void advanceIntervalMustNotBeNegative() {
        TimeWindows windowSpec = TimeWindows.of(123L);
        try {
            windowSpec.advanceBy(-1L);
            Assert.fail((String)"should not accept negative advance parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void advanceIntervalMustNotBeLargerThanWindowSize() {
        TimeWindows windowSpec = TimeWindows.of(123L);
        try {
            windowSpec.advanceBy(124L);
            Assert.fail((String)"should not accept advance greater than window size");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void retentionTimeMustNoBeSmallerThanWindowSize() {
        TimeWindows windowSpec = TimeWindows.of(123L);
        try {
            windowSpec.until(122L);
            Assert.fail((String)"should not accept retention time smaller than window size");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldComputeWindowsForHoppingWindows() {
        TimeWindows windows = TimeWindows.of(12L).advanceBy(5L);
        Map<Long, TimeWindow> matched = windows.windowsFor(21L);
        Assert.assertEquals((long)3L, (long)matched.size());
        Assert.assertEquals((Object)new TimeWindow(10L, 22L), (Object)matched.get(10L));
        Assert.assertEquals((Object)new TimeWindow(15L, 27L), (Object)matched.get(15L));
        Assert.assertEquals((Object)new TimeWindow(20L, 32L), (Object)matched.get(20L));
    }

    @Test
    public void shouldComputeWindowsForBarelyOverlappingHoppingWindows() {
        TimeWindows windows = TimeWindows.of(6L).advanceBy(5L);
        Map<Long, TimeWindow> matched = windows.windowsFor(7L);
        Assert.assertEquals((long)1L, (long)matched.size());
        Assert.assertEquals((Object)new TimeWindow(5L, 11L), (Object)matched.get(5L));
    }

    @Test
    public void shouldComputeWindowsForTumblingWindows() {
        TimeWindows windows = TimeWindows.of(12L);
        Map<Long, TimeWindow> matched = windows.windowsFor(21L);
        Assert.assertEquals((long)1L, (long)matched.size());
        Assert.assertEquals((Object)new TimeWindow(12L, 24L), (Object)matched.get(12L));
    }
}

