/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.InternalValueTransformerWithKey;
import org.apache.kafka.streams.kstream.internals.InternalValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowStore;

public abstract class AbstractStream<K> {
    protected final InternalStreamsBuilder builder;
    protected final String name;
    final Set<String> sourceNodes;

    public AbstractStream(AbstractStream<K> stream) {
        this.builder = stream.builder;
        this.name = stream.name;
        this.sourceNodes = stream.sourceNodes;
    }

    AbstractStream(InternalStreamsBuilder builder, String name, Set<String> sourceNodes) {
        if (sourceNodes == null || sourceNodes.isEmpty()) {
            throw new IllegalArgumentException("parameter <sourceNodes> must not be null or empty");
        }
        this.builder = builder;
        this.name = name;
        this.sourceNodes = sourceNodes;
    }

    Set<String> ensureJoinableWith(AbstractStream<K> other) {
        HashSet<String> allSourceNodes = new HashSet<String>();
        allSourceNodes.addAll(this.sourceNodes);
        allSourceNodes.addAll(other.sourceNodes);
        this.builder.internalTopologyBuilder.copartitionSources(allSourceNodes);
        return allSourceNodes;
    }

    String getOrCreateName(String queryableStoreName, String prefix) {
        String returnName = queryableStoreName != null ? queryableStoreName : this.builder.newStoreName(prefix);
        Topic.validate(returnName);
        return returnName;
    }

    static <T2, T1, R> ValueJoiner<T2, T1, R> reverseJoiner(final ValueJoiner<T1, T2, R> joiner) {
        return new ValueJoiner<T2, T1, R>(){

            @Override
            public R apply(T2 value2, T1 value1) {
                return joiner.apply(value1, value2);
            }
        };
    }

    static <T, K> StateStoreSupplier<KeyValueStore> keyValueStore(Serde<K> keySerde, Serde<T> aggValueSerde, String storeName) {
        Objects.requireNonNull(storeName, "storeName can't be null");
        Topic.validate(storeName);
        return AbstractStream.storeFactory(keySerde, aggValueSerde, storeName).build();
    }

    static <W extends Window, T, K> StateStoreSupplier<WindowStore> windowedStore(Serde<K> keySerde, Serde<T> aggValSerde, Windows<W> windows, String storeName) {
        Objects.requireNonNull(storeName, "storeName can't be null");
        Topic.validate(storeName);
        return AbstractStream.storeFactory(keySerde, aggValSerde, storeName).windowed(windows.size(), windows.maintainMs(), windows.segments, false).build();
    }

    static <T, K> Stores.PersistentKeyValueFactory<K, T> storeFactory(Serde<K> keySerde, Serde<T> aggValueSerde, String storeName) {
        return Stores.create(storeName).withKeys(keySerde).withValues(aggValueSerde).persistent().enableCaching();
    }

    static <K, V, VR> ValueMapperWithKey<K, V, VR> withKey(final ValueMapper<V, VR> valueMapper) {
        Objects.requireNonNull(valueMapper, "valueMapper can't be null");
        return new ValueMapperWithKey<K, V, VR>(){

            @Override
            public VR apply(K readOnlyKey, V value) {
                return valueMapper.apply(value);
            }
        };
    }

    static <K, V, VR> InternalValueTransformerWithKeySupplier<K, V, VR> toInternalValueTransformerSupplier(final ValueTransformerSupplier<V, VR> valueTransformerSupplier) {
        Objects.requireNonNull(valueTransformerSupplier, "valueTransformerSupplier can't be null");
        return new InternalValueTransformerWithKeySupplier<K, V, VR>(){

            @Override
            public InternalValueTransformerWithKey<K, V, VR> get() {
                final ValueTransformer valueTransformer = valueTransformerSupplier.get();
                return new InternalValueTransformerWithKey<K, V, VR>(){

                    @Override
                    public VR punctuate(long timestamp) {
                        return valueTransformer.punctuate(timestamp);
                    }

                    @Override
                    public void init(ProcessorContext context) {
                        valueTransformer.init(context);
                    }

                    @Override
                    public VR transform(K readOnlyKey, V value) {
                        return valueTransformer.transform(value);
                    }

                    @Override
                    public void close() {
                        valueTransformer.close();
                    }
                };
            }
        };
    }

    static <K, V, VR> InternalValueTransformerWithKeySupplier<K, V, VR> toInternalValueTransformerSupplier(final ValueTransformerWithKeySupplier<K, V, VR> valueTransformerWithKeySupplier) {
        Objects.requireNonNull(valueTransformerWithKeySupplier, "valueTransformerSupplier can't be null");
        return new InternalValueTransformerWithKeySupplier<K, V, VR>(){

            @Override
            public InternalValueTransformerWithKey<K, V, VR> get() {
                final ValueTransformerWithKey valueTransformerWithKey = valueTransformerWithKeySupplier.get();
                return new InternalValueTransformerWithKey<K, V, VR>(){

                    @Override
                    public VR punctuate(long timestamp) {
                        throw new StreamsException("ValueTransformerWithKey#punctuate should not be called.");
                    }

                    @Override
                    public void init(ProcessorContext context) {
                        valueTransformerWithKey.init(context);
                    }

                    @Override
                    public VR transform(K readOnlyKey, V value) {
                        return valueTransformerWithKey.transform(readOnlyKey, value);
                    }

                    @Override
                    public void close() {
                        valueTransformerWithKey.close();
                    }
                };
            }
        };
    }
}

